/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistNormal;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistLogNormal
extends DistNormal {
    public DistLogNormal(StreamInterface stream, double mu, double sigma) {
        super(stream);
        this.mu = mu;
        if (!(sigma > 0.0)) {
            throw new IllegalArgumentException("Error DistLogNormal - sigma<=0.0");
        }
        this.sigma = sigma;
    }

    public double draw() {
        double y = this.mu + this.sigma * super.nextGaussian();
        return Math.exp(y);
    }

    public double probDensity(double observation) {
        if (observation > 0.0) {
            return 1.0 / (observation * Math.sqrt(Math.PI * 2 * Math.pow(this.sigma, 2.0))) * Math.exp(-1.0 * Math.pow(Math.log(observation) - this.mu, 2.0) / (2.0 * Math.pow(this.sigma, 2.0)));
        }
        return 0.0;
    }

    public String toString() {
        return "LogNormal(" + this.mu + "," + this.sigma + ")";
    }
}

