/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistGamma;
import nl.tudelft.simulation.jstats.math.ProbMath;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistErlang
extends DistContinuous {
    private int k;
    private double beta;
    private double betak;
    private DistGamma distGamma;
    private static final short GAMMABORDER = 10;

    public DistErlang(StreamInterface stream, int k, double beta) {
        super(stream);
        if (k <= 0 || !(beta > 0.0)) {
            throw new IllegalArgumentException("Error Erlang - k <= 0 or beta < 0");
        }
        this.k = k;
        this.beta = beta;
        if (this.k <= 10) {
            this.betak = -this.beta / (double)this.k;
        } else {
            this.distGamma = new DistGamma(stream, this.k, this.beta);
        }
    }

    public double draw() {
        if (this.k <= 10) {
            double product = 1.0;
            for (int i = 1; i <= this.k; ++i) {
                product *= this.stream.nextDouble();
            }
            return this.betak * Math.log(product);
        }
        return this.distGamma.draw();
    }

    public double probDensity(double observation) {
        if (observation < 0.0) {
            return 0.0;
        }
        return this.beta * Math.exp(-this.beta * observation * (Math.pow(this.beta * observation, this.k - 1) / ProbMath.faculty(this.k - 1)));
    }

    public String toString() {
        return "Erlang(" + this.k + "," + this.beta + ")";
    }
}

