/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistDiscreteUniform
extends DistDiscrete {
    private long min;
    private long max;

    public DistDiscreteUniform(StreamInterface stream, long min, long max) {
        super(stream);
        this.min = min;
        if (max < this.min) {
            throw new IllegalArgumentException("Error Discrete Uniform - min >= max");
        }
        this.max = max;
    }

    public long draw() {
        return this.stream.nextInt((int)this.min, (int)this.max);
    }

    public double probability(int observation) {
        if ((long)observation > this.min && (long)observation < this.max) {
            return 1.0 / ((double)this.max - (double)this.min + 1.0);
        }
        return 0.0;
    }

    public String toString() {
        return "DiscreteUniform(" + this.min + "," + this.max + ")";
    }
}

