/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantDouble;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantLong;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;

public class LDC2_W
extends VoidOperation {
    public static final int OP = 20;
    private int index = -1;

    public LDC2_W(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
    }

    public void execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        Constant constant = constantPool[this.index];
        if (constant instanceof ConstantLong) {
            stack.push(new Long(((ConstantLong)constant).getValue()));
        } else if (constant instanceof ConstantDouble) {
            stack.push(new Double(((ConstantDouble)constant).getValue()));
        }
    }

    public int getByteLength() {
        return 3;
    }

    public int getOpcode() {
        return 20;
    }
}

