/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.HandshakeHeader;
import dev.miku.r2dbc.mysql.message.server.HandshakeRequest;
import dev.miku.r2dbc.mysql.message.server.ServerStatusMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class HandshakeV10Request
implements HandshakeRequest,
ServerStatusMessage {
    private static final int RESERVED_SIZE = 10;
    private static final int MIN_SALT_SECOND_PART_SIZE = 12;
    private final HandshakeHeader header;
    private final byte[] salt;
    private final int serverCapabilities;
    private final byte collationLow8Bits;
    private final short serverStatuses;
    private final String authType;

    private HandshakeV10Request(HandshakeHeader header, byte[] salt, int serverCapabilities, byte collationLow8Bits, short serverStatuses, String authType) {
        this.header = AssertUtils.requireNonNull(header, "header must not be null");
        this.salt = AssertUtils.requireNonNull(salt, "salt must not be null");
        this.serverCapabilities = serverCapabilities;
        this.collationLow8Bits = collationLow8Bits;
        this.serverStatuses = serverStatuses;
        this.authType = AssertUtils.requireNonNull(authType, "authType must not be null");
    }

    @Override
    public HandshakeHeader getHeader() {
        return this.header;
    }

    @Override
    public byte[] getSalt() {
        return this.salt;
    }

    @Override
    public int getServerCapabilities() {
        return this.serverCapabilities;
    }

    @Override
    public short getServerStatuses() {
        return this.serverStatuses;
    }

    @Override
    public String getAuthType() {
        return this.authType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HandshakeV10Request)) {
            return false;
        }
        HandshakeV10Request that = (HandshakeV10Request)o;
        if (this.serverCapabilities != that.serverCapabilities) {
            return false;
        }
        if (this.collationLow8Bits != that.collationLow8Bits) {
            return false;
        }
        if (this.serverStatuses != that.serverStatuses) {
            return false;
        }
        if (!this.header.equals(that.header)) {
            return false;
        }
        if (!Arrays.equals(this.salt, that.salt)) {
            return false;
        }
        return this.authType.equals(that.authType);
    }

    public int hashCode() {
        int result = this.header.hashCode();
        result = 31 * result + Arrays.hashCode(this.salt);
        result = 31 * result + this.serverCapabilities;
        result = 31 * result + this.collationLow8Bits;
        result = 31 * result + this.serverStatuses;
        result = 31 * result + this.authType.hashCode();
        return result;
    }

    public String toString() {
        return String.format("HandshakeV10Request{header=%s, salt=REDACTED, serverCapabilities=%x, collationLow8Bits=%d, serverStatuses=%x, authType=%s}", this.header, this.serverCapabilities, this.collationLow8Bits, this.serverStatuses, this.authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HandshakeV10Request decodeV10(ByteBuf buf, HandshakeHeader header) {
        Builder builder = new Builder().header(header);
        CompositeByteBuf salt = buf.alloc().compositeBuffer(2);
        try {
            int serverCapabilities;
            salt.addComponent(true, HandshakeV10Request.readCStringRetainedSlice(buf));
            CompositeByteBuf capabilities = buf.alloc().compositeBuffer(2);
            try {
                capabilities.addComponent(true, buf.readRetainedSlice(2));
                builder.collationLow8Bits(buf.readByte()).serverStatuses(buf.readShortLE());
                serverCapabilities = capabilities.addComponent(true, buf.readRetainedSlice(2)).readIntLE();
                builder.serverCapabilities(serverCapabilities);
            }
            finally {
                capabilities.release();
            }
            HandshakeV10Request handshakeV10Request = HandshakeV10Request.afterCapabilities(builder, buf, serverCapabilities, salt);
            return handshakeV10Request;
        }
        finally {
            salt.release();
        }
    }

    private static ByteBuf readCStringRetainedSlice(ByteBuf buf) {
        int bytes = buf.bytesBefore((byte)0);
        if (bytes < 0) {
            throw new IllegalArgumentException("buf has no C-style string");
        }
        if (bytes == 0) {
            buf.skipBytes(1);
            return buf.alloc().buffer(0, 0);
        }
        ByteBuf result = buf.readSlice(bytes);
        buf.skipBytes(1);
        return result.retain();
    }

    private static HandshakeV10Request afterCapabilities(Builder builder, ByteBuf buf, int serverCapabilities, CompositeByteBuf salt) {
        short saltSize;
        boolean isPluginAuth;
        boolean bl = isPluginAuth = (serverCapabilities & 0x80000) != 0;
        if (isPluginAuth) {
            saltSize = buf.readUnsignedByte();
        } else {
            saltSize = 0;
            buf.skipBytes(1);
        }
        buf.skipBytes(10);
        if ((serverCapabilities & 0x8000) != 0) {
            int saltSecondPartSize = Math.max(12, saltSize - salt.readableBytes() - 1);
            ByteBuf saltSecondPart = buf.readSlice(saltSecondPartSize);
            buf.skipBytes(1);
            salt.addComponent(true, saltSecondPart.retain());
        }
        builder.salt(ByteBufUtil.getBytes((ByteBuf)salt));
        if (isPluginAuth) {
            int length = buf.bytesBefore((byte)0);
            String authType = length < 0 ? buf.toString(StandardCharsets.US_ASCII) : (length == 0 ? "" : buf.toString(buf.readerIndex(), length, StandardCharsets.US_ASCII));
            builder.authType(authType);
        } else {
            builder.authType("");
        }
        return builder.build();
    }

    private static final class Builder {
        private HandshakeHeader header;
        private String authType;
        private byte collationLow8Bits;
        private byte[] salt;
        private int serverCapabilities;
        private short serverStatuses;

        private Builder() {
        }

        HandshakeV10Request build() {
            return new HandshakeV10Request(this.header, this.salt, this.serverCapabilities, this.collationLow8Bits, this.serverStatuses, this.authType);
        }

        void authType(String authType) {
            this.authType = authType;
        }

        Builder collationLow8Bits(byte collationLow8Bits) {
            this.collationLow8Bits = collationLow8Bits;
            return this;
        }

        Builder header(HandshakeHeader header) {
            this.header = header;
            return this;
        }

        void salt(byte[] salt) {
            this.salt = salt;
        }

        void serverCapabilities(int serverCapabilities) {
            this.serverCapabilities = serverCapabilities;
        }

        void serverStatuses(short serverStatuses) {
            this.serverStatuses = serverStatuses;
        }
    }
}

