/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.message.client.ExchangeableMessage;
import dev.miku.r2dbc.mysql.message.client.LargeClientMessage;
import dev.miku.r2dbc.mysql.message.client.ParamWriter;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

public final class TextQueryMessage
extends LargeClientMessage
implements ExchangeableMessage {
    private final List<String> sqlParts;
    private final Parameter[] values;
    private final Consumer<String> sqlProceed;

    public TextQueryMessage(List<String> sqlParts, Parameter[] values, Consumer<String> sqlProceed) {
        AssertUtils.requireNonNull(sqlParts, "sql parts must not be null");
        AssertUtils.requireNonNull(values, "values must not be null");
        AssertUtils.requireNonNull(sqlProceed, "sqlProceed must not be null");
        AssertUtils.require(sqlParts.size() - 1 == values.length, "sql parts size must not be parameters size + 1");
        this.sqlParts = sqlParts;
        this.values = values;
        this.sqlProceed = sqlProceed;
    }

    public String toString() {
        return "TextQueryMessage{sqlParts=REDACTED, values=REDACTED}";
    }

    protected Mono<ByteBuf> fragments(ByteBufAllocator allocator, ConnectionContext context) {
        try {
            Charset charset = context.getClientCollation().getCharset();
            return ParamWriter.publish(this.sqlParts, this.values).map(sql -> {
                this.sqlProceed.accept((String)sql);
                ByteBuf buf = allocator.buffer(sql.length(), Integer.MAX_VALUE);
                buf.writeByte(3).writeCharSequence((CharSequence)sql, charset);
                return buf;
            });
        }
        catch (Throwable e) {
            return Mono.error((Throwable)e);
        }
    }
}

