/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.collation;

import dev.miku.r2dbc.mysql.collation.AbstractCharsetTarget;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

final class NamedCharsetTarget
extends AbstractCharsetTarget {
    private final String charsetName;

    NamedCharsetTarget(int byteSize, String charsetName) {
        super(byteSize);
        this.charsetName = AssertUtils.requireNonNull(charsetName, "charsetName must not be null");
    }

    @Override
    public Charset getCharset() throws UnsupportedCharsetException {
        return Charset.forName(this.charsetName);
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedCharsetTarget)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedCharsetTarget that = (NamedCharsetTarget)o;
        return this.charsetName.equals(that.charsetName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.charsetName.hashCode();
        return result;
    }

    public String toString() {
        return String.format("NamedCharsetTarget{charsetName='%s', byteSize=%d}", this.charsetName, this.byteSize);
    }
}

