/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.ShortCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.publisher.Mono;

final class IntegerCodec
extends AbstractPrimitiveCodec<Integer> {
    IntegerCodec(ByteBufAllocator allocator) {
        super(allocator, Integer.TYPE, Integer.class);
    }

    @Override
    public Integer decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        if (binary) {
            boolean isUnsigned = (info.getDefinitions() & 0x20) != 0;
            return IntegerCodec.decodeBinary(value, info.getType(), isUnsigned);
        }
        return IntegerCodec.parse(value);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Integer;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        int v = (Integer)value;
        if ((byte)v == v) {
            return new ByteCodec.ByteParameter(this.allocator, (byte)v);
        }
        if ((short)v == v) {
            return new ShortCodec.ShortParameter(this.allocator, (short)v);
        }
        return new IntParameter(this.allocator, v);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        return IntegerCodec.isLowerInt(type) || 3 == type && (info.getDefinitions() & 0x20) == 0;
    }

    static int parse(ByteBuf buf) {
        int value;
        boolean isNegative;
        byte first = buf.readByte();
        if (first == 45) {
            isNegative = true;
            value = 0;
        } else if (first >= 48 && first <= 57) {
            isNegative = false;
            value = first - 48;
        } else {
            isNegative = false;
            value = 0;
        }
        while (buf.isReadable()) {
            value = value * 10 + (buf.readByte() - 48);
        }
        return isNegative ? -value : value;
    }

    private static boolean isLowerInt(short type) {
        return 1 == type || 13 == type || 2 == type || 9 == type;
    }

    private static int decodeBinary(ByteBuf buf, short type, boolean isUnsigned) {
        switch (type) {
            case 3: 
            case 9: {
                return buf.readIntLE();
            }
            case 2: {
                if (isUnsigned) {
                    return buf.readUnsignedShortLE();
                }
                return buf.readShortLE();
            }
            case 13: {
                return buf.readShortLE();
            }
        }
        if (isUnsigned) {
            return buf.readUnsignedByte();
        }
        return buf.readByte();
    }

    static final class IntParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final int value;

        IntParameter(ByteBufAllocator allocator, int value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> {
                ByteBuf buf = this.allocator.buffer(4);
                try {
                    return buf.writeIntLE(this.value);
                }
                catch (Throwable e) {
                    buf.release();
                    throw e;
                }
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeInt(this.value));
        }

        @Override
        public short getType() {
            return 3;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntParameter)) {
                return false;
            }
            IntParameter intValue = (IntParameter)o;
            return this.value == intValue.value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

