/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.ollama.spring;

import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.spring.restclient.SpringRestClient;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.OllamaEmbeddingModel;
import dev.langchain4j.model.ollama.OllamaLanguageModel;
import dev.langchain4j.model.ollama.OllamaStreamingChatModel;
import dev.langchain4j.model.ollama.OllamaStreamingLanguageModel;
import dev.langchain4j.ollama.spring.ChatModelProperties;
import dev.langchain4j.ollama.spring.EmbeddingModelProperties;
import dev.langchain4j.ollama.spring.LanguageModelProperties;
import dev.langchain4j.ollama.spring.Properties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.support.ContextPropagatingTaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class})
@EnableConfigurationProperties(value={Properties.class})
public class AutoConfig {
    private static final String TASK_EXECUTOR_THREAD_NAME_PREFIX = "LangChain4j-Ollama-";
    private static final String CHAT_MODEL_HTTP_CLIENT_BUILDER = "ollamaChatModelHttpClientBuilder";
    private static final String STREAMING_CHAT_MODEL_HTTP_CLIENT_BUILDER = "ollamaStreamingChatModelHttpClientBuilder";
    private static final String STREAMING_CHAT_MODEL_TASK_EXECUTOR = "ollamaStreamingChatModelTaskExecutor";
    private static final String LANGUAGE_MODEL_HTTP_CLIENT_BUILDER = "ollamaLanguageModelHttpClientBuilder";
    private static final String STREAMING_LANGUAGE_MODEL_HTTP_CLIENT_BUILDER = "ollamaStreamingLanguageModelHttpClientBuilder";
    private static final String STREAMING_LANGUAGE_MODEL_TASK_EXECUTOR = "ollamaStreamingLanguageModelTaskExecutor";
    private static final String EMBEDDING_MODEL_HTTP_CLIENT_BUILDER = "ollamaEmbeddingModelHttpClientBuilder";

    @Bean
    @ConditionalOnProperty(value={"langchain4j.ollama.chat-model.base-url"})
    OllamaChatModel ollamaChatModel(@Qualifier(value="ollamaChatModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties, ObjectProvider<ChatModelListener> listeners) {
        ChatModelProperties chatModelProperties = properties.getChatModel();
        return OllamaChatModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(chatModelProperties.getBaseUrl()).modelName(chatModelProperties.getModelName()).temperature(chatModelProperties.getTemperature()).topK(chatModelProperties.getTopK()).topP(chatModelProperties.getTopP()).repeatPenalty(chatModelProperties.getRepeatPenalty()).seed(chatModelProperties.getSeed()).numPredict(chatModelProperties.getNumPredict()).stop(chatModelProperties.getStop()).format(chatModelProperties.getFormat()).supportedCapabilities(chatModelProperties.getSupportedCapabilities()).timeout(chatModelProperties.getTimeout()).maxRetries(chatModelProperties.getMaxRetries()).customHeaders(chatModelProperties.getCustomHeaders()).logRequests(chatModelProperties.getLogRequests()).logResponses(chatModelProperties.getLogResponses()).listeners(listeners.orderedStream().toList()).build();
    }

    @Bean(value={"ollamaChatModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.ollama.chat-model.base-url"})
    @ConditionalOnMissingBean(name={"ollamaChatModelHttpClientBuilder"})
    HttpClientBuilder ollamaChatModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.ollama.streaming-chat-model.base-url"})
    OllamaStreamingChatModel ollamaStreamingChatModel(@Qualifier(value="ollamaStreamingChatModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties, ObjectProvider<ChatModelListener> listeners) {
        ChatModelProperties chatModelProperties = properties.getStreamingChatModel();
        return OllamaStreamingChatModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(chatModelProperties.getBaseUrl()).modelName(chatModelProperties.getModelName()).temperature(chatModelProperties.getTemperature()).topK(chatModelProperties.getTopK()).topP(chatModelProperties.getTopP()).repeatPenalty(chatModelProperties.getRepeatPenalty()).seed(chatModelProperties.getSeed()).numPredict(chatModelProperties.getNumPredict()).stop(chatModelProperties.getStop()).format(chatModelProperties.getFormat()).supportedCapabilities(chatModelProperties.getSupportedCapabilities()).timeout(chatModelProperties.getTimeout()).customHeaders(chatModelProperties.getCustomHeaders()).logRequests(chatModelProperties.getLogRequests()).logResponses(chatModelProperties.getLogResponses()).listeners(listeners.orderedStream().toList()).build();
    }

    @Bean(value={"ollamaStreamingChatModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.ollama.streaming-chat-model.base-url"})
    @ConditionalOnMissingBean(name={"ollamaStreamingChatModelHttpClientBuilder"})
    HttpClientBuilder ollamaStreamingChatModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder, @Qualifier(value="ollamaStreamingChatModelTaskExecutor") AsyncTaskExecutor executor) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).streamingRequestExecutor(executor);
    }

    @Bean(value={"ollamaStreamingChatModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.ollama.streaming-chat-model.base-url"})
    @ConditionalOnMissingBean(name={"ollamaStreamingChatModelTaskExecutor"})
    @ConditionalOnClass(name={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor ollamaStreamingChatModelTaskExecutorWithContextPropagation() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        taskExecutor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator());
        return taskExecutor;
    }

    @Bean(value={"ollamaStreamingChatModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.ollama.streaming-chat-model.base-url"})
    @ConditionalOnMissingBean(name={"ollamaStreamingChatModelTaskExecutor"})
    @ConditionalOnMissingClass(value={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor ollamaStreamingChatModelTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        return taskExecutor;
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.ollama.language-model.base-url"})
    OllamaLanguageModel ollamaLanguageModel(@Qualifier(value="ollamaLanguageModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        LanguageModelProperties languageModelProperties = properties.getLanguageModel();
        return OllamaLanguageModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(languageModelProperties.getBaseUrl()).modelName(languageModelProperties.getModelName()).temperature(languageModelProperties.getTemperature()).topK(languageModelProperties.getTopK()).topP(languageModelProperties.getTopP()).repeatPenalty(languageModelProperties.getRepeatPenalty()).seed(languageModelProperties.getSeed()).numPredict(languageModelProperties.getNumPredict()).stop(languageModelProperties.getStop()).format(languageModelProperties.getFormat()).timeout(languageModelProperties.getTimeout()).maxRetries(languageModelProperties.getMaxRetries()).customHeaders(languageModelProperties.getCustomHeaders()).logRequests(languageModelProperties.getLogRequests()).logResponses(languageModelProperties.getLogResponses()).build();
    }

    @Bean(value={"ollamaLanguageModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.ollama.language-model.base-url"})
    @ConditionalOnMissingBean(name={"ollamaLanguageModelHttpClientBuilder"})
    HttpClientBuilder ollamaLanguageModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.ollama.streaming-language-model.base-url"})
    OllamaStreamingLanguageModel ollamaStreamingLanguageModel(@Qualifier(value="ollamaStreamingLanguageModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        LanguageModelProperties languageModelProperties = properties.getStreamingLanguageModel();
        return OllamaStreamingLanguageModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(languageModelProperties.getBaseUrl()).modelName(languageModelProperties.getModelName()).temperature(languageModelProperties.getTemperature()).topK(languageModelProperties.getTopK()).topP(languageModelProperties.getTopP()).repeatPenalty(languageModelProperties.getRepeatPenalty()).seed(languageModelProperties.getSeed()).numPredict(languageModelProperties.getNumPredict()).stop(languageModelProperties.getStop()).format(languageModelProperties.getFormat()).timeout(languageModelProperties.getTimeout()).customHeaders(languageModelProperties.getCustomHeaders()).logRequests(languageModelProperties.getLogRequests()).logResponses(languageModelProperties.getLogResponses()).build();
    }

    @Bean(value={"ollamaStreamingLanguageModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.ollama.streaming-language-model.base-url"})
    @ConditionalOnMissingBean(name={"ollamaStreamingLanguageModelHttpClientBuilder"})
    HttpClientBuilder ollamaStreamingLanguageModelHttpClientBuilder(@Qualifier(value="ollamaStreamingLanguageModelTaskExecutor") AsyncTaskExecutor executor, ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).streamingRequestExecutor(executor);
    }

    @Bean(value={"ollamaStreamingLanguageModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.ollama.streaming-language-model.base-url"})
    @ConditionalOnMissingBean(name={"ollamaStreamingLanguageModelTaskExecutor"})
    @ConditionalOnClass(name={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor ollamaStreamingLanguageModelTaskExecutorWithContextPropagation() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        taskExecutor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator());
        return taskExecutor;
    }

    @Bean(value={"ollamaStreamingLanguageModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.ollama.streaming-language-model.base-url"})
    @ConditionalOnMissingBean(name={"ollamaStreamingLanguageModelTaskExecutor"})
    @ConditionalOnMissingClass(value={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor ollamaStreamingLanguageModelTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        return taskExecutor;
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.ollama.embedding-model.base-url"})
    OllamaEmbeddingModel ollamaEmbeddingModel(@Qualifier(value="ollamaEmbeddingModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        EmbeddingModelProperties embeddingModelProperties = properties.getEmbeddingModel();
        return OllamaEmbeddingModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(embeddingModelProperties.getBaseUrl()).modelName(embeddingModelProperties.getModelName()).timeout(embeddingModelProperties.getTimeout()).maxRetries(embeddingModelProperties.getMaxRetries()).customHeaders(embeddingModelProperties.getCustomHeaders()).logRequests(embeddingModelProperties.getLogRequests()).logResponses(embeddingModelProperties.getLogResponses()).build();
    }

    @Bean(value={"ollamaEmbeddingModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.ollama.embedding-model.base-url"})
    @ConditionalOnMissingBean(name={"ollamaEmbeddingModelHttpClientBuilder"})
    HttpClientBuilder ollamaEmbeddingModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }
}

