/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.qianfan.client;

import dev.langchain4j.community.model.qianfan.client.AsyncRequestExecutor;
import dev.langchain4j.community.model.qianfan.client.AsyncResponseHandling;
import dev.langchain4j.community.model.qianfan.client.StreamingRequestExecutor;
import dev.langchain4j.community.model.qianfan.client.StreamingResponseHandling;
import dev.langchain4j.community.model.qianfan.client.SyncOrAsyncOrStreaming;
import dev.langchain4j.community.model.qianfan.client.SyncRequestExecutor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

public class RequestExecutor<Request, Response, ResponseContent>
implements SyncOrAsyncOrStreaming<ResponseContent> {
    private static final Logger LOG = LoggerFactory.getLogger(RequestExecutor.class);
    private final Call<Response> call;
    private final Function<Response, ResponseContent> responseContentExtractor;
    private final OkHttpClient okHttpClient;
    private final String endpointUrl;
    private final Supplier<Request> requestWithStreamSupplier;
    private final Class<Response> responseClass;
    private final Function<Response, ResponseContent> streamEventContentExtractor;
    private final boolean logStreamingResponses;

    public RequestExecutor(Call<Response> call, Function<Response, ResponseContent> responseContentExtractor, OkHttpClient okHttpClient, String endpointUrl, Supplier<Request> requestWithStreamSupplier, Class<Response> responseClass, Function<Response, ResponseContent> streamEventContentExtractor, boolean logStreamingResponses) {
        this.call = call;
        this.responseContentExtractor = responseContentExtractor;
        this.okHttpClient = okHttpClient;
        this.endpointUrl = endpointUrl;
        this.requestWithStreamSupplier = requestWithStreamSupplier;
        this.responseClass = responseClass;
        this.streamEventContentExtractor = streamEventContentExtractor;
        this.logStreamingResponses = logStreamingResponses;
    }

    public RequestExecutor(Call<Response> call, Function<Response, ResponseContent> responseContentExtractor, Supplier<Request> requestWithStreamSupplier, Class<Response> responseClass, Function<Response, ResponseContent> streamEventContentExtractor) {
        this.call = call;
        this.responseContentExtractor = responseContentExtractor;
        this.requestWithStreamSupplier = requestWithStreamSupplier;
        this.responseClass = responseClass;
        this.streamEventContentExtractor = streamEventContentExtractor;
        this.okHttpClient = null;
        this.endpointUrl = null;
        this.logStreamingResponses = false;
    }

    public RequestExecutor(Call<Response> call, Function<Response, ResponseContent> responseContentExtractor) {
        this.call = call;
        this.responseContentExtractor = responseContentExtractor;
        this.okHttpClient = null;
        this.endpointUrl = null;
        this.requestWithStreamSupplier = null;
        this.responseClass = null;
        this.streamEventContentExtractor = null;
        this.logStreamingResponses = false;
    }

    @Override
    public ResponseContent execute() {
        return new SyncRequestExecutor<Response, ResponseContent>(this.call, this.responseContentExtractor).execute();
    }

    @Override
    public AsyncResponseHandling onResponse(Consumer<ResponseContent> responseContentConsumer) {
        return new AsyncRequestExecutor<Response, ResponseContent>(this.call, this.responseContentExtractor).onResponse(responseContentConsumer);
    }

    @Override
    public StreamingResponseHandling onPartialResponse(Consumer<ResponseContent> responseContentConsumer) {
        return new StreamingRequestExecutor<Request, Response, ResponseContent>(this.okHttpClient, this.endpointUrl, this.requestWithStreamSupplier, this.responseClass, this.streamEventContentExtractor, this.logStreamingResponses).onPartialResponse(responseContentConsumer);
    }
}

