/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolCall;
import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.Choice;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsFinishReason;
import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.TokenCountEstimator;
import dev.langchain4j.model.azure.InternalAzureOpenAiHelper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
class InternalAzureOpenAiStreamingResponseBuilder {
    private final Integer inputTokenCount;
    private final StringBuffer contentBuilder = new StringBuffer();
    private String toolExecutionsIndex = "call_undefined";
    private final Map<String, ToolExecutionRequestBuilder> toolExecutionRequestBuilderHashMap = new HashMap<String, ToolExecutionRequestBuilder>();
    private volatile CompletionsFinishReason finishReason;

    InternalAzureOpenAiStreamingResponseBuilder(Integer inputTokenCount) {
        this.inputTokenCount = inputTokenCount;
    }

    void append(ChatCompletions completions) {
        ChatResponseMessage delta;
        if (completions == null) {
            return;
        }
        List choices = completions.getChoices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        ChatChoice chatCompletionChoice = (ChatChoice)choices.get(0);
        if (chatCompletionChoice == null) {
            return;
        }
        CompletionsFinishReason finishReason = chatCompletionChoice.getFinishReason();
        if (finishReason != null) {
            this.finishReason = finishReason;
        }
        if ((delta = chatCompletionChoice.getDelta()) == null) {
            return;
        }
        String content = delta.getContent();
        if (content != null) {
            this.contentBuilder.append(content);
            return;
        }
        if (delta.getToolCalls() != null && !delta.getToolCalls().isEmpty()) {
            for (ChatCompletionsToolCall toolCall : delta.getToolCalls()) {
                ToolExecutionRequestBuilder toolExecutionRequestBuilder;
                if (toolCall.getId() != null) {
                    this.toolExecutionsIndex = toolCall.getId();
                    toolExecutionRequestBuilder = new ToolExecutionRequestBuilder();
                    toolExecutionRequestBuilder.idBuilder.append(this.toolExecutionsIndex);
                    this.toolExecutionRequestBuilderHashMap.put(this.toolExecutionsIndex, toolExecutionRequestBuilder);
                } else {
                    toolExecutionRequestBuilder = this.toolExecutionRequestBuilderHashMap.get(this.toolExecutionsIndex);
                    if (toolExecutionRequestBuilder == null) {
                        throw new IllegalStateException("Function without an id defined in the tool call");
                    }
                }
                if (!(toolCall instanceof ChatCompletionsFunctionToolCall)) continue;
                ChatCompletionsFunctionToolCall functionCall = (ChatCompletionsFunctionToolCall)toolCall;
                if (functionCall.getFunction().getName() != null) {
                    toolExecutionRequestBuilder.nameBuilder.append(functionCall.getFunction().getName());
                }
                if (functionCall.getFunction().getArguments() == null) continue;
                toolExecutionRequestBuilder.argumentsBuilder.append(functionCall.getFunction().getArguments());
            }
        }
    }

    void append(Completions completions) {
        String token;
        if (completions == null) {
            return;
        }
        List choices = completions.getChoices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        Choice completionChoice = (Choice)choices.get(0);
        if (completionChoice == null) {
            return;
        }
        CompletionsFinishReason completionsFinishReason = completionChoice.getFinishReason();
        if (completionsFinishReason != null) {
            this.finishReason = completionsFinishReason;
        }
        if ((token = completionChoice.getText()) != null) {
            this.contentBuilder.append(token);
        }
    }

    Response<AiMessage> build(TokenCountEstimator tokenCountEstimator) {
        String content = this.contentBuilder.toString();
        List toolExecutionRequests = null;
        if (!this.toolExecutionRequestBuilderHashMap.isEmpty()) {
            toolExecutionRequests = this.toolExecutionRequestBuilderHashMap.values().stream().map(it -> ToolExecutionRequest.builder().id(it.idBuilder.toString()).name(it.nameBuilder.toString()).arguments(it.argumentsBuilder.toString()).build()).collect(Collectors.toList());
        }
        AiMessage aiMessage = AiMessage.builder().text(content.isEmpty() ? null : content).toolExecutionRequests(toolExecutionRequests).build();
        TokenUsage tokenUsage = null;
        if (tokenCountEstimator != null) {
            int outputTokenCount = tokenCountEstimator.estimateTokenCountInMessage((ChatMessage)aiMessage);
            tokenUsage = new TokenUsage(this.inputTokenCount, Integer.valueOf(outputTokenCount));
        }
        return Response.from((Object)aiMessage, tokenUsage, (FinishReason)InternalAzureOpenAiHelper.finishReasonFrom(this.finishReason));
    }

    private static class ToolExecutionRequestBuilder {
        private final StringBuffer idBuilder = new StringBuffer();
        private final StringBuffer nameBuilder = new StringBuffer();
        private final StringBuffer argumentsBuilder = new StringBuffer();

        private ToolExecutionRequestBuilder() {
        }
    }
}

