/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.models.Choice;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.ProxyOptions;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.azure.AzureOpenAiStreamingResponseBuilder;
import dev.langchain4j.model.azure.AzureOpenAiTokenizer;
import dev.langchain4j.model.azure.InternalAzureOpenAiHelper;
import dev.langchain4j.model.azure.spi.AzureOpenAiStreamingLanguageModelBuilderFactory;
import dev.langchain4j.model.language.StreamingLanguageModel;
import dev.langchain4j.model.language.TokenCountEstimator;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureOpenAiStreamingLanguageModel
implements StreamingLanguageModel,
TokenCountEstimator {
    private static final Logger logger = LoggerFactory.getLogger(AzureOpenAiStreamingLanguageModel.class);
    private OpenAIClient client;
    private final String deploymentName;
    private final Tokenizer tokenizer;
    private final Integer maxTokens;
    private final Double temperature;
    private final Double topP;
    private final Map<String, Integer> logitBias;
    private final String user;
    private final Integer n;
    private final Integer logprobs;
    private final Boolean echo;
    private final List<String> stop;
    private final Double presencePenalty;
    private final Double frequencyPenalty;

    public AzureOpenAiStreamingLanguageModel(OpenAIClient client, String deploymentName, Tokenizer tokenizer, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, Integer n, Integer logprobs, Boolean echo, List<String> stop, Double presencePenalty, Double frequencyPenalty) {
        this(deploymentName, tokenizer, maxTokens, temperature, topP, logitBias, user, n, logprobs, echo, stop, presencePenalty, frequencyPenalty);
        this.client = client;
    }

    public AzureOpenAiStreamingLanguageModel(String endpoint, String serviceVersion, String apiKey, String deploymentName, Tokenizer tokenizer, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, Integer n, Integer logprobs, Boolean echo, List<String> stop, Double presencePenalty, Double frequencyPenalty, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, String userAgentSuffix, Map<String, String> customHeaders) {
        this(deploymentName, tokenizer, maxTokens, temperature, topP, logitBias, user, n, logprobs, echo, stop, presencePenalty, frequencyPenalty);
        this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, apiKey, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
    }

    public AzureOpenAiStreamingLanguageModel(String endpoint, String serviceVersion, KeyCredential keyCredential, String deploymentName, Tokenizer tokenizer, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, Integer n, Integer logprobs, Boolean echo, List<String> stop, Double presencePenalty, Double frequencyPenalty, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, String userAgentSuffix, Map<String, String> customHeaders) {
        this(deploymentName, tokenizer, maxTokens, temperature, topP, logitBias, user, n, logprobs, echo, stop, presencePenalty, frequencyPenalty);
        this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, keyCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
    }

    public AzureOpenAiStreamingLanguageModel(String endpoint, String serviceVersion, TokenCredential tokenCredential, String deploymentName, Tokenizer tokenizer, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, Integer n, Integer logprobs, Boolean echo, List<String> stop, Double presencePenalty, Double frequencyPenalty, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, String userAgentSuffix, Map<String, String> customHeaders) {
        this(deploymentName, tokenizer, maxTokens, temperature, topP, logitBias, user, n, logprobs, echo, stop, presencePenalty, frequencyPenalty);
        this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, tokenCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
    }

    private AzureOpenAiStreamingLanguageModel(String deploymentName, Tokenizer tokenizer, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, Integer n, Integer logprobs, Boolean echo, List<String> stop, Double presencePenalty, Double frequencyPenalty) {
        this.deploymentName = (String)Utils.getOrDefault((Object)deploymentName, (Object)"gpt-35-turbo-instruct");
        this.tokenizer = (Tokenizer)Utils.getOrDefault((Object)tokenizer, AzureOpenAiTokenizer::new);
        this.maxTokens = maxTokens;
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.topP = topP;
        this.logitBias = logitBias;
        this.user = user;
        this.n = n;
        this.logprobs = logprobs;
        this.echo = echo;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
    }

    public void generate(String prompt, StreamingResponseHandler<String> handler) {
        CompletionsOptions options = new CompletionsOptions(Collections.singletonList(prompt)).setStream(Boolean.valueOf(true)).setModel(this.deploymentName).setMaxTokens(this.maxTokens).setTemperature(this.temperature).setTopP(this.topP).setLogitBias(this.logitBias).setUser(this.user).setN(this.n).setLogprobs(this.logprobs).setEcho(this.echo).setStop(this.stop).setPresencePenalty(this.presencePenalty).setFrequencyPenalty(this.frequencyPenalty);
        Integer inputTokenCount = this.tokenizer == null ? null : Integer.valueOf(this.tokenizer.estimateTokenCountInText(prompt));
        AzureOpenAiStreamingResponseBuilder responseBuilder = new AzureOpenAiStreamingResponseBuilder(inputTokenCount);
        try {
            this.client.getCompletionsStream(this.deploymentName, options).stream().forEach(completions -> {
                responseBuilder.append((Completions)completions);
                AzureOpenAiStreamingLanguageModel.handle(completions, handler);
            });
            Response<AiMessage> response = responseBuilder.build(this.tokenizer, false);
            handler.onComplete(Response.from((Object)((AiMessage)response.content()).text(), (TokenUsage)response.tokenUsage(), (FinishReason)response.finishReason()));
        }
        catch (HttpResponseException httpResponseException) {
            logger.info("Error generating response, {}", httpResponseException.getValue());
            FinishReason exceptionFinishReason = InternalAzureOpenAiHelper.contentFilterManagement(httpResponseException, "content_filter");
            Response response = Response.from((Object)httpResponseException.getMessage(), null, (FinishReason)exceptionFinishReason);
            handler.onComplete(response);
        }
        catch (Exception exception) {
            handler.onError((Throwable)exception);
        }
    }

    private static void handle(Completions completions, StreamingResponseHandler<String> handler) {
        List choices = completions.getChoices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        String content = ((Choice)choices.get(0)).getText();
        if (content != null) {
            handler.onNext(content);
        }
    }

    public int estimateTokenCount(String prompt) {
        return this.tokenizer.estimateTokenCountInText(prompt);
    }

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(AzureOpenAiStreamingLanguageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            AzureOpenAiStreamingLanguageModelBuilderFactory factory = (AzureOpenAiStreamingLanguageModelBuilderFactory)iterator.next();
            return (Builder)factory.get();
        }
        return new Builder();
    }

    public static class Builder {
        private String endpoint;
        private String serviceVersion;
        private String apiKey;
        private KeyCredential keyCredential;
        private TokenCredential tokenCredential;
        private String deploymentName;
        private Tokenizer tokenizer;
        private Integer maxTokens;
        private Double temperature;
        private Double topP;
        private Map<String, Integer> logitBias;
        private String user;
        private Integer n;
        private Integer logprobs;
        private Boolean echo;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Duration timeout;
        private Integer maxRetries;
        private ProxyOptions proxyOptions;
        private boolean logRequestsAndResponses;
        private OpenAIClient openAIClient;
        private String userAgentSuffix;
        private Map<String, String> customHeaders;

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder nonAzureApiKey(String nonAzureApiKey) {
            this.keyCredential = new KeyCredential(nonAzureApiKey);
            this.endpoint = "https://api.openai.com/v1";
            return this;
        }

        public Builder tokenCredential(TokenCredential tokenCredential) {
            this.tokenCredential = tokenCredential;
            return this;
        }

        public Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public Builder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder echo(Boolean echo) {
            this.echo = echo;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder proxyOptions(ProxyOptions proxyOptions) {
            this.proxyOptions = proxyOptions;
            return this;
        }

        public Builder logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        public Builder openAIClient(OpenAIClient openAIClient) {
            this.openAIClient = openAIClient;
            return this;
        }

        public Builder userAgentSuffix(String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public AzureOpenAiStreamingLanguageModel build() {
            if (this.openAIClient == null) {
                if (this.tokenCredential != null) {
                    return new AzureOpenAiStreamingLanguageModel(this.endpoint, this.serviceVersion, this.tokenCredential, this.deploymentName, this.tokenizer, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.n, this.logprobs, this.echo, this.stop, this.presencePenalty, this.frequencyPenalty, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.userAgentSuffix, this.customHeaders);
                }
                if (this.keyCredential != null) {
                    return new AzureOpenAiStreamingLanguageModel(this.endpoint, this.serviceVersion, this.keyCredential, this.deploymentName, this.tokenizer, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.n, this.logprobs, this.echo, this.stop, this.presencePenalty, this.frequencyPenalty, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.userAgentSuffix, this.customHeaders);
                }
                return new AzureOpenAiStreamingLanguageModel(this.endpoint, this.serviceVersion, this.apiKey, this.deploymentName, this.tokenizer, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.n, this.logprobs, this.echo, this.stop, this.presencePenalty, this.frequencyPenalty, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.userAgentSuffix, this.customHeaders);
            }
            return new AzureOpenAiStreamingLanguageModel(this.openAIClient, this.deploymentName, this.tokenizer, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.n, this.logprobs, this.echo, this.stop, this.presencePenalty, this.frequencyPenalty);
        }
    }
}

