/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.gemfire.testcontainers;

import com.vmware.gemfire.testcontainers.AbstractGemFireContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class MemberConfig {
    private final String memberName;
    private final String hostname;
    private final List<Consumer<AbstractGemFireContainer<?>>> configConsumers = new ArrayList();
    private final List<Consumer<AbstractGemFireContainer<?>>> preStartConsumers = new ArrayList();
    private int proxyListenPort;
    private int proxyPublicPort;
    private int port;
    private int proxyHttpListenPort;
    private int proxyHttpPublicPort;
    private AbstractGemFireContainer<?> container;

    MemberConfig(String prefix, int index, String suffix) {
        this.memberName = String.format("%s-%d", prefix, index);
        this.hostname = String.format("%s-%d-%s", prefix, index, suffix);
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public AbstractGemFireContainer<?> getContainer() {
        return this.container;
    }

    public void setContainer(AbstractGemFireContainer<?> container) {
        this.container = container;
    }

    void addConfig(Consumer<AbstractGemFireContainer<?>> config) {
        this.configConsumers.add(config);
    }

    void addPreStart(Consumer<AbstractGemFireContainer<?>> config) {
        this.preStartConsumers.add(config);
    }

    void apply(AbstractGemFireContainer<?> container) {
        this.configConsumers.forEach(consumer -> consumer.accept(container));
    }

    void applyPreStart(AbstractGemFireContainer<?> container) {
        this.preStartConsumers.forEach(consumer -> consumer.accept(container));
    }

    void setProxyListenPort(int port) {
        this.proxyListenPort = port;
    }

    int getProxyListenPort() {
        return this.proxyListenPort;
    }

    void setProxyHttpListenPort(int port) {
        this.proxyHttpListenPort = port;
    }

    int getProxyHttpListenPort() {
        return this.proxyHttpListenPort;
    }

    public int getPort() {
        return this.port == 0 ? this.proxyPublicPort : this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.addConfig(container -> container.setPortBindings(Collections.singletonList(String.format("%d:%d", port, port))));
    }

    void setProxyPublicPort(int port) {
        this.proxyPublicPort = port;
    }

    public int getProxyPublicPort() {
        return this.proxyPublicPort;
    }

    void setProxyHttpPublicPort(int port) {
        this.proxyHttpPublicPort = port;
    }

    public int getProxyHttpPublicPort() {
        return this.proxyHttpPublicPort;
    }
}

