/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.mendeley;

import de.undercouch.citeproc.bibtex.NameParser;
import de.undercouch.citeproc.csl.CSLDate;
import de.undercouch.citeproc.csl.CSLDateBuilder;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CSLItemDataBuilder;
import de.undercouch.citeproc.csl.CSLName;
import de.undercouch.citeproc.csl.CSLNameBuilder;
import de.undercouch.citeproc.csl.CSLType;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MendeleyConverter {
    private static final String FIELD_ABSTRACT = "abstract";
    private static final String FIELD_ACCESSED = "accessed";
    private static final String FIELD_AUTHORS = "authors";
    private static final String FIELD_CHAPTER = "chapter";
    private static final String FIELD_CITATION_KEY = "citation_key";
    private static final String FIELD_CITY = "city";
    private static final String FIELD_DAY = "day";
    private static final String FIELD_EDITION = "edition";
    private static final String FIELD_EDITORS = "editors";
    private static final String FIELD_FIRSTNAME = "first_name";
    private static final String FIELD_GENRE = "genre";
    private static final String FIELD_IDENTIFIERS = "identifiers";
    private static final String FIELD_ISSUE = "issue";
    private static final String FIELD_KEYWORDS = "keywords";
    private static final String FIELD_LANGUAGE = "language";
    private static final String FIELD_MEDIUM = "medium";
    private static final String FIELD_MONTH = "month";
    private static final String FIELD_PAGES = "pages";
    private static final String FIELD_PUBLISHER = "publisher";
    private static final String FIELD_REVISION = "revision";
    private static final String FIELD_SERIES = "series";
    private static final String FIELD_SERIES_EDITOR = "series_editor";
    private static final String FIELD_SERIES_NUMBER = "series_number";
    private static final String FIELD_SHORT_TITLE = "short_title";
    private static final String FIELD_SOURCE = "source";
    private static final String FIELD_LASTNAME = "last_name";
    private static final String FIELD_TITLE = "title";
    private static final String FIELD_TRANSLATORS = "translators";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_VOLUME = "volume";
    private static final String FIELD_WEBSITES = "websites";
    private static final String FIELD_YEAR = "year";
    private static final String IDENTIFIER_DOI = "doi";
    private static final String IDENTIFIER_ISBN = "isbn";
    private static final String IDENTIFIER_ISSN = "issn";
    private static final String IDENTIFIER_PMID = "pmid";
    private static final String TYPE_BILL = "bill";
    private static final String TYPE_BOOK = "book";
    private static final String TYPE_BOOK_SECTION = "book_section";
    private static final String TYPE_CASE = "case";
    private static final String TYPE_COMPUTER_PROGRAM = "computer_program";
    private static final String TYPE_CONFERENCE_PROCEEDINGS = "conference_proceedings";
    private static final String TYPE_ENCYCLOPEDIA_ARTICLE = "encyclopedia_article";
    private static final String TYPE_FILM = "film";
    private static final String TYPE_GENERIC = "generic";
    private static final String TYPE_HEARING = "hearing";
    private static final String TYPE_JOURNAL = "journal";
    private static final String TYPE_MAGAZINE_ARTICLE = "magazine_article";
    private static final String TYPE_NEWSPAPER_ARTICLE = "newspaper_article";
    private static final String TYPE_PATENT = "patent";
    private static final String TYPE_REPORT = "report";
    private static final String TYPE_STATUTE = "statute";
    private static final String TYPE_TELEVISION_BROADCAST = "television_broadcast";
    private static final String TYPE_THESIS = "thesis";
    private static final String TYPE_WEB_PAGE = "web_page";
    private static final String TYPE_WORKING_PAPER = "working_paper";

    public static CSLItemData convert(String documentId, Map<String, Object> document) {
        List websites;
        String seriesEditor;
        String id = (String)document.get(FIELD_CITATION_KEY);
        if (id == null) {
            id = documentId;
        }
        String mtype = MendeleyConverter.strOrNull(document.get(FIELD_TYPE));
        CSLType type = MendeleyConverter.toType(mtype);
        CSLItemDataBuilder builder = new CSLItemDataBuilder().id(id).type(type);
        if (document.containsKey(FIELD_AUTHORS)) {
            List al = (List)document.get(FIELD_AUTHORS);
            builder.author(MendeleyConverter.toAuthors(al));
        }
        if (document.containsKey(FIELD_EDITORS)) {
            List el = (List)document.get(FIELD_EDITORS);
            CSLName[] editors = MendeleyConverter.toAuthors(el);
            builder.editor(editors);
            builder.collectionEditor(editors);
            builder.containerAuthor(editors);
        }
        if (document.containsKey(FIELD_SERIES_EDITOR) && (seriesEditor = MendeleyConverter.strOrNull(document.get(FIELD_SERIES_EDITOR))) != null) {
            CSLName[] sen = NameParser.parse(seriesEditor);
            builder.collectionEditor(sen);
            builder.containerAuthor(sen);
        }
        if (document.containsKey(FIELD_TRANSLATORS)) {
            List tl = (List)document.get(FIELD_TRANSLATORS);
            builder.translator(MendeleyConverter.toAuthors(tl));
        }
        if (document.containsKey(FIELD_YEAR)) {
            CSLDateBuilder db = new CSLDateBuilder();
            int year = Integer.parseInt(document.get(FIELD_YEAR).toString());
            if (document.containsKey(FIELD_MONTH)) {
                int month = Integer.parseInt(document.get(FIELD_MONTH).toString());
                if (document.containsKey(FIELD_DAY)) {
                    int day = Integer.parseInt(document.get(FIELD_DAY).toString());
                    db.dateParts(year, month, day);
                } else {
                    db.dateParts(year, month);
                }
            } else {
                db.dateParts(year);
            }
            CSLDate d = db.build();
            builder.issued(d);
            builder.eventDate(d);
        }
        if (document.containsKey(FIELD_REVISION)) {
            builder.number(MendeleyConverter.strOrNull(document.get(FIELD_REVISION)));
        } else {
            builder.number(MendeleyConverter.strOrNull(document.get(FIELD_SERIES_NUMBER)));
        }
        String containerTitle = document.containsKey(FIELD_SERIES) ? MendeleyConverter.strOrNull(document.get(FIELD_SERIES)) : MendeleyConverter.strOrNull(document.get(FIELD_SOURCE));
        builder.containerTitle(containerTitle);
        builder.collectionTitle(containerTitle);
        if (mtype.equalsIgnoreCase(TYPE_PATENT) && document.containsKey(FIELD_SOURCE)) {
            builder.publisher(MendeleyConverter.strOrNull(document.get(FIELD_SOURCE)));
        } else {
            builder.publisher(MendeleyConverter.strOrNull(document.get(FIELD_PUBLISHER)));
        }
        if (document.containsKey(FIELD_ACCESSED)) {
            builder.accessed(new CSLDateBuilder().raw(MendeleyConverter.strOrNull(document.get(FIELD_ACCESSED))).build());
        }
        if (document.containsKey(FIELD_IDENTIFIERS)) {
            Map identifiers = (Map)document.get(FIELD_IDENTIFIERS);
            builder.DOI((String)identifiers.get(IDENTIFIER_DOI));
            builder.ISBN((String)identifiers.get(IDENTIFIER_ISBN));
            builder.ISSN((String)identifiers.get(IDENTIFIER_ISSN));
            builder.PMID((String)identifiers.get(IDENTIFIER_PMID));
        }
        if (document.containsKey(FIELD_KEYWORDS)) {
            List keywords = (List)document.get(FIELD_KEYWORDS);
            builder.keyword(StringUtils.join((Iterable)keywords, (char)','));
        }
        if (document.containsKey(FIELD_WEBSITES) && (websites = (List)document.get(FIELD_WEBSITES)).size() > 0) {
            builder.URL((String)websites.get(0));
        }
        builder.abstrct(MendeleyConverter.strOrNull(document.get(FIELD_ABSTRACT)));
        builder.chapterNumber(MendeleyConverter.strOrNull(document.get(FIELD_CHAPTER)));
        builder.eventPlace(MendeleyConverter.strOrNull(document.get(FIELD_CITY)));
        builder.publisherPlace(MendeleyConverter.strOrNull(document.get(FIELD_CITY)));
        builder.edition(MendeleyConverter.strOrNull(document.get(FIELD_EDITION)));
        builder.genre(MendeleyConverter.strOrNull(document.get(FIELD_GENRE)));
        builder.issue(MendeleyConverter.strOrNull(document.get(FIELD_ISSUE)));
        builder.language(MendeleyConverter.strOrNull(document.get(FIELD_LANGUAGE)));
        builder.medium(MendeleyConverter.strOrNull(document.get(FIELD_MEDIUM)));
        builder.page(MendeleyConverter.strOrNull(document.get(FIELD_PAGES)));
        builder.shortTitle(MendeleyConverter.strOrNull(document.get(FIELD_SHORT_TITLE)));
        builder.title(MendeleyConverter.strOrNull(document.get(FIELD_TITLE)));
        builder.volume(MendeleyConverter.strOrNull(document.get(FIELD_VOLUME)));
        return builder.build();
    }

    private static String strOrNull(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    private static CSLName[] toAuthors(List<Map<String, Object>> authors) {
        CSLName[] result = new CSLName[authors.size()];
        int i = 0;
        for (Map<String, Object> a : authors) {
            CSLNameBuilder builder = new CSLNameBuilder();
            if (a.containsKey(FIELD_FIRSTNAME)) {
                builder.given(MendeleyConverter.strOrNull(a.get(FIELD_FIRSTNAME)));
            }
            if (a.containsKey(FIELD_LASTNAME)) {
                builder.family(MendeleyConverter.strOrNull(a.get(FIELD_LASTNAME)));
            }
            builder.parseNames(true);
            result[i] = builder.build();
            ++i;
        }
        return result;
    }

    private static CSLType toType(String type) {
        if (type.equalsIgnoreCase(TYPE_BILL)) {
            return CSLType.BILL;
        }
        if (type.equalsIgnoreCase(TYPE_BOOK)) {
            return CSLType.BOOK;
        }
        if (type.equalsIgnoreCase(TYPE_BOOK_SECTION)) {
            return CSLType.CHAPTER;
        }
        if (type.equalsIgnoreCase(TYPE_CASE)) {
            return CSLType.ARTICLE;
        }
        if (type.equalsIgnoreCase(TYPE_COMPUTER_PROGRAM)) {
            return CSLType.ARTICLE;
        }
        if (type.equalsIgnoreCase(TYPE_CONFERENCE_PROCEEDINGS)) {
            return CSLType.PAPER_CONFERENCE;
        }
        if (type.equalsIgnoreCase(TYPE_ENCYCLOPEDIA_ARTICLE)) {
            return CSLType.ENTRY_ENCYCLOPEDIA;
        }
        if (type.equalsIgnoreCase(TYPE_FILM)) {
            return CSLType.MOTION_PICTURE;
        }
        if (type.equalsIgnoreCase(TYPE_GENERIC)) {
            return CSLType.ARTICLE;
        }
        if (type.equalsIgnoreCase(TYPE_HEARING)) {
            return CSLType.SPEECH;
        }
        if (type.equalsIgnoreCase(TYPE_JOURNAL)) {
            return CSLType.ARTICLE_JOURNAL;
        }
        if (type.equalsIgnoreCase(TYPE_MAGAZINE_ARTICLE)) {
            return CSLType.ARTICLE_MAGAZINE;
        }
        if (type.equalsIgnoreCase(TYPE_NEWSPAPER_ARTICLE)) {
            return CSLType.ARTICLE_NEWSPAPER;
        }
        if (type.equalsIgnoreCase(TYPE_PATENT)) {
            return CSLType.PATENT;
        }
        if (type.equalsIgnoreCase(TYPE_REPORT)) {
            return CSLType.REPORT;
        }
        if (type.equalsIgnoreCase(TYPE_STATUTE)) {
            return CSLType.LEGISLATION;
        }
        if (type.equalsIgnoreCase(TYPE_TELEVISION_BROADCAST)) {
            return CSLType.BROADCAST;
        }
        if (type.equalsIgnoreCase(TYPE_THESIS)) {
            return CSLType.THESIS;
        }
        if (type.equalsIgnoreCase(TYPE_WEB_PAGE)) {
            return CSLType.WEBPAGE;
        }
        if (type.equalsIgnoreCase(TYPE_WORKING_PAPER)) {
            return CSLType.ARTICLE;
        }
        return CSLType.ARTICLE;
    }
}

