/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc;

import de.undercouch.citeproc.csl.CSLDate;
import de.undercouch.citeproc.csl.CSLDateBuilder;
import de.undercouch.citeproc.script.ScriptRunner;
import de.undercouch.citeproc.script.ScriptRunnerException;
import de.undercouch.citeproc.script.ScriptRunnerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Map;

public class CSLDateParser {
    private final ScriptRunner runner = ScriptRunnerFactory.createRunner();
    private final Object parser;

    public CSLDateParser() {
        try {
            this.runner.eval(new StringReader("var CSL = new function() {};CSL.DATE_PARTS_ALL = [\"year\", \"month\", \"day\", \"season\"];CSL.debug = function(msg) {};function getParser() { return CSL.DateParser; }"));
            this.runner.loadScript(this.getClass().getResource("dateparser.js"));
        }
        catch (IOException iOException) {
        }
        catch (ScriptRunnerException e) {
            throw new RuntimeException("Invalid bundled javascript file", e);
        }
        try {
            this.parser = this.runner.callMethod("getParser", Object.class, new Object[0]);
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not initialize date parser", e);
        }
    }

    public CSLDate parse(String str) {
        Map res;
        try {
            Map m;
            res = m = this.runner.callMethod(this.parser, "parseDateToArray", Map.class, str);
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not update items", e);
        }
        CSLDate r = CSLDate.fromJson(res);
        if (r.getDateParts().length == 2 && Arrays.equals(r.getDateParts()[0], r.getDateParts()[1])) {
            r = new CSLDateBuilder(r).dateParts(new int[][]{r.getDateParts()[0]}).build();
        }
        return r;
    }
}

