/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.domain.values;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class StatusInfo
implements Serializable {
    public static final String STATUS_UNKNOWN = "UNKNOWN";
    public static final String STATUS_OUT_OF_SERVICE = "OUT_OF_SERVICE";
    public static final String STATUS_UP = "UP";
    public static final String STATUS_DOWN = "DOWN";
    public static final String STATUS_OFFLINE = "OFFLINE";
    public static final String STATUS_RESTRICTED = "RESTRICTED";
    private static final List<String> STATUS_ORDER = Arrays.asList("DOWN", "OUT_OF_SERVICE", "OFFLINE", "UNKNOWN", "RESTRICTED", "UP");
    private final String status;
    private final Map<String, Object> details;

    private StatusInfo(String status, @Nullable Map<String, ?> details) {
        Assert.hasText((String)status, (String)"'status' must not be empty.");
        this.status = status.toUpperCase();
        this.details = details != null ? new HashMap(details) : Collections.emptyMap();
    }

    public static StatusInfo valueOf(String statusCode, @Nullable Map<String, ?> details) {
        return new StatusInfo(statusCode, details);
    }

    public static StatusInfo valueOf(String statusCode) {
        return StatusInfo.valueOf(statusCode, null);
    }

    public static StatusInfo ofUnknown() {
        return StatusInfo.valueOf(STATUS_UNKNOWN, null);
    }

    public static StatusInfo ofUp() {
        return StatusInfo.ofUp(null);
    }

    public static StatusInfo ofDown() {
        return StatusInfo.ofDown(null);
    }

    public static StatusInfo ofOffline() {
        return StatusInfo.ofOffline(null);
    }

    public static StatusInfo ofUp(@Nullable Map<String, Object> details) {
        return StatusInfo.valueOf(STATUS_UP, details);
    }

    public static StatusInfo ofDown(@Nullable Map<String, Object> details) {
        return StatusInfo.valueOf(STATUS_DOWN, details);
    }

    public static StatusInfo ofOffline(@Nullable Map<String, Object> details) {
        return StatusInfo.valueOf(STATUS_OFFLINE, details);
    }

    public Map<String, Object> getDetails() {
        return Collections.unmodifiableMap(this.details);
    }

    public boolean isUp() {
        return STATUS_UP.equals(this.status);
    }

    public boolean isOffline() {
        return STATUS_OFFLINE.equals(this.status);
    }

    public boolean isDown() {
        return STATUS_DOWN.equals(this.status);
    }

    public boolean isUnknown() {
        return STATUS_UNKNOWN.equals(this.status);
    }

    public static Comparator<String> severity() {
        return Comparator.comparingInt(STATUS_ORDER::indexOf);
    }

    public static StatusInfo from(Map<String, ?> body) {
        Map details = Collections.emptyMap();
        if (body.containsKey("details")) {
            details = (Map)body.get("details");
        } else if (body.containsKey("components")) {
            details = (Map)body.get("components");
        }
        return StatusInfo.valueOf((String)body.get("status"), details);
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusInfo)) {
            return false;
        }
        StatusInfo other = (StatusInfo)o;
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Map<String, Object> this$details = this.getDetails();
        Map<String, Object> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Map<String, Object> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StatusInfo(status=" + this.getStatus() + ", details=" + this.getDetails() + ")";
    }
}

