/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import de.codecentric.boot.admin.client.registration.Application;
import de.codecentric.boot.admin.client.registration.ApplicationFactory;
import de.codecentric.boot.admin.client.registration.ApplicationRegistrator;
import de.codecentric.boot.admin.client.registration.RegistrationClient;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationRegistrator
implements ApplicationRegistrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationRegistrator.class);
    private final ConcurrentHashMap<String, LongAdder> attempts = new ConcurrentHashMap();
    private final AtomicReference<String> registeredId = new AtomicReference();
    private final ApplicationFactory applicationFactory;
    private final String[] adminUrls;
    private final boolean registerOnce;
    private final RegistrationClient registrationClient;

    public DefaultApplicationRegistrator(ApplicationFactory applicationFactory, RegistrationClient registrationClient, String[] adminUrls, boolean registerOnce) {
        this.applicationFactory = applicationFactory;
        this.adminUrls = adminUrls;
        this.registerOnce = registerOnce;
        this.registrationClient = registrationClient;
    }

    @Override
    public boolean register() {
        Application application = this.applicationFactory.createApplication();
        boolean isRegistrationSuccessful = false;
        String[] stringArray = this.adminUrls;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String adminUrl;
            LongAdder attempt = this.attempts.computeIfAbsent(adminUrl = stringArray[i], k -> new LongAdder());
            boolean successful = this.register(application, adminUrl, attempt.intValue() == 0);
            if (!successful) {
                attempt.increment();
                continue;
            }
            attempt.reset();
            isRegistrationSuccessful = true;
            if (this.registerOnce) break;
        }
        return isRegistrationSuccessful;
    }

    protected boolean register(Application application, String adminUrl, boolean firstAttempt) {
        try {
            String id = this.registrationClient.register(adminUrl, application);
            if (this.registeredId.compareAndSet(null, id)) {
                LOGGER.info("Application registered itself as {}", (Object)id);
            } else {
                LOGGER.debug("Application refreshed itself as {}", (Object)id);
            }
            return true;
        }
        catch (Exception ex) {
            if (firstAttempt) {
                LOGGER.warn("Failed to register application as {} at spring-boot-admin ({}): {}. Further attempts are logged on DEBUG level", new Object[]{application, this.adminUrls, ex.getMessage()});
            } else {
                LOGGER.debug("Failed to register application as {} at spring-boot-admin ({}): {}", new Object[]{application, this.adminUrls, ex.getMessage()});
            }
            return false;
        }
    }

    @Override
    public void deregister() {
        String id = this.registeredId.get();
        if (id == null) {
            return;
        }
        for (String adminUrl : this.adminUrls) {
            try {
                this.registrationClient.deregister(adminUrl, id);
                this.registeredId.compareAndSet(id, null);
                if (!this.registerOnce) continue;
                break;
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to deregister application (id={}) at spring-boot-admin ({}): {}", new Object[]{id, adminUrl, ex.getMessage()});
            }
        }
    }

    @Override
    public String getRegisteredId() {
        return this.registeredId.get();
    }
}

