/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.TypeAnnotationInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RuntimeVisibleTypeAnnotationsAttrInfo
extends AttrInfo {
    private int u2AnnotationCount;
    private TypeAnnotationInfo[] annotations;

    public RuntimeVisibleTypeAnnotationsAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "RuntimeVisibleTypeAnnotations";
    }

    public TypeAnnotationInfo[] getAnnotations() {
        return this.annotations;
    }

    public ClassFile getOwner() {
        return this.owner;
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        dout.writeShort(this.u2AnnotationCount);
        for (int i = 0; i < this.u2AnnotationCount; ++i) {
            this.annotations[i].write(dout);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        this.u2AnnotationCount = din.readUnsignedShort();
        this.annotations = new TypeAnnotationInfo[this.u2AnnotationCount];
        for (int i = 0; i < this.u2AnnotationCount; ++i) {
            this.annotations[i] = TypeAnnotationInfo.create(din);
        }
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) {
        for (int i = 0; i < this.u2AnnotationCount; ++i) {
            this.annotations[i].markUtf8RefsInInfo(pool);
        }
    }
}

