/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf;

import com.yworks.yguard.Conversion;
import com.yworks.yguard.ParseException;
import com.yworks.yguard.obf.Cl;
import com.yworks.yguard.obf.Cons;
import com.yworks.yguard.obf.Fd;
import com.yworks.yguard.obf.LineNumberTableMapper;
import com.yworks.yguard.obf.Md;
import com.yworks.yguard.obf.NoSuchMappingException;
import com.yworks.yguard.obf.Pk;
import com.yworks.yguard.obf.PkCl;
import com.yworks.yguard.obf.TreeAction;
import com.yworks.yguard.obf.TreeItem;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ClassItemInfo;
import com.yworks.yguard.obf.classfile.FieldInfo;
import com.yworks.yguard.obf.classfile.LineNumberTableAttrInfo;
import com.yworks.yguard.obf.classfile.Logger;
import com.yworks.yguard.obf.classfile.MethodInfo;
import com.yworks.yguard.obf.classfile.NameMapper;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassTree
implements NameMapper {
    public static final char PACKAGE_LEVEL = '/';
    public static final char CLASS_LEVEL = '$';
    public static final char METHOD_FIELD_LEVEL = '/';
    private Vector retainAttrs = new Vector();
    private Pk root = Pk.createRoot(this);
    private static final String[] hex = new String[256];
    private static final String hexChars = "0123456789abcdef";
    private boolean replaceClassNameStrings;
    private boolean pedantic;

    public static Enumeration getNameEnum(String name) {
        Vector<Cons> vec = new Vector<Cons>();
        String nameOrig = name;
        while (!name.equals("")) {
            int posP = name.indexOf(47);
            int posC = name.indexOf(36);
            Cons cons = null;
            if (posP == -1 && posC == 0) {
                int innerClassIndex = name.indexOf(36, 1);
                int endIndex = innerClassIndex > 0 ? innerClassIndex : name.length();
                cons = new Cons(new Character('$'), name.substring(0, endIndex));
                name = name.substring(endIndex);
            }
            if (posP == -1 && posC == -1) {
                cons = new Cons(new Character('$'), name);
                name = "";
            }
            if (posP == -1 && posC > 0) {
                cons = new Cons(new Character('$'), name.substring(0, posC));
                while (posC + 1 < name.length() && name.charAt(posC + 1) == '$') {
                    ++posC;
                }
                name = name.substring(posC + 1, name.length());
            }
            if (posP != -1 && posC == -1) {
                cons = new Cons(new Character('/'), name.substring(0, posP));
                name = name.substring(posP + 1, name.length());
            }
            if (posP != -1 && posC != -1) {
                if (posP < posC) {
                    cons = new Cons(new Character('/'), name.substring(0, posP));
                    name = name.substring(posP + 1, name.length());
                } else {
                    throw new IllegalArgumentException("Invalid fully qualified name (a): " + nameOrig);
                }
            }
            if (((String)cons.cdr).equals("")) {
                throw new IllegalArgumentException("Invalid fully qualified name (b): " + nameOrig);
            }
            vec.addElement(cons);
        }
        return vec.elements();
    }

    public Pk getRoot() {
        return this.root;
    }

    public TreeItem findTreeItem(String[] nameParts) {
        TreeItem tmp = this.root;
        for (int i = 0; tmp != null && i < nameParts.length; ++i) {
            String name = nameParts[i];
            tmp = this.findSubItem(tmp, name);
        }
        return tmp;
    }

    public Cl findClassForName(String name) {
        Cl cl;
        int dindex = name.indexOf(36);
        String innerClass = null;
        if (dindex > 0) {
            innerClass = name.substring(dindex + 1);
            name = name.substring(0, dindex);
        }
        int pindex = name.lastIndexOf(46);
        String packageName = null;
        if (pindex > 0) {
            packageName = name.substring(0, pindex);
            name = name.substring(pindex + 1);
        }
        Pk pk = this.root;
        if (packageName != null) {
            StringTokenizer st = new StringTokenizer(packageName, ".", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ((pk = this.findPackage(pk, token)) != null) continue;
                return null;
            }
        }
        if ((cl = this.findClass(pk, name)) != null && innerClass != null) {
            StringTokenizer st = new StringTokenizer(innerClass, "$", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ((cl = this.findClass(cl, token)) != null) continue;
                return null;
            }
        }
        return cl;
    }

    private Pk findPackage(TreeItem parent, String pName) {
        if (parent instanceof Pk) {
            Enumeration enumeration = ((Pk)parent).getPackageEnum();
            while (enumeration.hasMoreElements()) {
                Pk subPk = (Pk)enumeration.nextElement();
                if (!subPk.getInName().equals(pName)) continue;
                return subPk;
            }
        }
        return null;
    }

    private Cl findClass(PkCl parent, String pName) {
        Enumeration enumeration = parent.getClassEnum();
        while (enumeration.hasMoreElements()) {
            Cl cl = (Cl)enumeration.nextElement();
            if (!cl.getInName().equals(pName)) continue;
            return cl;
        }
        return null;
    }

    private TreeItem findSubItem(TreeItem parent, String childName) {
        Cl cl;
        Enumeration enumeration;
        if (parent instanceof Pk) {
            enumeration = ((Pk)parent).getPackageEnum();
            while (enumeration.hasMoreElements()) {
                Pk subPk = (Pk)enumeration.nextElement();
                if (!subPk.getInName().equals(childName)) continue;
                return subPk;
            }
            enumeration = ((Pk)parent).getClassEnum();
            while (enumeration.hasMoreElements()) {
                cl = (Cl)enumeration.nextElement();
                if (!cl.getInName().equals(childName)) continue;
                return cl;
            }
        }
        if (parent instanceof Cl) {
            enumeration = ((Cl)parent).getClassEnum();
            while (enumeration.hasMoreElements()) {
                cl = (Cl)enumeration.nextElement();
                if (!cl.getInName().equals(childName)) continue;
                return cl;
            }
            return null;
        }
        return null;
    }

    public String getOutName(String inName) {
        try {
            Pk ti = this.root;
            StringBuffer sb = new StringBuffer();
            Enumeration nameEnum = ClassTree.getNameEnum(inName);
            block6: while (nameEnum.hasMoreElements()) {
                Cons nameSegment = (Cons)nameEnum.nextElement();
                char tag = ((Character)nameSegment.car).charValue();
                String name = (String)nameSegment.cdr;
                switch (tag) {
                    case '/': {
                        if (ti != null) {
                            if ((ti = ti.getPackage(name)) != null) {
                                sb.append(ti.getOutName());
                            } else {
                                sb.append(name);
                            }
                        } else {
                            sb.append(name);
                        }
                        sb.append('/');
                        continue block6;
                    }
                    case '$': {
                        sb.append(name);
                        return sb.toString();
                    }
                }
                throw new RuntimeException("Internal error: illegal package/class name tag");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inName;
    }

    public void addClassFile(ClassFile cf) {
        PkCl ti = this.root;
        int parentTag = 47;
        Enumeration nameEnum = ClassTree.getNameEnum(cf.getName());
        while (nameEnum.hasMoreElements()) {
            Cons nameSegment = (Cons)nameEnum.nextElement();
            char tag = ((Character)nameSegment.car).charValue();
            String name = (String)nameSegment.cdr;
            switch (tag) {
                case '/': {
                    ti = ti.addPackage(name);
                    break;
                }
                case '$': {
                    if (nameEnum.hasMoreElements()) {
                        ti = ((PkCl)ti).addPlaceholderClass(name);
                        break;
                    }
                    Object[] classInfo = new Object[]{name, cf.getSuper(), cf.getInterfaces(), cf.getModifiers(), ClassItemInfo.getObfuscationConfig(cf.getName(), cf.getAttributes())};
                    Cl cl = ((PkCl)ti).addClass(classInfo);
                    cl.setInnerClassModifiers(cf.getInnerClassModifiers());
                    cl.setClassFileAccess(cf.getClassFileAccess());
                    ti = cl;
                    break;
                }
                default: {
                    throw new ParseException("Internal error: illegal package/class name tag");
                }
            }
            parentTag = tag;
        }
        if (ti instanceof Cl) {
            Cl cl = (Cl)ti;
            cl.access = cf.getModifiers();
            Enumeration enumeration = cf.getMethodEnum();
            while (enumeration.hasMoreElements()) {
                cl.addMethod((MethodInfo)enumeration.nextElement());
            }
            enumeration = cf.getFieldEnum();
            while (enumeration.hasMoreElements()) {
                cl.addField((FieldInfo)enumeration.nextElement());
            }
        } else {
            throw new ParseException("Inconsistent class file.");
        }
    }

    public void retainAttribute(String name) {
        this.retainAttrs.addElement(name);
    }

    private boolean modifierMatch(int level, int mods) {
        if (level == 0) {
            return false;
        }
        if (Modifier.isPublic(mods)) {
            return (level & 1) == 1;
        }
        if (Modifier.isProtected(mods)) {
            return (level & 4) == 4;
        }
        if (Modifier.isPrivate(mods)) {
            return (level & 2) == 2;
        }
        return (level & 0x1000) == 4096;
    }

    public void retainClass(String name, int classLevel, int methodLevel, int fieldLevel, boolean retainHierarchy) {
        Enumeration clEnum = this.getClEnum(name, classLevel);
        while (clEnum.hasMoreElements()) {
            Enumeration enumeration;
            Cl classItem = (Cl)clEnum.nextElement();
            if (retainHierarchy && classLevel != 0) {
                this.retainHierarchy(classItem);
            }
            if (methodLevel != 0) {
                enumeration = classItem.getMethodEnum();
                while (enumeration.hasMoreElements()) {
                    Md md = (Md)enumeration.nextElement();
                    if (!this.modifierMatch(methodLevel, md.getModifiers())) continue;
                    md.setOutName(md.getInName());
                    md.setFromScript();
                }
                if ((methodLevel & 0x1005) != 0 || (fieldLevel & 0x1005) != 0) {
                    String superClass;
                    int mask = 2;
                    int ml = methodLevel & ~mask;
                    int fl = fieldLevel & ~mask;
                    int cl = classLevel & ~mask;
                    String[] interfaces = classItem.getInterfaces();
                    if (interfaces != null) {
                        for (int i = 0; i < interfaces.length; ++i) {
                            String interfaceClass = interfaces[i];
                            this.retainClass(interfaceClass, cl, ml, fl, false);
                        }
                    }
                    if ((superClass = classItem.getSuperClass()) != null) {
                        if (!superClass.startsWith(classItem.getParent().getFullInName())) {
                            ml = methodLevel & ~(mask |= 0x1000);
                            fl = fieldLevel & ~mask;
                            cl = classLevel & ~mask;
                        }
                        this.retainClass(superClass, cl, ml, fl, false);
                    }
                }
            }
            if (fieldLevel == 0) continue;
            enumeration = classItem.getFieldEnum();
            while (enumeration.hasMoreElements()) {
                Fd fd = (Fd)enumeration.nextElement();
                if (!this.modifierMatch(fieldLevel, fd.getModifiers())) continue;
                fd.setOutName(fd.getInName());
                fd.setFromScript();
            }
        }
    }

    public void retainMethod(String name, String descriptor) {
        Enumeration enumeration = this.getMdEnum(name, descriptor);
        while (enumeration.hasMoreElements()) {
            Md md = (Md)enumeration.nextElement();
            md.setOutName(md.getInName());
            md.setFromScript();
        }
    }

    public void retainField(String name) {
        Enumeration enumeration = this.getFdEnum(name);
        while (enumeration.hasMoreElements()) {
            Fd fd = (Fd)enumeration.nextElement();
            fd.setOutName(fd.getInName());
            fd.setFromScript();
        }
    }

    public void retainPackageMap(String name, String obfName) {
        this.retainItemMap(this.getPk(name), obfName);
    }

    public void retainClassMap(String name, String obfName) {
        this.retainItemMap(this.getCl(name), obfName);
    }

    public void retainMethodMap(String name, String descriptor, String obfName) {
        this.retainItemMap(this.getMd(name, descriptor), obfName);
    }

    public void retainFieldMap(String name, String obfName) {
        this.retainItemMap(this.getFd(name), obfName);
    }

    private void retainItemMap(TreeItem item, String obfName) {
        if (!item.isFixed()) {
            item.setOutName(obfName);
            item.setFromScriptMap();
        } else if (!item.getOutName().equals(obfName)) {
            item.setOutName(obfName);
            item.setFromScriptMap();
            Logger.getInstance().warning("'" + item.getFullInName() + "' will be remapped to '" + obfName + "' according to mapping rule!");
        }
    }

    public void generateNames() {
        this.walkTree(new TreeAction(){

            @Override
            public void packageAction(Pk pk) {
                pk.generateNames();
            }

            @Override
            public void classAction(Cl cl) {
                cl.generateNames();
            }
        });
    }

    public void resolveClasses() throws ClassNotFoundException {
        this.walkTree(new TreeAction(){

            @Override
            public void classAction(Cl cl) {
                cl.resetResolve();
            }
        });
        this.walkTree(new TreeAction(){

            @Override
            public void classAction(Cl cl) {
                cl.setupNameListDowns();
            }
        });
        Cl.nameSpace = 0;
        final ClassNotFoundException[] ex = new ClassNotFoundException[1];
        try {
            this.walkTree(new TreeAction(){

                @Override
                public void classAction(Cl cl) {
                    try {
                        cl.resolveOptimally();
                    }
                    catch (ClassNotFoundException cnfe) {
                        ex[0] = cnfe;
                        throw new RuntimeException();
                    }
                }
            });
        }
        catch (RuntimeException rte) {
            if (ex[0] != null) {
                throw ex[0];
            }
            throw rte;
        }
    }

    public String[] getAttrsToKeep() {
        String[] attrs = new String[this.retainAttrs.size()];
        for (int i = 0; i < attrs.length; ++i) {
            attrs[i] = (String)this.retainAttrs.elementAt(i);
        }
        return attrs;
    }

    public Enumeration getClEnum(String fullName) {
        return this.getClEnum(fullName, 4103);
    }

    public Enumeration getClEnum(String fullName, final int classMode) {
        final Vector<Cl> vec = new Vector<Cl>();
        if (fullName.indexOf(42) != -1) {
            if (fullName.indexOf(33) == 0) {
                final String fName = fullName.substring(1);
                this.walkTree(new TreeAction(){

                    @Override
                    public void classAction(Cl cl) {
                        if (cl.isWildcardMatch(fName) && ClassTree.this.modifierMatch(classMode, cl.getModifiers())) {
                            vec.addElement(cl);
                        }
                    }
                });
            } else {
                final String fName = fullName;
                this.walkTree(new TreeAction(){

                    @Override
                    public void classAction(Cl cl) {
                        if (cl.isNRWildcardMatch(fName) && ClassTree.this.modifierMatch(classMode, cl.getModifiers())) {
                            vec.addElement(cl);
                        }
                    }
                });
            }
        } else {
            Cl cl = this.getCl(fullName);
            if (cl != null) {
                boolean match;
                int mods = cl.getModifiers();
                if (cl.isInnerClass()) {
                    Cl cl2 = (Cl)cl.getParent();
                }
                if ((match = this.modifierMatch(classMode, cl.getModifiers())) || classMode == 0) {
                    vec.addElement(cl);
                }
            }
        }
        return vec.elements();
    }

    public Enumeration getMdEnum(String fullName, String descriptor) {
        final Vector<Md> vec = new Vector<Md>();
        final String fDesc = descriptor;
        if (fullName.indexOf(42) != -1 || descriptor.indexOf(42) != -1) {
            if (fullName.indexOf(33) == 0) {
                final String fName = fullName.substring(1);
                this.walkTree(new TreeAction(){

                    @Override
                    public void methodAction(Md md) {
                        if (md.isWildcardMatch(fName, fDesc)) {
                            vec.addElement(md);
                        }
                    }
                });
            } else {
                final String fName = fullName;
                this.walkTree(new TreeAction(){

                    @Override
                    public void methodAction(Md md) {
                        if (md.isNRWildcardMatch(fName, fDesc)) {
                            vec.addElement(md);
                        }
                    }
                });
            }
        } else {
            Md md = this.getMd(fullName, descriptor);
            if (md != null) {
                vec.addElement(md);
            }
        }
        return vec.elements();
    }

    public Enumeration getFdEnum(String fullName) {
        final Vector<Fd> vec = new Vector<Fd>();
        if (fullName.indexOf(42) != -1) {
            if (fullName.indexOf(33) == 0) {
                final String fName = fullName.substring(1);
                this.walkTree(new TreeAction(){

                    @Override
                    public void fieldAction(Fd fd) {
                        if (fd.isWildcardMatch(fName)) {
                            vec.addElement(fd);
                        }
                    }
                });
            } else {
                final String fName = fullName;
                this.walkTree(new TreeAction(){

                    @Override
                    public void fieldAction(Fd fd) {
                        if (fd.isNRWildcardMatch(fName)) {
                            vec.addElement(fd);
                        }
                    }
                });
            }
        } else {
            Fd fd = this.getFd(fullName);
            if (fd != null) {
                vec.addElement(fd);
            }
        }
        return vec.elements();
    }

    public Cl getCl(String fullName) {
        PkCl ti = this.root;
        Enumeration nameEnum = ClassTree.getNameEnum(fullName);
        while (nameEnum.hasMoreElements()) {
            Cons nameSegment = (Cons)nameEnum.nextElement();
            char tag = ((Character)nameSegment.car).charValue();
            String name = (String)nameSegment.cdr;
            switch (tag) {
                case '/': {
                    ti = ti.getPackage(name);
                    break;
                }
                case '$': {
                    ti = ((PkCl)ti).getClass(name);
                    break;
                }
                default: {
                    throw new ParseException("Internal error: illegal package/class name tag");
                }
            }
            if (ti != null) continue;
            return null;
        }
        if (!(ti instanceof Cl)) {
            throw new ParseException("Inconsistent class or interface name.");
        }
        return (Cl)ti;
    }

    public Pk getPk(String fullName) {
        Pk ti = this.root;
        Enumeration nameEnum = ClassTree.getNameEnum(fullName);
        while (nameEnum.hasMoreElements()) {
            Cons nameSegment = (Cons)nameEnum.nextElement();
            String name = (String)nameSegment.cdr;
            if ((ti = ti.getPackage(name)) == null) {
                return null;
            }
            if (ti instanceof Pk) continue;
            throw new ParseException("Inconsistent package.");
        }
        return ti;
    }

    public Md getMd(String fullName, String descriptor) {
        int pos = fullName.lastIndexOf(47);
        Cl cl = this.getCl(fullName.substring(0, pos));
        return cl.getMethod(fullName.substring(pos + 1), descriptor);
    }

    public Fd getFd(String fullName) {
        int pos = fullName.lastIndexOf(47);
        Cl cl = this.getCl(fullName.substring(0, pos));
        return cl.getField(fullName.substring(pos + 1));
    }

    @Override
    public String[] getAttrsToKeep(String className) {
        Cl cl = this.getCl(className);
        if (cl != null) {
            Set attrs = cl.getAttributesToKeep();
            if (attrs != null && attrs.size() > 0) {
                String[] other = this.getAttrsToKeep();
                HashSet<String> tmp = new HashSet<String>(attrs);
                for (int i = 0; i < other.length; ++i) {
                    tmp.add(other[i]);
                }
                return tmp.toArray(new String[tmp.size()]);
            }
            return this.getAttrsToKeep();
        }
        return this.getAttrsToKeep();
    }

    @Override
    public String mapLocalVariable(String thisClassName, String methodName, String descriptor, String string) {
        return string;
    }

    @Override
    public String mapClass(String className) {
        if (className.length() > 0 && className.charAt(0) == '[') {
            StringBuffer newName = new StringBuffer();
            int i = 0;
            block6: while (i < className.length()) {
                char ch = className.charAt(i++);
                switch (ch) {
                    case ';': 
                    case '[': {
                        newName.append(ch);
                        continue block6;
                    }
                    case 'L': {
                        newName.append(ch);
                        int pos = className.indexOf(59, i);
                        if (pos < 0) {
                            throw new ParseException("Invalid class name encountered: " + className);
                        }
                        newName.append(this.mapClass(className.substring(i, pos)));
                        i = pos;
                        continue block6;
                    }
                }
                return className;
            }
            return newName.toString();
        }
        Cl cl = this.getCl(className);
        if (cl == null) {
            try {
                Class aClass = Cl.getClassResolver().resolve(Conversion.toJavaClass(className));
                return className;
            }
            catch (ClassNotFoundException e) {
                if (this.pedantic) {
                    throw new NoSuchMappingException("Class " + Conversion.toJavaClass(className));
                }
                Logger.getInstance().warningToLogfile("Unresolved external dependency: " + Conversion.toJavaClass(className) + " not found!");
                Logger.getInstance().setUnresolved();
                return className;
            }
        }
        return cl.getFullOutName();
    }

    @Override
    public String mapMethod(String className, String methodName, String descriptor) {
        Cl cl;
        if (className.startsWith("[") && className.endsWith(";")) {
            int count = 0;
            while (className.charAt(count) == '[') {
                ++count;
            }
            if (className.charAt(count) == 'L') {
                className = className.substring(count + 1, className.length() - 1);
            }
        }
        if ((cl = this.getCl(className)) != null && cl.getMethod(methodName, descriptor) != null) {
            return cl.getMethod(methodName, descriptor).getOutName();
        }
        if (cl == null) {
            try {
                Class clazz = Cl.getClassResolver().resolve(Conversion.toJavaClass(className));
            }
            catch (ClassNotFoundException e) {
                if (this.pedantic) {
                    throw new NoSuchMappingException("Class " + Conversion.toJavaClass(className));
                }
                Logger.getInstance().warningToLogfile("No mapping found: " + Conversion.toJavaClass(className));
            }
            return methodName;
        }
        try {
            String result = cl.getMethodOutNameUp(methodName, descriptor);
            if (result != null) {
                return result;
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        if (!methodName.equals("<init>") && !methodName.equals("<clinit>")) {
            if (this.pedantic) {
                throw new NoSuchMappingException("Method " + Conversion.toJavaClass(className) + "." + methodName);
            }
            Logger.getInstance().error("Method " + Conversion.toJavaClass(className) + "." + methodName + " could not be mapped !\n Probably broken code! Try rebuilding from source!");
            return methodName;
        }
        return methodName;
    }

    @Override
    public String mapAnnotationField(String className, String methodName) {
        Cl cl = this.getCl(className);
        if (cl != null) {
            Enumeration enumeration = cl.getMethodEnum();
            while (enumeration.hasMoreElements()) {
                Md md = (Md)enumeration.nextElement();
                if (!md.getInName().equals(methodName)) continue;
                return md.getOutName();
            }
            return methodName;
        }
        return methodName;
    }

    @Override
    public String mapField(String className, String fieldName) {
        Cl cl = this.getCl(className);
        if (cl != null && cl.getField(fieldName) != null) {
            if (fieldName.startsWith("class$") && this.isReplaceClassNameStrings()) {
                String realClassName = fieldName.substring(6);
                ArrayList<String> nameParts = new ArrayList<String>(20);
                StringTokenizer st = new StringTokenizer(realClassName, "$", false);
                while (st.hasMoreTokens()) {
                    nameParts.add(st.nextToken());
                }
                String[] names = new String[nameParts.size()];
                nameParts.toArray(names);
                TreeItem ti = this.findTreeItem(names);
                if (ti instanceof Cl) {
                    Fd fd = cl.getField(fieldName);
                    String newClassName = this.mapClass(ti.getFullInName());
                    String outName = "class$" + newClassName.replace('/', '$');
                    fd.setOutName(outName);
                    return outName;
                }
            }
            return cl.getField(fieldName).getOutName();
        }
        if (cl == null) {
            return fieldName;
        }
        try {
            String result = cl.getFieldOutNameUp(fieldName);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!fieldName.equals("this")) {
            if (this.pedantic) {
                throw new NoSuchMappingException("Field " + className + "." + fieldName);
            }
            Logger.getInstance().error("Field " + className + "." + fieldName + " could not be mapped !\n Probably broken code! Try rebuilding from source!");
        }
        return fieldName;
    }

    @Override
    public String mapSignature(String signature) {
        StringBuffer classString = new StringBuffer();
        StringBuffer newSignature = new StringBuffer();
        int i = 0;
        block8: while (i < signature.length()) {
            char ch = signature.charAt(i++);
            switch (ch) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case ':': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': 
                case '[': {
                    newSignature.append(ch);
                    continue block8;
                }
                case ';': {
                    newSignature.append(ch);
                    classString.setLength(0);
                    continue block8;
                }
                case 'T': {
                    newSignature.append(ch);
                    int pos = signature.indexOf(59, i);
                    if (pos < 0) {
                        throw new ParseException("Invalid signature string encountered.");
                    }
                    newSignature.append(signature.substring(i, pos));
                    i = pos;
                    continue block8;
                }
                case '<': {
                    int first;
                    newSignature.append(ch);
                    do {
                        first = i;
                        while (signature.charAt(i) != ':') {
                            ++i;
                        }
                        String templateName = signature.substring(first, i);
                        newSignature.append(templateName);
                        while (signature.charAt(i) == ':') {
                            newSignature.append(':');
                            int firstPos = ++i;
                            int bracketCount = 0;
                            while (bracketCount != 0 || signature.charAt(i) != ';') {
                                if (signature.charAt(i) == '<') {
                                    ++bracketCount;
                                } else if (signature.charAt(i) == '>') {
                                    --bracketCount;
                                }
                                ++i;
                            }
                            newSignature.append(this.mapSignature(signature.substring(firstPos, ++i)));
                        }
                    } while (signature.charAt(i) != '>');
                    newSignature.append('>');
                    ++i;
                    continue block8;
                }
                case '^': {
                    int first;
                    newSignature.append(ch);
                    if (signature.charAt(i) == 'T') {
                        while (signature.charAt(i) != ';') {
                            newSignature.append(signature.charAt(i));
                            ++i;
                        }
                        continue block8;
                    }
                    if (signature.charAt(i) == 'L') {
                        first = i;
                        int bracketCount = 0;
                        while (signature.charAt(i) != ';' || bracketCount != 0) {
                            char c = signature.charAt(i);
                            if (c == '<') {
                                ++bracketCount;
                            } else if (c == '>') {
                                --bracketCount;
                            }
                            ++i;
                        }
                        String classSig = signature.substring(first, ++i);
                        newSignature.append(this.mapSignature(classSig));
                        continue block8;
                    }
                    throw new IllegalStateException("Could not map signature " + signature);
                }
                case '.': 
                case 'L': {
                    newSignature.append(ch);
                    int pos = signature.indexOf(59, i);
                    int bracketPos = signature.indexOf(60, i);
                    if (bracketPos >= i && bracketPos < pos) {
                        int bracketCount = 0;
                        int closingBracket = signature.length();
                        for (int walker = bracketPos + 1; walker < signature.length(); ++walker) {
                            char c = signature.charAt(walker);
                            if (c == '<') {
                                ++bracketCount;
                                continue;
                            }
                            if (c != '>') continue;
                            if (bracketCount == 0) {
                                closingBracket = walker;
                                break;
                            }
                            --bracketCount;
                        }
                        pos = closingBracket + 1;
                        String templateArg = signature.substring(bracketPos + 1, closingBracket);
                        String classNamePart = signature.substring(i, bracketPos);
                        if (ch == '.') {
                            this.appendInnerClass(classString, newSignature, classNamePart);
                        } else {
                            classString.append(classNamePart);
                            newSignature.append(this.mapClass(classString.toString()));
                        }
                        newSignature.append('<');
                        newSignature.append(this.mapSignature(templateArg));
                        newSignature.append('>');
                        i = pos;
                        continue block8;
                    }
                    if (pos < 0) {
                        throw new ParseException("Invalid signature string encountered: " + signature);
                    }
                    String classNamePart = signature.substring(i, pos);
                    if (ch == '.') {
                        this.appendInnerClass(classString, newSignature, classNamePart);
                    } else {
                        classString.append(classNamePart);
                        newSignature.append(this.mapClass(classString.toString()));
                    }
                    i = pos;
                    continue block8;
                }
            }
            throw new ParseException("Invalid signature string encountered: " + signature + " parsing char " + ch);
        }
        return newSignature.toString();
    }

    private void appendInnerClass(StringBuffer classString, StringBuffer newSignature, String classNamePart) {
        classString.append('$');
        classString.append(classNamePart);
        String className = classString.toString();
        String result = this.getClassNamePart(classNamePart, className);
        newSignature.append(result);
    }

    private String getClassNamePart(String classNamePart, String className) {
        int j = className.indexOf(classNamePart);
        if (classNamePart.indexOf(46) != -1 && j > 0) {
            String outerClassName = className.substring(0, j - 1);
            String retval = "";
            String currentClassName = outerClassName;
            StringBuilder innerClassName = new StringBuilder();
            for (int i = 0; i < classNamePart.length(); ++i) {
                char c = classNamePart.charAt(i);
                if (c == '.') {
                    currentClassName = currentClassName + '$' + innerClassName;
                    retval = this.appendOutName(retval, currentClassName);
                    innerClassName = new StringBuilder();
                    continue;
                }
                innerClassName.append(c);
            }
            currentClassName = currentClassName + '$' + innerClassName;
            retval = this.appendOutName(retval, currentClassName);
            return retval;
        }
        Cl cl = this.getCl(className);
        if (cl == null) {
            try {
                Class aClass = Cl.getClassResolver().resolve(Conversion.toJavaClass(className));
                return classNamePart;
            }
            catch (ClassNotFoundException e) {
                if (this.pedantic) {
                    throw new NoSuchMappingException("Class " + Conversion.toJavaClass(className));
                }
                Logger.getInstance().warningToLogfile("Unresolved external dependency: " + Conversion.toJavaClass(className) + " not found!");
                Logger.getInstance().setUnresolved();
                return classNamePart;
            }
        }
        return cl.getOutName();
    }

    private String appendOutName(String retval, String currentClassName) {
        Cl cl = this.getCl(currentClassName);
        if (null != cl) {
            if (retval.length() > 0) {
                retval = retval + '.';
            }
            retval = retval + cl.getOutName();
        } else {
            try {
                Class aClass = Cl.getClassResolver().resolve(Conversion.toJavaClass(currentClassName));
                retval = retval + "." + currentClassName;
            }
            catch (ClassNotFoundException e) {
                if (this.pedantic) {
                    throw new NoSuchMappingException("Class " + Conversion.toJavaClass(currentClassName));
                }
                Logger.getInstance().warningToLogfile("Unresolved external dependency: " + Conversion.toJavaClass(currentClassName) + " not found!");
                Logger.getInstance().setUnresolved();
                retval = retval + "." + currentClassName;
            }
        }
        return retval;
    }

    @Override
    public String mapSourceFile(String className, String sourceFileName) {
        Cl cl = this.getCl(className);
        if (cl.isSourceFileMappingSet()) {
            return cl.getSourceFileMapping();
        }
        return sourceFileName;
    }

    @Override
    public boolean mapLineNumberTable(String className, String methodName, String methodSignature, LineNumberTableAttrInfo info) {
        Cl cl = this.getCl(className);
        if (cl.getLineNumberTableMapper() != null) {
            return cl.getLineNumberTableMapper().mapLineNumberTable(className, methodName, methodSignature, info);
        }
        return true;
    }

    @Override
    public String mapDescriptor(String descriptor) {
        StringBuffer newDesc = new StringBuffer();
        int i = 0;
        block4: while (i < descriptor.length()) {
            char ch = descriptor.charAt(i++);
            switch (ch) {
                case '(': 
                case ')': 
                case ';': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': 
                case '[': {
                    newDesc.append(ch);
                    continue block4;
                }
                case 'L': {
                    newDesc.append(ch);
                    int pos = descriptor.indexOf(59, i);
                    if (pos < 0) {
                        throw new ParseException("Invalid descriptor string encountered.");
                    }
                    newDesc.append(this.mapClass(descriptor.substring(i, pos)));
                    i = pos;
                    continue block4;
                }
            }
            throw new ParseException("Invalid descriptor string encountered.");
        }
        return newDesc.toString();
    }

    @Override
    public String mapPackage(String packageName) {
        Pk pk = this.getPk(packageName);
        return pk == null ? packageName : pk.getFullOutName();
    }

    public void dump(final PrintWriter log) {
        log.println("<expose>");
        this.walkTree(new TreeAction(){

            @Override
            public void classAction(Cl cl) {
                String name = cl.getFullInName();
                if (cl.isFromScript() && !"module-info".equals(name)) {
                    String cla = ClassTree.toUtf8XmlString(Conversion.toJavaClass(name));
                    log.println("  <class name=\"" + cla + "\"/>");
                }
            }

            @Override
            public void methodAction(Md md) {
                if (md.isFromScript()) {
                    String cla = ClassTree.toUtf8XmlString(Conversion.toJavaClass(md.getParent().getFullInName()));
                    String method = ClassTree.toUtf8XmlString(Conversion.toJavaMethod(md.getInName(), md.getDescriptor()));
                    log.println("  <method class=\"" + cla + "\" name=\"" + method + "\"/>");
                }
            }

            @Override
            public void fieldAction(Fd fd) {
                if (fd.isFromScript()) {
                    String cla = ClassTree.toUtf8XmlString(Conversion.toJavaClass(fd.getParent().getFullInName()));
                    log.println("  <field class=\"" + cla + "\" name=\"" + ClassTree.toUtf8XmlString(fd.getInName()) + "\"/>");
                }
            }

            @Override
            public void packageAction(Pk pk) {
            }
        });
        log.println("</expose>");
        log.println("<map>");
        this.walkTree(new TreeAction(){

            @Override
            public void classAction(Cl cl) {
                String name = cl.getFullInName();
                if (!(!cl.isFromScriptMap() && cl.isFromScript() || "module-info".equals(name))) {
                    String cla = ClassTree.toUtf8XmlString(Conversion.toJavaClass(name));
                    log.println("  <class name=\"" + ClassTree.toUtf8XmlString(cla) + "\" map=\"" + ClassTree.toUtf8XmlString(cl.getOutName()) + "\"/>");
                }
            }

            @Override
            public void methodAction(Md md) {
                if (md.isFromScriptMap() || !md.isFromScript()) {
                    String cla = ClassTree.toUtf8XmlString(Conversion.toJavaClass(md.getParent().getFullInName()));
                    String method = ClassTree.toUtf8XmlString(Conversion.toJavaMethod(md.getInName(), md.getDescriptor()));
                    log.println("  <method class=\"" + cla + "\" name=\"" + method + "\" map=\"" + ClassTree.toUtf8XmlString(md.getOutName()) + "\"/>");
                }
            }

            @Override
            public void fieldAction(Fd fd) {
                if (fd.isFromScriptMap() || !fd.isFromScript()) {
                    String cla = ClassTree.toUtf8XmlString(Conversion.toJavaClass(fd.getParent().getFullInName()));
                    log.println("  <field class=\"" + cla + "\" name=\"" + ClassTree.toUtf8XmlString(fd.getInName()) + "\" map=\"" + ClassTree.toUtf8XmlString(fd.getOutName()) + "\"/>");
                }
            }

            @Override
            public void packageAction(Pk pk) {
                if ((pk.isFromScriptMap() || !pk.isFromScript()) && pk.getFullInName().length() > 0) {
                    String pa = ClassTree.toUtf8XmlString(Conversion.toJavaClass(pk.getFullInName()));
                    log.println("  <package name=\"" + pa + "\" map=\"" + ClassTree.toUtf8XmlString(pk.getOutName()) + "\"/>");
                }
            }
        });
        log.println("</map>");
    }

    public static final String toUtf8XmlString(String s) {
        boolean bad = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0080' && c != '\"' && c != '<') continue;
            bad = true;
            break;
        }
        if (bad) {
            StringBuffer buf = new StringBuffer(s.length());
            for (int i = 0; i < s.length(); ++i) {
                buf.append(ClassTree.toUtf8XmlChar(s.charAt(i)));
            }
            return buf.toString();
        }
        return s;
    }

    private static final String toUtf8XmlChar(char c) {
        if (c < '\u0080') {
            if (c == '\"') {
                return "&#x22;";
            }
            if (c == '<') {
                return "&#x3c;";
            }
            return new String(new char[]{c});
        }
        if (c < '\u0800') {
            StringBuffer buf = new StringBuffer(8);
            buf.append("&#x");
            buf.append(hex[c >> 8 & 0xFF]);
            buf.append(hex[c & 0xFF]);
            buf.append(';');
            return buf.toString();
        }
        StringBuffer buf = new StringBuffer(10);
        buf.append("&#x");
        buf.append(hex[c >> 16 & 0xFF]);
        buf.append(hex[c >> 8 & 0xFF]);
        buf.append(hex[c & 0xFF]);
        buf.append(';');
        return buf.toString();
    }

    private static String toHex(int i) {
        StringBuffer buf = new StringBuffer(2);
        buf.append(hexChars.charAt(i / 16 & 0xF));
        buf.append(hexChars.charAt(i & 0xF));
        return buf.toString();
    }

    private void retainHierarchy(TreeItem ti) {
        if (!ti.isFixed()) {
            ti.setOutName(ti.getInName());
            ti.setFromScript();
        }
        if (ti.parent != null) {
            this.retainHierarchy(ti.parent);
        }
    }

    public void walkTree(TreeAction ta) {
        this.walkTree(ta, this.root);
    }

    private void walkTree(TreeAction ta, TreeItem ti) {
        if (ti instanceof Pk) {
            Enumeration packageEnum = ((Pk)ti).getPackageEnum();
            ta.packageAction((Pk)ti);
            while (packageEnum.hasMoreElements()) {
                this.walkTree(ta, (TreeItem)packageEnum.nextElement());
            }
        }
        if (ti instanceof PkCl) {
            Enumeration classEnum = ((PkCl)ti).getClassEnum();
            while (classEnum.hasMoreElements()) {
                this.walkTree(ta, (TreeItem)classEnum.nextElement());
            }
        }
        if (ti instanceof Cl) {
            Enumeration fieldEnum = ((Cl)ti).getFieldEnum();
            Enumeration methodEnum = ((Cl)ti).getMethodEnum();
            ta.classAction((Cl)ti);
            while (fieldEnum.hasMoreElements()) {
                ta.fieldAction((Fd)fieldEnum.nextElement());
            }
            while (methodEnum.hasMoreElements()) {
                ta.methodAction((Md)methodEnum.nextElement());
            }
        }
    }

    public boolean isReplaceClassNameStrings() {
        return this.replaceClassNameStrings;
    }

    public void setReplaceClassNameStrings(boolean replaceClassNameStrings) {
        this.replaceClassNameStrings = replaceClassNameStrings;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public void retainSourceFileAttributeMap(String name, String obfName) {
        Enumeration clEnum = this.getClEnum(name);
        while (clEnum.hasMoreElements()) {
            Cl classItem = (Cl)clEnum.nextElement();
            classItem.setSourceFileMapping(obfName);
            classItem.getAttributesToKeep().add("SourceFile");
        }
    }

    public void retainLineNumberTable(String name, LineNumberTableMapper lineNumberTableMapper) {
        Enumeration clEnum = this.getClEnum(name);
        while (clEnum.hasMoreElements()) {
            Cl classItem = (Cl)clEnum.nextElement();
            classItem.setLineNumberTableMapper(lineNumberTableMapper);
            classItem.getAttributesToKeep().add("LineNumberTable");
        }
    }

    public void retainAttributeForClass(String className, String attributeDescriptor) {
        Enumeration clEnum = this.getClEnum(className);
        while (clEnum.hasMoreElements()) {
            Cl classItem = (Cl)clEnum.nextElement();
            Set set = classItem.getAttributesToKeep();
            set.add(attributeDescriptor);
        }
    }

    public void retainPackage(String packageName) {
        this.retainHierarchy(this.getPk(packageName));
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ClassTree.hex[i] = ClassTree.toHex(i);
        }
    }
}

