/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.CharBuffer;

class Streams {
    private Streams() {
    }

    static OutputStream newGuard(OutputStream os) {
        return new Guard(os);
    }

    static Reader newTail(Reader r, int[] tail) {
        return new Tail(r, tail);
    }

    private static final class Tail
    extends Reader {
        private final Reader r;
        private final int[] tail;

        Tail(Reader r, int[] tail) {
            this.r = r;
            this.tail = tail;
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            int read = this.r.read(target);
            if (read > -1) {
                this.tail[0] = target.charAt(read - 1);
            }
            return read;
        }

        @Override
        public int read() throws IOException {
            this.tail[0] = this.r.read();
            return this.tail[0];
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            int read = this.r.read(cbuf);
            if (read > -1) {
                this.tail[0] = cbuf[read - 1];
            }
            return read;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int read = this.r.read(cbuf, off, len);
            if (read > -1) {
                this.tail[0] = cbuf[off + read - 1];
            }
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.r.skip(n);
        }

        @Override
        public boolean ready() throws IOException {
            return this.r.ready();
        }

        @Override
        public boolean markSupported() {
            return this.r.markSupported();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.r.mark(readAheadLimit);
        }

        @Override
        public void reset() throws IOException {
            this.r.reset();
        }

        @Override
        public void close() throws IOException {
            this.r.close();
        }
    }

    private static final class Guard
    extends OutputStream {
        private final OutputStream os;

        Guard(OutputStream os) {
            this.os = os;
        }

        @Override
        public void write(int b) throws IOException {
            this.os.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.os.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void close() throws IOException {
            this.os.flush();
        }
    }
}

