/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.abstractjar.impl;

import com.yworks.util.abstractjar.ArchiveWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Manifest;

public class DirectoryWriterImpl
extends ArchiveWriter {
    private final File archive;

    public DirectoryWriterImpl(File archive, Manifest man) throws IOException {
        super(man);
        this.archive = archive;
        this.writeManifest(man);
    }

    @Override
    public void setComment(String comment) {
    }

    @Override
    public void addDirectory(String path) throws IOException {
        File file = new File(this.archive, path);
        DirectoryWriterImpl.makeDirs(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(String path, byte[] data) throws IOException {
        File tgt = new File(this.archive, path);
        DirectoryWriterImpl.ensurePath(tgt);
        try (FileOutputStream os = new FileOutputStream(tgt);){
            ((OutputStream)os).write(data);
            os.flush();
        }
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeManifest(Manifest manifest) throws IOException {
        File tgt = new File(this.archive, "META-INF/MANIFEST.MF");
        DirectoryWriterImpl.ensurePath(tgt);
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tgt));){
            manifest.write(os);
            ((OutputStream)os).flush();
        }
    }

    private static void ensurePath(File file) throws IOException {
        DirectoryWriterImpl.makeDirs(file.getParentFile());
    }

    private static void makeDirs(File file) throws IOException {
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("Could not create directory " + file.getAbsolutePath() + '.');
        }
    }
}

