/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.abstractjar.impl;

import com.yworks.util.abstractjar.Archive;
import com.yworks.util.abstractjar.Entry;
import com.yworks.util.abstractjar.impl.FileEntryWrapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;

public class DirectoryWrapper
extends SimpleFileVisitor<Path>
implements Archive {
    private File directory;
    private Map<Entry, File> entries = new HashMap<Entry, File>();

    public DirectoryWrapper(File directory) throws IOException {
        this.directory = directory;
        Files.walkFileTree(directory.toPath(), this);
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        if (attrs.isRegularFile()) {
            this.entries.put(new FileEntryWrapper(path.toFile(), this.directory.toPath().relativize(path).toString()), path.toFile());
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public String getName() {
        return this.directory.getName();
    }

    @Override
    public Enumeration<Entry> getEntries() {
        return Collections.enumeration(this.entries.keySet());
    }

    @Override
    public Manifest getManifest() throws IOException {
        File manifestFile = new File(this.directory, "META-INF/MANIFEST.MF");
        if (manifestFile.exists()) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(manifestFile));){
                Manifest manifest = new Manifest(is);
                return manifest;
            }
        }
        return null;
    }

    @Override
    public InputStream getInputStream(Entry entry) throws IOException {
        return new FileInputStream(this.entries.get(entry));
    }

    @Override
    public void close() throws IOException {
    }
}

