/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.common.ant;

import com.yworks.common.ant.TypePatternSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.PatternSet;

public abstract class PatternMatchedSection {
    private Access access = null;
    protected Set<TypePatternSet.Type> types;
    protected Map<TypePatternSet.Type, PatternSet> patternSets;

    public TypePatternSet createPatternSet() {
        TypePatternSet typePatternSet = new TypePatternSet();
        this.addPatternSet(typePatternSet, typePatternSet.getType());
        return typePatternSet;
    }

    public void addPatternSet(PatternSet ps, TypePatternSet.Type type) {
        if (null == this.patternSets) {
            this.patternSets = new EnumMap<TypePatternSet.Type, PatternSet>(TypePatternSet.Type.class);
        }
        if (null != this.patternSets.get((Object)type)) {
            PatternSet existing = this.patternSets.get((Object)type);
            ps.addConfiguredPatternset(existing);
        }
        this.patternSets.put(type, ps);
    }

    public PatternSet getPatternSet(TypePatternSet.Type type) {
        if (null != this.patternSets) {
            return this.patternSets.get((Object)type);
        }
        return null;
    }

    public void setAccess(String access) {
        this.access = Access.valueOf(access.toUpperCase());
    }

    public Access getAccess() {
        return this.access;
    }

    protected Access accessValue(String accessString) {
        Access access = null;
        if (accessString.trim().equals("")) {
            throw new BuildException("You specified an empty access modifier.");
        }
        try {
            access = Access.valueOf(accessString.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new BuildException("Illegal access modifier: " + accessString);
        }
        return access;
    }

    public static enum Access {
        PUBLIC,
        PROTECTED,
        FRIENDLY,
        PRIVATE,
        NONE;


        public boolean isAccessLevel(Access level) {
            if (this.equals((Object)NONE) && !level.equals((Object)NONE)) {
                return false;
            }
            return this.compareTo(level) >= 0;
        }

        public boolean isAccessLevel(int asmAccess) {
            return this.isAccessLevel(Access.valueOf(asmAccess));
        }

        public static Access valueOf(int asmAccess) {
            if ((asmAccess & 1) == 1) {
                return PUBLIC;
            }
            if ((asmAccess & 4) == 4) {
                return PROTECTED;
            }
            if ((asmAccess & 2) == 2) {
                return PRIVATE;
            }
            return FRIENDLY;
        }
    }
}

