/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.core.rpc;

import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.context.TLogLabelGenerator;
import com.yomahub.tlog.core.context.AspectLogContext;
import com.yomahub.tlog.core.rpc.TLogLabelBean;
import com.yomahub.tlog.id.TLogIdGeneratorLoader;
import com.yomahub.tlog.utils.LocalhostUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TLogRPCHandler {
    protected static final Logger log = LoggerFactory.getLogger(TLogRPCHandler.class);

    public void processProviderSide(TLogLabelBean labelBean) {
        if (StringUtils.isBlank((CharSequence)labelBean.getPreIvkApp())) {
            labelBean.setPreIvkApp("NONE");
        }
        TLogContext.putPreIvkApp((String)labelBean.getPreIvkApp());
        if (StringUtils.isBlank((CharSequence)labelBean.getPreIvkHost())) {
            labelBean.setPreIvkHost("NONE");
        }
        TLogContext.putPreIvkHost((String)labelBean.getPreIvkHost());
        if (StringUtils.isBlank((CharSequence)labelBean.getPreIp())) {
            labelBean.setPreIp("NONE");
        }
        TLogContext.putPreIp((String)labelBean.getPreIp());
        if (StringUtils.isBlank((CharSequence)labelBean.getTraceId())) {
            labelBean.setTraceId(TLogIdGeneratorLoader.getIdGenerator().withExtData(labelBean.getExtData()).generateTraceId());
            log.debug("[TLOG]\u53ef\u80fd\u4e0a\u4e00\u4e2a\u8282\u70b9[{}]\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u91cd\u65b0\u751f\u6210traceId[{}]", (Object)labelBean.getPreIvkApp(), (Object)labelBean.getTraceId());
        }
        TLogContext.putSpanId((String)labelBean.getSpanId());
        TLogContext.putTraceId((String)labelBean.getTraceId());
        TLogContext.putCurrIp((String)LocalhostUtil.getHostIp());
        String tlogLabel = TLogLabelGenerator.generateTLogLabel((String)labelBean.getPreIvkApp(), (String)labelBean.getPreIvkHost(), (String)labelBean.getPreIp(), (String)TLogContext.getCurrIp(), (String)labelBean.getTraceId(), (String)TLogContext.getSpanId());
        AspectLogContext.putLogValue(tlogLabel);
        MDC.put((String)"tl", (String)tlogLabel);
        MDC.put((String)"tlogTraceId", (String)TLogContext.getTraceId());
        MDC.put((String)"tlogSpanId", (String)TLogContext.getSpanId());
        MDC.put((String)"currIp", (String)TLogContext.getCurrIp());
        MDC.put((String)"preIp", (String)TLogContext.getPreIp());
        MDC.put((String)"preIvkHost", (String)TLogContext.getPreIvkHost());
        MDC.put((String)"preIvkApp", (String)TLogContext.getPreIvkApp());
    }

    public void cleanThreadLocal() {
        TLogContext.removePreIvkApp();
        TLogContext.removePreIvkHost();
        TLogContext.removePreIp();
        TLogContext.removeCurrIp();
        TLogContext.removeTraceId();
        TLogContext.removeSpanId();
        AspectLogContext.remove();
        MDC.remove((String)"tl");
        MDC.remove((String)"tlogTraceId");
        MDC.remove((String)"tlogSpanId");
        MDC.remove((String)"currIp");
        MDC.remove((String)"preIp");
        MDC.remove((String)"preIvkHost");
        MDC.remove((String)"preIvkApp");
    }
}

