/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.read;

import com.yomahub.liteflow.parser.constant.ReadType;
import com.yomahub.liteflow.parser.sql.polling.SqlReadPollTask;
import com.yomahub.liteflow.parser.sql.polling.impl.ChainReadPollTask;
import com.yomahub.liteflow.parser.sql.polling.impl.ScriptReadPollTask;
import com.yomahub.liteflow.parser.sql.read.SqlRead;
import com.yomahub.liteflow.parser.sql.read.impl.ChainRead;
import com.yomahub.liteflow.parser.sql.read.impl.ScriptRead;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import java.util.HashMap;
import java.util.Map;

public class SqlReadFactory {
    private static final Map<ReadType, SqlRead<?>> READ_MAP = new HashMap();
    private static final Map<ReadType, SqlReadPollTask<?>> POLL_TASK_MAP = new HashMap();

    public static void registerRead(SQLParserVO config) {
        READ_MAP.put(ReadType.CHAIN, new ChainRead(config));
        READ_MAP.put(ReadType.SCRIPT, new ScriptRead(config));
    }

    public static void registerSqlReadPollTask(ReadType readType) {
        SqlRead sqlRead = SqlReadFactory.getSqlRead(readType);
        if (ReadType.CHAIN.equals((Object)readType)) {
            POLL_TASK_MAP.put(ReadType.CHAIN, new ChainReadPollTask((ChainRead)sqlRead));
        } else if (ReadType.SCRIPT.equals((Object)readType)) {
            POLL_TASK_MAP.put(ReadType.SCRIPT, new ScriptReadPollTask((ScriptRead)sqlRead));
        }
    }

    public static <T> SqlRead<T> getSqlRead(ReadType readType) {
        return READ_MAP.get((Object)readType);
    }

    public static <T> SqlReadPollTask<T> getSqlReadPollTask(ReadType readType) {
        return POLL_TASK_MAP.get((Object)readType);
    }
}

