/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el.operator;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.ql.util.express.exception.QLException;
import com.yomahub.liteflow.builder.el.operator.base.BaseOperator;
import com.yomahub.liteflow.builder.el.operator.base.OperatorHelper;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;

public class NodeOperator
extends BaseOperator<Node> {
    @Override
    public Node build(Object[] objects) throws Exception {
        OperatorHelper.checkObjectSizeNeqOne(objects);
        String nodeId = OperatorHelper.convert(objects[0], String.class);
        if (FlowBus.containNode(nodeId)) {
            return FlowBus.getNode(nodeId);
        }
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        if (StrUtil.isNotBlank((CharSequence)liteflowConfig.getSubstituteCmpClass())) {
            Node substituteNode = FlowBus.getNodeMap().values().stream().filter(node -> node.getInstance().getClass().getName().equals(liteflowConfig.getSubstituteCmpClass())).findFirst().orElse(null);
            if (ObjectUtil.isNotNull((Object)substituteNode)) {
                return substituteNode;
            }
            String error = StrUtil.format((CharSequence)"This node[{}] cannot be found", (Object[])new Object[]{nodeId});
            throw new QLException(error);
        }
        String error = StrUtil.format((CharSequence)"This node[{}] cannot be found, or you can configure an substitute node", (Object[])new Object[]{nodeId});
        throw new QLException(error);
    }
}

