/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el.operator;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import com.ql.util.express.exception.QLException;
import com.yomahub.liteflow.builder.el.operator.base.BaseOperator;
import com.yomahub.liteflow.builder.el.operator.base.OperatorHelper;
import com.yomahub.liteflow.core.NodeForComponent;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.ForCondition;

public class ForOperator
extends BaseOperator<ForCondition> {
    @Override
    public ForCondition build(Object[] objects) throws Exception {
        Node node;
        OperatorHelper.checkObjectSizeEq(objects, 1);
        if (objects[0] instanceof Node) {
            node = OperatorHelper.convert(objects[0], Node.class);
            if (!ListUtil.toList((Object[])new NodeTypeEnum[]{NodeTypeEnum.FOR, NodeTypeEnum.FOR_SCRIPT}).contains((Object)node.getType())) {
                throw new QLException("The parameter must be for-node item");
            }
        } else if (objects[0] instanceof Integer) {
            final Integer forCount = OperatorHelper.convert(objects[0], Integer.class);
            node = new Node();
            NodeForComponent nodeForComponent = new NodeForComponent(){

                @Override
                public int processFor() throws Exception {
                    return forCount;
                }
            };
            nodeForComponent.setSelf(nodeForComponent);
            nodeForComponent.setNodeId(StrUtil.format((CharSequence)"LOOP_{}", (Object[])new Object[]{forCount}));
            node.setInstance(nodeForComponent);
        } else {
            throw new QLException("The parameter must be Node item");
        }
        ForCondition forCondition = new ForCondition();
        forCondition.setForNode(node);
        return forCondition;
    }
}

