/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CopyOnWriteHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    volatile ConcurrentHashMap<K, V> view;

    private ConcurrentHashMap<K, V> duplicate(ConcurrentHashMap<K, V> original) {
        return new ConcurrentHashMap<K, V>(original);
    }

    public CopyOnWriteHashMap(ConcurrentHashMap<K, V> that) {
        this.view = this.duplicate(that);
    }

    public CopyOnWriteHashMap() {
        this(new ConcurrentHashMap());
    }

    @Override
    public CopyOnWriteHashMap<K, V> clone() {
        return new CopyOnWriteHashMap<K, V>(this.view);
    }

    @Override
    public int size() {
        return this.view.size();
    }

    @Override
    public boolean isEmpty() {
        return this.view.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.view.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.view.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.view.get(key);
    }

    @Override
    public ConcurrentHashMap.KeySetView<K, V> keySet() {
        return this.view.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.view.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.view.entrySet();
    }

    @Override
    public String toString() {
        return this.view.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            ConcurrentHashMap<K, V> newCore = this.duplicate(this.view);
            V result = newCore.put(key, value);
            this.view = newCore;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            ConcurrentHashMap<K, V> newCore = this.duplicate(this.view);
            V result = newCore.remove(key);
            this.view = newCore;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            ConcurrentHashMap<? extends K, ? extends V> newCore = this.duplicate(this.view);
            newCore.putAll(t);
            this.view = newCore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            this.view = new ConcurrentHashMap();
        }
    }
}

