/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.PreCondition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ThenCondition
extends Condition {
    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_THEN;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        List<PreCondition> preConditionList = this.getPreConditionList();
        List<FinallyCondition> finallyConditionList = this.getFinallyConditionList();
        try {
            for (PreCondition preCondition : preConditionList) {
                preCondition.setCurrChainId(this.getCurrChainId());
                preCondition.execute(slotIndex);
            }
            for (Executable executableItem : this.getExecutableList()) {
                executableItem.setCurrChainId(this.getCurrChainId());
                executableItem.execute(slotIndex);
            }
        }
        catch (ChainEndException e) {
            try {
                throw e;
                catch (Exception e2) {
                    Slot slot = DataBus.getSlot(slotIndex);
                    if (slot == null) throw e2;
                    String chainId = this.getCurrChainId();
                    if (slot.isSubChain(chainId)) {
                        slot.setSubException(chainId, e2);
                        throw e2;
                    }
                    slot.setException(e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                Iterator<FinallyCondition> iterator = finallyConditionList.iterator();
                while (iterator.hasNext()) {
                    FinallyCondition finallyCondition = iterator.next();
                    finallyCondition.setCurrChainId(this.getCurrChainId());
                    finallyCondition.execute(slotIndex);
                }
                throw throwable;
            }
        }
        Iterator<Executable> iterator = finallyConditionList.iterator();
        while (iterator.hasNext()) {
            FinallyCondition finallyCondition = (FinallyCondition)iterator.next();
            finallyCondition.setCurrChainId(this.getCurrChainId());
            finallyCondition.execute(slotIndex);
        }
    }

    @Override
    public void addExecutable(Executable executable) {
        if (executable instanceof PreCondition) {
            this.addPreCondition((PreCondition)executable);
        } else if (executable instanceof FinallyCondition) {
            this.addFinallyCondition((FinallyCondition)executable);
        } else {
            super.addExecutable(executable);
        }
    }

    public List<PreCondition> getPreConditionList() {
        return this.getExecutableList("PRE_KEY").stream().map(executable -> (PreCondition)executable).collect(Collectors.toList());
    }

    public void addPreCondition(PreCondition preCondition) {
        this.addExecutable("PRE_KEY", preCondition);
    }

    public List<FinallyCondition> getFinallyConditionList() {
        return this.getExecutableList("FINALLY_KEY").stream().map(executable -> (FinallyCondition)executable).collect(Collectors.toList());
    }

    public void addFinallyCondition(FinallyCondition finallyCondition) {
        this.addExecutable("FINALLY_KEY", finallyCondition);
    }
}

