/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.parallel.LoopFutureObj;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public abstract class LoopCondition
extends Condition {
    private boolean parallel = false;
    private final ReentrantLock lock = new ReentrantLock();

    protected Executable getBreakItem() {
        return this.getExecutableOne("BREAK_KEY");
    }

    public void setBreakItem(Executable breakNode) {
        this.addExecutable("BREAK_KEY", breakNode);
    }

    protected Executable getDoExecutor() {
        return this.getExecutableOne("DO_KEY");
    }

    public void setDoExecutor(Executable executable) {
        this.addExecutable("DO_KEY", executable);
    }

    protected void setLoopIndex(Executable executableItem, int index) {
        if (executableItem instanceof Chain) {
            ((Chain)executableItem).getConditionList().forEach(condition -> this.setLoopIndex((Executable)condition, index));
        } else if (executableItem instanceof Condition) {
            ((Condition)executableItem).getExecutableGroup().forEach((key, value) -> value.forEach(executable -> this.setLoopIndex((Executable)executable, index)));
        } else if (executableItem instanceof Node) {
            ((Node)executableItem).setLoopIndex(this, index);
        }
    }

    protected void setCurrLoopObject(Executable executableItem, Object obj) {
        if (executableItem instanceof Chain) {
            ((Chain)executableItem).getConditionList().forEach(condition -> this.setCurrLoopObject((Executable)condition, obj));
        } else if (executableItem instanceof Condition) {
            ((Condition)executableItem).getExecutableGroup().forEach((key, value) -> value.forEach(executable -> this.setCurrLoopObject((Executable)executable, obj)));
        } else if (executableItem instanceof Node) {
            ((Node)executableItem).setCurrLoopObject(this, obj);
        }
    }

    protected void removeLoopIndex(Executable executableItem) {
        if (executableItem instanceof Chain) {
            ((Chain)executableItem).getConditionList().forEach(this::removeLoopIndex);
        } else if (executableItem instanceof Condition) {
            ((Condition)executableItem).getExecutableGroup().forEach((key, value) -> value.forEach(this::removeLoopIndex));
        } else if (executableItem instanceof Node) {
            ((Node)executableItem).removeLoopIndex();
        }
    }

    protected void removeCurrLoopObject(Executable executableItem) {
        if (executableItem instanceof Chain) {
            ((Chain)executableItem).getConditionList().forEach(this::removeCurrLoopObject);
        } else if (executableItem instanceof Condition) {
            ((Condition)executableItem).getExecutableGroup().forEach((key, value) -> value.forEach(this::removeCurrLoopObject));
        } else if (executableItem instanceof Node) {
            ((Node)executableItem).removeCurrLoopObject();
        }
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    protected void handleFutureList(List<CompletableFuture<LoopFutureObj>> futureList) throws Exception {
        CompletableFuture<Void> resultCompletableFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
        resultCompletableFuture.get();
        for (CompletableFuture<LoopFutureObj> future : futureList) {
            LoopFutureObj loopFutureObj = future.get();
            if (loopFutureObj.isSuccess()) continue;
            throw loopFutureObj.getEx();
        }
    }

    public class LoopParallelSupplier
    implements Supplier<LoopFutureObj> {
        private final Executable executableItem;
        private final String currChainId;
        private final Integer slotIndex;
        private final Integer loopIndex;
        private final Object itObj;

        public LoopParallelSupplier(Executable executableItem, String currChainId, Integer slotIndex, Integer loopIndex) {
            this.executableItem = executableItem;
            this.currChainId = currChainId;
            this.slotIndex = slotIndex;
            this.loopIndex = loopIndex;
            this.itObj = null;
        }

        public LoopParallelSupplier(Executable executableItem, String currChainId, Integer slotIndex, Integer loopIndex, Object itObj) {
            this.executableItem = executableItem;
            this.currChainId = currChainId;
            this.slotIndex = slotIndex;
            this.loopIndex = loopIndex;
            this.itObj = itObj;
        }

        @Override
        public LoopFutureObj get() {
            LoopCondition.this.lock.lock();
            try {
                this.executableItem.setCurrChainId(this.currChainId);
                LoopCondition.this.setLoopIndex(this.executableItem, this.loopIndex);
                if (this.itObj != null) {
                    LoopCondition.this.setCurrLoopObject(this.executableItem, this.itObj);
                }
                this.executableItem.execute(this.slotIndex);
                LoopFutureObj loopFutureObj = LoopFutureObj.success(this.executableItem.getId());
                return loopFutureObj;
            }
            catch (Exception e) {
                LoopFutureObj loopFutureObj = LoopFutureObj.fail(this.executableItem.getId(), e);
                return loopFutureObj;
            }
            finally {
                LoopCondition.this.lock.unlock();
            }
        }
    }
}

