/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.log;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.yomahub.liteflow.log.LFLog;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LFLoggerManager {
    private static final Map<String, LFLog> logMap = new HashMap<String, LFLog>();
    private static final TransmittableThreadLocal<String> requestIdTL = new TransmittableThreadLocal();

    public static LFLog getLogger(Class<?> clazz) {
        if (logMap.containsKey(clazz.getName())) {
            return logMap.get(clazz.getName());
        }
        Logger log = LoggerFactory.getLogger((String)clazz.getName());
        LFLog lfLog = new LFLog(log);
        logMap.put(clazz.getName(), lfLog);
        return lfLog;
    }

    public static void setRequestId(String requestId) {
        requestIdTL.set((Object)requestId);
    }

    public static String getRequestId() {
        return (String)requestIdTL.get();
    }

    public static void removeRequestId() {
        requestIdTL.remove();
    }
}

