/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.pipeline.support;

import com.xxl.tool.core.CollectionTool;
import com.xxl.tool.core.MapTool;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.pipeline.Pipeline;
import com.xxl.tool.pipeline.PipelineExecutor;
import com.xxl.tool.pipeline.PipelineHandler;
import com.xxl.tool.pipeline.PipelineStatus;
import com.xxl.tool.pipeline.config.PipelineConfig;
import com.xxl.tool.pipeline.config.PipelineConfigLoader;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringPipelineExecutor
extends PipelineExecutor
implements ApplicationContextAware,
SmartInitializingSingleton,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SpringPipelineExecutor.class);
    private ApplicationContext applicationContext;
    private PipelineConfigLoader pipelineConfigLoader;

    public void setPipelineConfigLoader(PipelineConfigLoader pipelineConfigLoader) {
        this.pipelineConfigLoader = pipelineConfigLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        logger.info("SpringPipelineExecutor init.");
        this.init();
    }

    private boolean init() {
        if (this.applicationContext == null) {
            logger.info("SpringPipelineExecutor init fail. applicationContext is null.");
            return false;
        }
        if (this.pipelineConfigLoader == null) {
            logger.info("SpringPipelineExecutor init fail. pipelineConfigLoader is null.");
            return false;
        }
        List<PipelineConfig> configList = this.pipelineConfigLoader.loadAll();
        if (CollectionTool.isEmpty(configList)) {
            logger.info("SpringPipelineExecutor init fail. configList is null.");
            return false;
        }
        Map handlerMap = this.applicationContext.getBeansOfType(PipelineHandler.class);
        if (MapTool.isEmpty(handlerMap)) {
            logger.info("SpringPipelineExecutor init fail. handlerMap is null.");
            return false;
        }
        for (PipelineConfig config : configList) {
            boolean ret = this.registryByConfig(config, handlerMap);
            logger.info("SpringPipelineExecutor registryByConfig [{}], config:{}", (Object)ret, (Object)config);
        }
        logger.info("SpringPipelineExecutor init success.");
        return true;
    }

    private boolean registryByConfig(PipelineConfig config, Map<String, PipelineHandler> handlerMap) {
        if (StringTool.isBlank(config.getName())) {
            logger.info("SpringPipelineExecutor registryByConfig[{}] fail. name is null.", (Object)config);
            return false;
        }
        if (CollectionTool.isEmpty(config.getHandlerList())) {
            logger.info("SpringPipelineExecutor registryByConfig[{}] fail. handlerList is null.");
        }
        Pipeline pipeline = new Pipeline().name(config.getName()).status(PipelineStatus.RUNTIME.getStatus());
        for (String handlerName : config.getHandlerList()) {
            PipelineHandler handler = handlerMap.get(handlerName);
            if (handler == null) {
                logger.info("SpringPipelineExecutor registryByConfig[{}] fail. handlerName[{}] not exists.", (Object)config, (Object)handlerName);
                return false;
            }
            pipeline.addLast(handler);
        }
        return this.registry(pipeline);
    }

    public void destroy() throws Exception {
        logger.info("SpringPipelineExecutor destroy.");
    }
}

