/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.io;

import com.xxl.tool.core.ArrayTool;
import com.xxl.tool.core.AssertTool;
import com.xxl.tool.io.IOTool;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class FileTool {
    private static final char CR = '\r';
    private static final char LF = '\n';

    public static File file(String path) {
        return new File(path);
    }

    public static File file(String parent, String child) {
        return new File(parent, child);
    }

    public static File createFile(String path) throws IOException {
        return FileTool.createFile(FileTool.file(path));
    }

    public static File createFile(String parent, String child) throws IOException {
        return FileTool.createFile(FileTool.file(parent, child));
    }

    public static File createFile(File file) throws IOException {
        if (file == null) {
            return null;
        }
        if (FileTool.exists(file)) {
            return file;
        }
        FileTool.createParentDirectories(file);
        try {
            Files.createFile(file.toPath(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            return file;
        }
        return file;
    }

    public static boolean createParentDirectories(File file) throws IOException {
        if (file == null) {
            return false;
        }
        File parentFile = file.getParentFile();
        return FileTool.createDirectories(parentFile);
    }

    public static boolean createDirectories(File dir) throws IOException {
        if (dir == null) {
            return false;
        }
        if (FileTool.exists(dir)) {
            if (FileTool.isDirectory(dir)) {
                return true;
            }
            throw new RuntimeException("file is not directory, path=" + dir.getPath());
        }
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        return true;
    }

    public static boolean isDirectory(String path) {
        return null != path && Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public static boolean isDirectory(File file) {
        return null != file && Files.isDirectory(file.toPath(), new LinkOption[0]);
    }

    public static boolean isFile(String path) {
        return null != path && FileTool.file(path).isFile();
    }

    public static boolean isFile(File file) {
        return null != file && file.isFile();
    }

    public static boolean isEmpty(File file) {
        if (!FileTool.exists(file)) {
            return true;
        }
        if (file.isDirectory()) {
            Object[] subFiles = file.list();
            return ArrayTool.isEmpty(subFiles);
        }
        if (file.isFile()) {
            return file.length() <= 0L;
        }
        return false;
    }

    public static boolean isNotEmpty(File file) {
        return !FileTool.isEmpty(file);
    }

    public static boolean isSameFile(File file1, File file2) throws IOException {
        if (file1 == null || file2 == null) {
            return false;
        }
        return Files.isSameFile(file1.toPath(), file2.toPath());
    }

    public static boolean isSub(Path parent, Path sub) {
        return FileTool.toAbsoluteNormal(sub).startsWith(FileTool.toAbsoluteNormal(parent));
    }

    public static boolean exists(String path) {
        return null != path && FileTool.exists(FileTool.file(path));
    }

    public static boolean exists(File file) {
        if (null == file) {
            return false;
        }
        return Files.exists(file.toPath(), new LinkOption[0]);
    }

    public static Path toAbsoluteNormal(Path path) {
        AssertTool.notNull(path, "path is null");
        return path.toAbsolutePath().normalize();
    }

    public static Path toAbsolutePath(Path path) {
        AssertTool.notNull(path, "path is null");
        return path.toAbsolutePath();
    }

    public static long size(String path) {
        return FileTool.size(FileTool.file(path), false);
    }

    public static long size(File file) {
        return FileTool.size(file, false);
    }

    public static long size(File file, boolean includeDirSize) {
        if (!FileTool.exists(file) || Files.isSymbolicLink(file.toPath())) {
            return 0L;
        }
        if (file.isDirectory()) {
            long size = includeDirSize ? file.length() : 0L;
            Object[] subFiles = file.listFiles();
            if (ArrayTool.isEmpty(subFiles)) {
                return 0L;
            }
            for (Object subFile : subFiles) {
                size += FileTool.size((File)subFile, includeDirSize);
            }
            return size;
        }
        return file.length();
    }

    public static int totalLines(String path) {
        return FileTool.totalLines(FileTool.file(path), 1024, true);
    }

    public static int totalLines(File file) {
        return FileTool.totalLines(file, 1024, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int totalLines(File file, int bufferSize, boolean lastLineSeparatorAsLine) {
        if (!FileTool.isFile(file)) {
            throw new RuntimeException("file invalid");
        }
        if (bufferSize < 1) {
            bufferSize = 1024;
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            byte[] buffer = new byte[bufferSize];
            int bytesRead = ((InputStream)is).read(buffer);
            if (bytesRead == -1) {
                int n = 0;
                return n;
            }
            int lineCount = 1;
            int previousChar = 0;
            int currentChar = 0;
            while (bytesRead != -1) {
                for (int i = 0; i < bytesRead; ++i) {
                    previousChar = currentChar;
                    currentChar = buffer[i];
                    if (currentChar != 10 && previousChar != 13) continue;
                    ++lineCount;
                }
                bytesRead = ((InputStream)is).read(buffer);
            }
            if (lastLineSeparatorAsLine) {
                if (currentChar == 13) {
                    ++lineCount;
                }
            } else if (currentChar == 10) {
                --lineCount;
            }
            int n = lineCount;
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean delete(String path) {
        return FileTool.delete(FileTool.file(path));
    }

    public static boolean delete(File file) {
        boolean cleanResult;
        if (!FileTool.exists(file)) {
            return true;
        }
        if (file.isDirectory() && !(cleanResult = FileTool.clean(file))) {
            return false;
        }
        Path path = file.toPath();
        try {
            Files.delete(path);
        }
        catch (AccessDeniedException e) {
            return file.delete();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public static boolean clean(String dirPath) {
        return FileTool.clean(FileTool.file(dirPath), false);
    }

    public static boolean clean(File directory) {
        return FileTool.clean(directory, false);
    }

    public static boolean clean(File directory, boolean skipDeleteFailFile) {
        if (!FileTool.exists(directory)) {
            return true;
        }
        if (!FileTool.isDirectory(directory)) {
            return false;
        }
        boolean result = true;
        Object[] files = directory.listFiles();
        if (ArrayTool.isNotEmpty(files)) {
            for (Object childFile : files) {
                boolean deleteResult = FileTool.delete((File)childFile);
                if (deleteResult) continue;
                result = false;
                if (skipDeleteFailFile) continue;
                return false;
            }
        }
        return result;
    }

    public static File copy(String src, String dest, boolean isOverride) throws IOException {
        AssertTool.notBlank(src, "source file path is blank");
        AssertTool.notBlank(dest, "destination file path is blank");
        return FileTool.copy(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), isOverride);
    }

    public static File copy(File src, File dest, boolean isOverride) throws IOException {
        AssertTool.notNull(src, "source file is null");
        AssertTool.notNull(dest, "destination file is null");
        return FileTool.copy(src.toPath(), dest.toPath(), isOverride);
    }

    public static File copy(Path src, Path dest, boolean isOverride) throws IOException {
        StandardCopyOption[] standardCopyOptionArray;
        AssertTool.notNull(src, "source file is null");
        AssertTool.notNull(dest, "destination file is null");
        if (isOverride) {
            StandardCopyOption[] standardCopyOptionArray2 = new StandardCopyOption[1];
            standardCopyOptionArray = standardCopyOptionArray2;
            standardCopyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            standardCopyOptionArray = new StandardCopyOption[]{};
        }
        StandardCopyOption[] copyOptions = standardCopyOptionArray;
        return FileTool.copy(src, dest, copyOptions);
    }

    public static File copy(Path src, Path dest, StandardCopyOption ... options) throws IOException {
        AssertTool.notNull(src, "source file path is null");
        AssertTool.notNull(dest, "destination file file is null");
        File srcFile = src.toFile();
        File destFile = dest.toFile();
        if (!FileTool.exists(srcFile)) {
            throw new RuntimeException("source file not exists");
        }
        if (!FileTool.isFile(srcFile)) {
            throw new RuntimeException("source only support file");
        }
        if (FileTool.toAbsoluteNormal(srcFile.toPath()).equals(FileTool.toAbsoluteNormal(destFile.toPath()))) {
            throw new RuntimeException("destination file can not be same as source file");
        }
        if (FileTool.isSub(src, dest)) {
            throw new RuntimeException("destination can not be sub of source");
        }
        Path finalDestFilePath = FileTool.isDirectory(destFile) ? dest.resolve(src.getFileName()) : dest;
        FileTool.createParentDirectories(destFile);
        return Files.copy(src, finalDestFilePath, (CopyOption[])options).toFile();
    }

    public static File move(String src, String dest, boolean isOverride) throws IOException {
        AssertTool.notBlank(src, "source file path is blank");
        AssertTool.notBlank(dest, "destination file path is blank");
        return FileTool.move(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), isOverride);
    }

    public static File move(File src, File dest, boolean isOverride) throws IOException {
        AssertTool.notNull(src, "source file is null");
        AssertTool.notNull(dest, "destination file is null");
        return FileTool.move(src.toPath(), dest.toPath(), isOverride);
    }

    public static File move(Path src, Path dest, boolean isOverride) throws IOException {
        StandardCopyOption[] standardCopyOptionArray;
        AssertTool.notNull(src, "source file is null");
        AssertTool.notNull(dest, "destination file is null");
        if (isOverride) {
            StandardCopyOption[] standardCopyOptionArray2 = new StandardCopyOption[1];
            standardCopyOptionArray = standardCopyOptionArray2;
            standardCopyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            standardCopyOptionArray = new StandardCopyOption[]{};
        }
        StandardCopyOption[] copyOptions = standardCopyOptionArray;
        return FileTool.move(src, dest, copyOptions);
    }

    public static File move(Path src, Path dest, StandardCopyOption ... options) throws IOException {
        AssertTool.notNull(src, "source file path is null");
        AssertTool.notNull(dest, "destination file file is null");
        File srcFile = src.toFile();
        File destFile = dest.toFile();
        if (!FileTool.exists(srcFile)) {
            throw new RuntimeException("source file not exists");
        }
        if (FileTool.toAbsoluteNormal(srcFile.toPath()).equals(FileTool.toAbsoluteNormal(destFile.toPath()))) {
            throw new RuntimeException("destination file can not be same as source file");
        }
        if (FileTool.isSub(src, dest)) {
            throw new RuntimeException("destination can not be sub of source");
        }
        Path finalDestFilePath = FileTool.isDirectory(destFile) ? dest.resolve(src.getFileName()) : dest;
        FileTool.createParentDirectories(destFile);
        return Files.move(src, finalDestFilePath, options).toFile();
    }

    public static File rename(File file, String newFileName, boolean isOverride) throws IOException {
        AssertTool.notNull(file, "file path is null");
        AssertTool.notBlank(newFileName, "newFileName is blank");
        return FileTool.move(file.toPath(), file.toPath().resolveSibling(newFileName), isOverride);
    }

    public static void writeString(String path, String content) throws IOException {
        FileTool.writeString(path, content, false, StandardCharsets.UTF_8);
    }

    public static void writeString(String path, String content, boolean append) throws IOException {
        FileTool.writeString(path, content, append, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(String path, String content, boolean append, Charset charset) throws IOException {
        AssertTool.notBlank(path, "file path is null");
        if (content == null) {
            return;
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        File file = FileTool.file(path);
        if (!FileTool.exists(path)) {
            FileTool.createFile(file);
        } else if (!FileTool.isFile(file)) {
            throw new RuntimeException("path(" + path + ") is not a file");
        }
        BufferedWriter writer = null;
        try {
            writer = IOTool.newBufferedWriter(file, append, charset, 8192);
            writer.write(content);
            writer.flush();
        }
        catch (Throwable throwable) {
            IOTool.close(writer);
            throw throwable;
        }
        IOTool.close(writer);
    }

    public static void writeLines(String path, Iterable<?> lines) throws IOException {
        FileTool.writeLines(path, lines, null, true, null);
    }

    public static void writeLines(String path, Iterable<?> lines, boolean append) throws IOException {
        FileTool.writeLines(path, lines, null, append, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(String path, Iterable<?> lines, String lineSeparator, boolean append, Charset charset) throws IOException {
        AssertTool.notBlank(path, "file path is null");
        if (lines == null || !lines.iterator().hasNext()) {
            return;
        }
        if (lineSeparator == null) {
            lineSeparator = System.lineSeparator();
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        File file = FileTool.file(path);
        if (!FileTool.exists(path)) {
            FileTool.createFile(file);
        } else if (!FileTool.isFile(file)) {
            throw new RuntimeException("path(" + path + ") is not a file");
        }
        BufferedWriter writer = null;
        try {
            writer = IOTool.newBufferedWriter(file, append, charset, 8192);
            for (Object line : lines) {
                if (line != null) {
                    writer.write(line.toString());
                }
                writer.write(lineSeparator);
            }
            writer.flush();
        }
        catch (Throwable throwable) {
            IOTool.close(writer);
            throw throwable;
        }
        IOTool.close(writer);
    }

    public static void writeLines(String path, Supplier<?> lineSupplier) throws IOException {
        FileTool.writeLines(path, lineSupplier, null, true, null);
    }

    public static void writeLines(String path, Supplier<?> lineSupplier, boolean append) throws IOException {
        FileTool.writeLines(path, lineSupplier, null, append, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(String path, Supplier<?> lineSupplier, String lineSeparator, boolean append, Charset charset) throws IOException {
        AssertTool.notBlank(path, "file path is null");
        AssertTool.notNull(lineSupplier, "supplier is null");
        if (lineSeparator == null) {
            lineSeparator = System.lineSeparator();
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        File file = FileTool.file(path);
        if (!FileTool.exists(path)) {
            FileTool.createFile(file);
        } else if (!FileTool.isFile(file)) {
            throw new RuntimeException("path(" + path + ") is not a file");
        }
        BufferedWriter writer = null;
        try {
            Object line;
            writer = IOTool.newBufferedWriter(file, append, charset, 8192);
            while ((line = lineSupplier.get()) != null) {
                writer.write(line.toString());
                writer.write(lineSeparator);
            }
            writer.flush();
        }
        catch (Throwable throwable) {
            IOTool.close(writer);
            throw throwable;
        }
        IOTool.close(writer);
    }

    public static String readString(String path) throws IOException {
        return FileTool.readString(path, StandardCharsets.UTF_8);
    }

    public static String readString(String path, Charset charset) throws IOException {
        AssertTool.notBlank(path, "file path is null");
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        return Files.readString(Paths.get(path, new String[0]), charset);
    }

    public static List<String> readLines(String path) throws IOException {
        return FileTool.readLines(path, StandardCharsets.UTF_8);
    }

    public static List<String> readLines(String path, Charset charset) throws IOException {
        AssertTool.notBlank(path, "file path is null");
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        return Files.readAllLines(Paths.get(path, new String[0]), charset);
    }

    public static void readLines(String path, Consumer<String> lineConsumer) throws IOException {
        FileTool.readLines(path, StandardCharsets.UTF_8, lineConsumer);
    }

    public static void readLines(String path, Charset charset, Consumer<String> lineConsumer) throws IOException {
        AssertTool.notBlank(path, "file path is null");
        AssertTool.notNull(lineConsumer, "lineConsumer is null");
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(path, new String[0]), charset);){
            String line;
            while ((line = reader.readLine()) != null) {
                lineConsumer.accept(line);
            }
        }
    }
}

