/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CsvTool {
    private static final char DEFAULT_SEPARATOR = ',';
    private static final char DEFAULT_QUOTE = '\"';

    private static String[] parseLine(String line, char separator, char quote) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder field = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == quote) {
                if (inQuotes) {
                    if (i + 1 < line.length() && line.charAt(i + 1) == quote) {
                        field.append(quote);
                        ++i;
                        continue;
                    }
                    inQuotes = false;
                    continue;
                }
                inQuotes = true;
                continue;
            }
            if (c == separator && !inQuotes) {
                result.add(field.toString());
                field.setLength(0);
                continue;
            }
            field.append(c);
        }
        result.add(field.toString());
        return result.toArray(new String[0]);
    }

    private static String formatLine(String[] values, char separator, char quote) {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            boolean needQuotes;
            String value = values[i];
            boolean bl = needQuotes = value.contains(String.valueOf(separator)) || value.contains(String.valueOf(quote)) || value.contains("\n");
            if (needQuotes) {
                line.append(quote).append(value.replace(String.valueOf(quote), String.valueOf(quote) + quote)).append(quote);
            } else {
                line.append(value);
            }
            if (i >= values.length - 1) continue;
            line.append(separator);
        }
        return line.toString();
    }

    public static void writeCsv(String filePath, List<String[]> data) {
        CsvTool.writeCsv(filePath, data, ',', '\"');
    }

    public static void writeCsv(String filePath, List<String[]> data, char separator, char quote) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(filePath));){
            for (String[] row : data) {
                bw.write(CsvTool.formatLine(row, separator, quote));
                bw.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("CsvTool writeCsv error.", e);
        }
    }

    public static List<String[]> readCsv(String filePath) {
        return CsvTool.readCsv(filePath, ',', '\"');
    }

    public static List<String[]> readCsv(String filePath, char separator, char quote) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] values = CsvTool.parseLine(line, separator, quote);
                result.add(values);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("CsvTool readCsv error.", e);
        }
        return result;
    }
}

