/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.excel;

import com.xxl.tool.core.StringTool;
import com.xxl.tool.excel.annotation.ExcelField;
import com.xxl.tool.excel.annotation.ExcelSheet;
import com.xxl.tool.excel.util.FieldReflectionUtil;
import com.xxl.tool.io.FileTool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelTool {
    private static final Logger logger = LoggerFactory.getLogger(ExcelTool.class);
    private static final DataFormatter FORMATTER = new DataFormatter();

    private static Workbook createWorkbook(List<?> ... sheetDataList) {
        if (sheetDataList == null || sheetDataList.length == 0) {
            throw new RuntimeException("ExcelTool createWorkbook error, sheetData can not be empty.");
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        for (List<?> sheetData : sheetDataList) {
            ExcelTool.createSheet((Workbook)workbook, sheetData);
        }
        return workbook;
    }

    private static void createSheet(Workbook workbook, List<?> sheetData) {
        if (sheetData == null || sheetData.isEmpty()) {
            return;
        }
        Class<?> sheetClass = sheetData.get(0).getClass();
        ExcelSheet excelSheetAnno = sheetClass.getAnnotation(ExcelSheet.class);
        String sheetName = sheetClass.getSimpleName();
        short headColorIndex = -1;
        if (excelSheetAnno != null) {
            if (excelSheetAnno.name() != null && !excelSheetAnno.name().trim().isEmpty()) {
                sheetName = excelSheetAnno.name().trim();
            }
            headColorIndex = excelSheetAnno.headColor().getIndex();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : sheetClass.getDeclaredFields()) {
            ExcelField excelFieldAnno;
            if (Modifier.isStatic(field.getModifiers()) || (excelFieldAnno = field.getAnnotation(ExcelField.class)) != null && excelFieldAnno.ignore()) continue;
            fields.add(field);
        }
        if (fields.isEmpty()) {
            throw new RuntimeException("ExcelTool createSheet error, sheetClass fields can not be empty.");
        }
        Sheet existSheet = workbook.getSheet(sheetName);
        if (existSheet != null) {
            for (int i = 2; i <= 1000; ++i) {
                String newSheetName = sheetName.concat(String.valueOf(i));
                existSheet = workbook.getSheet(newSheetName);
                if (existSheet != null) continue;
                sheetName = newSheetName;
                break;
            }
        }
        Sheet sheet = workbook.createSheet(sheetName);
        CellStyle[] fieldDataStyleArr = new CellStyle[fields.size()];
        int[] fieldWidthArr = new int[fields.size()];
        Row headRow = sheet.createRow(0);
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            ExcelField excelFieldAnno = field.getAnnotation(ExcelField.class);
            String fieldName = field.getName();
            int fieldWidth = 0;
            HorizontalAlignment align = null;
            if (excelFieldAnno != null) {
                if (excelFieldAnno.name() != null && !excelFieldAnno.name().trim().isEmpty()) {
                    fieldName = excelFieldAnno.name().trim();
                }
                fieldWidth = excelFieldAnno.width();
                align = excelFieldAnno.align();
            }
            fieldWidthArr[i] = fieldWidth;
            CellStyle fieldDataStyle = workbook.createCellStyle();
            if (align != null) {
                fieldDataStyle.setAlignment(align);
            }
            fieldDataStyleArr[i] = fieldDataStyle;
            CellStyle headStyle = workbook.createCellStyle();
            headStyle.cloneStyleFrom(fieldDataStyle);
            if (headColorIndex > -1) {
                headStyle.setFillForegroundColor(headColorIndex);
                headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            Cell cellX = headRow.createCell(i, CellType.STRING);
            cellX.setCellStyle(headStyle);
            cellX.setCellValue(fieldName);
        }
        ExcelTool.writeRowData(sheet, fields, fieldDataStyleArr, sheetData);
        ExcelTool.writeColumnWidth(sheet, fields, fieldWidthArr);
    }

    private static void writeRowData(Sheet sheet, List<Field> fields, CellStyle[] fieldDataStyleArr, List<?> sheetData) {
        for (int dataIndex = 0; dataIndex < sheetData.size(); ++dataIndex) {
            Object rowData = sheetData.get(dataIndex);
            Row rowX = sheet.createRow(dataIndex + 1);
            for (int i = 0; i < fields.size(); ++i) {
                try {
                    Field field = fields.get(i);
                    field.setAccessible(true);
                    Object fieldValue = field.get(rowData);
                    String fieldValueString = FieldReflectionUtil.formatValue(field, fieldValue);
                    Cell cellX = rowX.createCell(i, CellType.STRING);
                    cellX.setCellStyle(fieldDataStyleArr[i]);
                    cellX.setCellValue(fieldValueString);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("ExcelTool createSheet error, write row-data error.", e);
                }
            }
        }
    }

    private static void writeColumnWidth(Sheet sheet, List<Field> fields, int[] fieldWidthArr) {
        for (int i = 0; i < fields.size(); ++i) {
            int fieldWidth = fieldWidthArr[i];
            if (fieldWidth > 0) {
                sheet.setColumnWidth(i, fieldWidth);
                continue;
            }
            sheet.autoSizeColumn((int)((short)i));
        }
    }

    private static List<Object> readSheet(Workbook workbook, Class<?> sheetClass) {
        try {
            ExcelSheet excelSheet = sheetClass.getAnnotation(ExcelSheet.class);
            String sheetName = excelSheet != null && excelSheet.name() != null && !excelSheet.name().trim().isEmpty() ? excelSheet.name().trim() : sheetClass.getSimpleName();
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Field field : sheetClass.getDeclaredFields()) {
                ExcelField excelFieldAnno;
                if (Modifier.isStatic(field.getModifiers()) || (excelFieldAnno = field.getAnnotation(ExcelField.class)) != null && excelFieldAnno.ignore()) continue;
                fields.add(field);
            }
            if (fields.isEmpty()) {
                throw new RuntimeException("ExcelTool readSheet error, sheetClass[" + sheetClass.getName() + "] fields can not be empty.");
            }
            Sheet sheet = workbook.getSheet(sheetName);
            if (sheet == null) {
                return null;
            }
            Row headRow = sheet.getRow(0);
            if (headRow == null) {
                return null;
            }
            HashMap<Integer, String> cellIndex2fieldName = new HashMap<Integer, String>();
            for (int i = 0; i < headRow.getLastCellNum(); ++i) {
                Cell cell = headRow.getCell(i);
                if (cell == null) continue;
                String cellValueStr = FORMATTER.formatCellValue(cell);
                cellIndex2fieldName.put(i, cellValueStr);
            }
            HashMap<String, Field> fieldMame2FieldMap = new HashMap<String, Field>();
            for (Field field : fields) {
                String fieldName = field.getName();
                ExcelField excelFieldAnno = field.getAnnotation(ExcelField.class);
                if (excelFieldAnno != null && excelFieldAnno.name() != null && !excelFieldAnno.name().trim().isEmpty()) {
                    fieldName = excelFieldAnno.name().trim();
                }
                fieldMame2FieldMap.put(fieldName, field);
            }
            ArrayList<Object> sheetData = new ArrayList<Object>();
            Iterator sheetIterator = sheet.rowIterator();
            int rowIndex = 0;
            while (sheetIterator.hasNext()) {
                Row rowX = (Row)sheetIterator.next();
                if (rowIndex > 0) {
                    Constructor<?> defaultConstructor = null;
                    for (Constructor<?> constructor : sheetClass.getDeclaredConstructors()) {
                        if (constructor.getParameterCount() != 0) continue;
                        defaultConstructor = constructor;
                        break;
                    }
                    if (defaultConstructor == null) {
                        throw new RuntimeException("ExcelTool readSheet error, sheetClass[" + sheetClass.getName() + "] does not have default constructor.");
                    }
                    Object rowObj = sheetClass.newInstance();
                    for (int i = 0; i < headRow.getLastCellNum(); ++i) {
                        String cellValueStr;
                        Object cellValue;
                        Cell cell = rowX.getCell(i);
                        if (cell == null) continue;
                        Field field = null;
                        if (cellIndex2fieldName.containsKey(i)) {
                            field = (Field)fieldMame2FieldMap.get(cellIndex2fieldName.get(i));
                        }
                        if (field == null || (cellValue = FieldReflectionUtil.parseValue(field, cellValueStr = FORMATTER.formatCellValue(cell))) == null) continue;
                        field.setAccessible(true);
                        field.set(rowObj, cellValue);
                    }
                    sheetData.add(rowObj);
                }
                ++rowIndex;
            }
            return sheetData;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("ExcelTool readSheet error, " + e.getMessage(), e);
        }
    }

    public static void writeFile(String filePath, List<?> ... sheetDataList) {
        if (StringTool.isBlank(filePath)) {
            throw new RuntimeException("ExcelTool writeFile error, filePath is empty.");
        }
        String lowerPath = filePath.toLowerCase();
        if (lowerPath.endsWith(".xls")) {
            throw new RuntimeException("ExcelTool not support Excel 2003 (.xls): " + filePath);
        }
        if (FileTool.exists(filePath)) {
            throw new RuntimeException("ExcelTool writeFile error, filePath: " + filePath + " already exists.");
        }
        try {
            FileTool.createParentDirectories(FileTool.file(filePath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (Workbook workbook = ExcelTool.createWorkbook(sheetDataList);
             FileOutputStream fileOutputStream = new FileOutputStream(filePath);){
            workbook.write((OutputStream)fileOutputStream);
            fileOutputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("ExcelTool writeFile error, filePath: " + filePath, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] writeByteArray(List<?> ... sheetDataList) {
        if (sheetDataList == null || sheetDataList.length == 0) {
            throw new RuntimeException("ExcelTool writeByteArray error, sheetDataList is empty.");
        }
        try (Workbook workbook = ExcelTool.createWorkbook(sheetDataList);){
            byte[] byArray;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                workbook.write((OutputStream)byteArrayOutputStream);
                byteArrayOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("ExcelTool writeByteArray error.", e);
        }
    }

    public static <T> List<T> readExcel(InputStream inputStream, Class<T> sheetClass) {
        List<Object> list;
        block8: {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            try {
                list = ExcelTool.readSheet(workbook, sheetClass);
                if (workbook == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | EncryptedDocumentException e) {
                    throw new RuntimeException("ExcelTool readExcel error, " + e.getMessage(), e);
                }
            }
            workbook.close();
        }
        return list;
    }

    public static <T> List<T> readExcel(File excelFile, Class<T> sheetClass) {
        if (excelFile == null || !excelFile.exists()) {
            throw new RuntimeException("ExcelTool readExcel error, excelFile is null or not exists.");
        }
        String lowerPath = excelFile.getPath().toLowerCase();
        if (lowerPath.endsWith(".xls")) {
            throw new RuntimeException("ExcelTool not support Excel 2003 (.xls): " + lowerPath);
        }
        try {
            return ExcelTool.readExcel(Files.newInputStream(excelFile.toPath(), new OpenOption[0]), sheetClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> readExcel(String filePath, Class<T> sheetClass) {
        return ExcelTool.readExcel(new File(filePath), sheetClass);
    }
}

