/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.concurrent;

import com.xxl.tool.core.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageQueue<T> {
    private static Logger logger = LoggerFactory.getLogger(MessageQueue.class);
    private final String name;
    private final LinkedBlockingQueue<T> messageQueue;
    private final ExecutorService consumerExecutor;
    private volatile boolean isRunning = true;

    public MessageQueue(String name, MessageConsumer<T> consumer) {
        this(name, Integer.MAX_VALUE, consumer, 3, 1);
    }

    public MessageQueue(String name, MessageConsumer<T> consumer, int consumeBatchSize) {
        this(name, Integer.MAX_VALUE, consumer, 3, consumeBatchSize);
    }

    public MessageQueue(String name, MessageConsumer<T> consumer, int consumerCount, int consumeBatchSize) {
        this(name, Integer.MAX_VALUE, consumer, consumerCount, consumeBatchSize);
    }

    public MessageQueue(String name, int queueLength, MessageConsumer<T> consumer, int consumerCount, int consumeBatchSize) {
        if (StringTool.isBlank(name)) {
            throw new IllegalArgumentException("name is null");
        }
        if (queueLength < 1) {
            throw new IllegalArgumentException("queueLength is invalid.");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("consumer is null.");
        }
        if (consumerCount < 1) {
            throw new IllegalArgumentException("consumerCount is invalid.");
        }
        if (consumeBatchSize < 1) {
            throw new IllegalArgumentException("consumeBatchSize is invalid.");
        }
        this.name = name;
        this.messageQueue = new LinkedBlockingQueue(queueLength);
        this.consumerExecutor = Executors.newFixedThreadPool(consumerCount);
        this.isRunning = true;
        for (int i = 0; i < consumerCount; ++i) {
            this.consumerExecutor.submit(() -> {
                logger.debug(">>>>>>>>>>> ProducerConsumerQueue[name = " + name + "] consumer thead[" + Thread.currentThread().getName() + "] start.");
                while (this.isRunning || !this.messageQueue.isEmpty()) {
                    try {
                        T message = this.messageQueue.poll(3000L, TimeUnit.MILLISECONDS);
                        if (message == null) continue;
                        ArrayList<T> messageList = new ArrayList<T>();
                        messageList.add(message);
                        if (consumeBatchSize > 1) {
                            this.messageQueue.drainTo(messageList, consumeBatchSize - 1);
                        }
                        consumer.consume(messageList);
                    }
                    catch (Throwable e) {
                        if (this.isRunning) {
                            logger.error(">>>>>>>>>>> ProducerConsumerQueue[name = " + name + "] consumer thead[" + Thread.currentThread().getName() + "] run error:{}", (Object)e.getMessage(), (Object)e);
                        }
                        if (this.isRunning || !(e instanceof InterruptedException)) continue;
                        logger.error(">>>>>>>>>>> ProducerConsumerQueue[name = " + name + "] consumer thead[" + Thread.currentThread().getName() + "] stoped and interrupted, possible stop timeout.");
                    }
                }
            });
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop()));
        logger.info(">>>>>>>>>>> ProducerConsumerQueue[name = " + name + "] started, with conf\uff1aqueueLength = " + queueLength + ", consumerCount = " + consumerCount + ", consumeBatchSize = " + consumeBatchSize);
    }

    public boolean produce(T message) {
        if (message == null || !this.isRunning) {
            return false;
        }
        try {
            boolean result = this.messageQueue.offer(message, 20L, TimeUnit.MILLISECONDS);
            if (!result) {
                logger.warn(">>>>>>>>>>> ProducerConsumerQueue[name = " + this.name + "] produce fail for message: " + String.valueOf(message));
            }
            return result;
        }
        catch (InterruptedException e) {
            logger.warn(">>>>>>>>>>> ProducerConsumerQueue[name = " + this.name + "] produce error[" + String.valueOf(e) + "] for message: " + String.valueOf(message));
            return false;
        }
    }

    public void stop() {
        if (this.isRunning) {
            this.isRunning = false;
            this.consumerExecutor.shutdown();
            try {
                if (!this.consumerExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.consumerExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.consumerExecutor.shutdownNow();
                logger.error(">>>>>>>>>>> ProducerConsumerQueue[name = " + this.name + "] stop error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static interface MessageConsumer<T> {
        public void consume(List<T> var1);
    }
}

