/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Connection;
import java.sql.Timestamp;
import java.util.Date;

public class XTimeStamp
extends Timestamp {
    String timeString;
    private Date ts;
    private long t = 0L;
    int y;
    int m;
    int d;
    int h;
    int n;
    int se;
    int ms;
    int s;
    int mm;
    int nn;
    int rn_num;
    static final int[] MONTH_DAYS = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public XTimeStamp(long time) {
        super(time);
        this.seperateTime(time);
        this.ts = new Timestamp(this.t);
    }

    public XTimeStamp(Timestamp timestamp) {
        super(timestamp.getYear(), timestamp.getMonth(), timestamp.getDay(), timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos());
        this.y = timestamp.getYear();
        this.m = timestamp.getMonth();
        this.d = timestamp.getDay();
        this.h = timestamp.getHours();
        this.n = timestamp.getMinutes();
        this.se = timestamp.getSeconds();
        this.ms = timestamp.getNanos();
        this.ts = timestamp;
    }

    public XTimeStamp(int year, int month, int date, int hour, int minute, int second, int nano) {
        super(year, month, date, hour, minute, second, nano);
        this.y = year;
        this.m = month;
        this.d = date;
        this.h = hour;
        this.n = minute;
        this.se = second;
        this.ms = nano;
        this.ts = new Timestamp(this.y - 1900, this.m - 1, this.d, this.h, this.n, this.se, this.ms);
    }

    @Override
    public String toString() {
        return this.ts.toString();
    }

    public static Timestamp valueOf(String s) {
        int[] dd = new int[3];
        int[] hh = new int[4];
        int i = 0;
        int dj = 0;
        int hj = 0;
        try {
            while ((i = s.indexOf("-")) != -1) {
                dd[dj] = Integer.parseInt(s.substring(0, i).trim());
                s = s.substring(i + 1);
                ++dj;
            }
            i = s.indexOf(" ");
            if (i != -1) {
                if (dj != 0) {
                    dd[dj] = Integer.parseInt(s.substring(0, i).trim());
                    s = s.substring(i + 1);
                }
                while ((i = s.indexOf(":")) != -1) {
                    hh[hj] = Integer.parseInt(s.substring(0, i).trim());
                    s = s.substring(i + 1);
                    ++hj;
                }
                if (hj != 0) {
                    i = s.indexOf(".");
                    if (i != -1) {
                        hh[hj] = Integer.parseInt(s.substring(0, i).trim());
                        s = s.substring(i + 1);
                    }
                    hh[hj] = Integer.parseInt(s.trim());
                }
            } else if (dj != 0) {
                dd[dj] = Integer.parseInt(s.trim());
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u5b57\u4e32\u4e0d\u662f JDBC \u65e5\u671f\u8f6c\u4e49\u5f62\u5f0f");
        }
        if (dj != 2 || hj < 2) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u5b57\u4e32\u4e0d\u662f JDBC \u65e5\u671f\u8f6c\u4e49\u5f62\u5f0f");
        }
        return new Timestamp(dd[0] - 1900, dd[1] - 1, dd[2], hh[0], hh[1], hh[2], hh[3]);
    }

    @Override
    public boolean after(Timestamp tts) {
        return this.ts.after(tts);
    }

    @Override
    public boolean before(Timestamp tts) {
        return this.ts.before(tts);
    }

    @Override
    public int compareTo(Date d) {
        return this.ts.compareTo(d);
    }

    @Override
    public int compareTo(Timestamp timeStamp) {
        return this.ts.compareTo(timeStamp);
    }

    @Override
    public boolean equals(Object obj) {
        return this.ts.equals(obj);
    }

    @Override
    public boolean equals(Timestamp timeStamp) {
        return this.ts.equals(timeStamp);
    }

    @Override
    public int getNanos() {
        return this.ms;
    }

    @Override
    public long getTime() {
        return this.ts.getTime();
    }

    @Override
    public void setNanos(int n) {
        if (this.t != 0L) {
            this.t = this.t - (long)this.ms + (long)n;
            this.ms = n;
            this.ts = new Timestamp(this.t);
        } else {
            this.ms = n;
            this.ts = new Timestamp(this.y - 1900, this.m - 1, this.d, this.h, n, this.se, this.ms);
        }
    }

    @Override
    public void setTime(long time) {
        this.seperateTime(time);
        this.ts = new Timestamp(this.t);
    }

    private boolean isRn(int y) {
        boolean f = y % 400 == 0 || y % 4 == 0 && y % 100 != 0;
        return f;
    }

    private void seperateTime(long time) {
        this.t = time;
        if (this.t >= 0L) {
            this.ms = (int)(this.t % 1000L);
            this.t /= 1000L;
            this.s = (int)(this.t % 86400L);
            this.d = (int)(this.t / 86400L);
            this.mm = this.d / 146097;
            this.nn = this.d % 146097;
            this.y = 1970 + 400 * this.mm;
            this.mm = this.nn / 36524;
            this.nn %= 36524;
            this.y += 100 * this.mm;
            this.mm = this.nn / 1461;
            this.nn %= 1461;
            this.y += 4 * this.mm;
            if (this.nn > 1096) {
                this.y += 3;
            }
            if (this.nn > 730 && this.nn <= 1096) {
                this.y += 2;
            }
            if (this.nn > 365 && this.nn <= 730) {
                ++this.y;
            }
            if (this.nn == 0) {
                --this.y;
            }
            this.rn_num = (this.y - 1) / 4 - (this.y - 1) / 100 + (this.y - 1) / 400;
            this.rn_num -= 477;
            this.d = this.d - 365 * (this.y - 1970) - this.rn_num;
        } else {
            this.ms = (int)(this.t % 1000L);
            this.t /= 1000L;
            if (this.ms != 0) {
                this.ms += 1000;
                --this.t;
            }
            this.s = (int)(this.t % 86400L);
            this.d = (int)(this.t / 86400L);
            if (this.s != 0) {
                this.s += 86400;
                --this.d;
            }
            this.mm = this.d / 146097;
            this.nn = this.d % 146097;
            this.y = 1969 + 400 * this.mm;
            this.mm = this.nn / 36524;
            this.nn %= 36524;
            this.y += 100 * this.mm;
            this.mm = this.nn / 1461;
            this.nn %= 1461;
            this.y += 4 * this.mm;
            if (this.nn < -1096) {
                this.y -= 3;
            }
            if (this.nn < -731 && this.nn >= -1096) {
                this.y -= 2;
            }
            if (this.nn < -365 && this.nn >= -731) {
                --this.y;
            }
            if (this.nn == 0) {
                ++this.y;
            }
            this.rn_num = (this.y + 1) / 4 - (this.y + 1) / 100 + (this.y + 1) / 400;
            this.rn_num -= 477;
            this.d = this.d - 365 * (this.y + 1 - 1970) - this.rn_num;
            this.d += this.isRn(this.y) ? 366 : 365;
        }
        if (this.d < 0) {
            --this.y;
            this.d += this.isRn(this.y) ? 366 : 365;
        }
        ++this.d;
        if (this.isRn(this.y)) {
            if (this.d > 366) {
                this.d -= 366;
                ++this.y;
            }
        } else if (this.d > 365) {
            this.d -= 365;
            ++this.y;
        }
        if (this.isRn(this.y)) {
            this.m = 0;
            while (this.m <= 11) {
                if (this.d > Connection.MTOD[1][this.m] && this.d <= Connection.MTOD[1][this.m + 1]) {
                    this.d -= Connection.MTOD[1][this.m];
                    ++this.m;
                    break;
                }
                ++this.m;
            }
        } else {
            this.m = 0;
            while (this.m <= 11) {
                if (this.d > Connection.MTOD[0][this.m] && this.d <= Connection.MTOD[0][this.m + 1]) {
                    this.d -= Connection.MTOD[0][this.m];
                    ++this.m;
                    break;
                }
                ++this.m;
            }
        }
        this.h = this.s / 3600;
        this.s %= 3600;
        this.n = this.s / 60;
        this.se = this.s % 60;
    }

    int getDates() {
        return this.d;
    }

    int getMonthes() {
        return this.m;
    }

    int getYears() {
        return this.y;
    }

    int getHour() {
        return this.h;
    }

    int getMinute() {
        return this.n;
    }

    int getSecond() {
        return this.se;
    }

    void setHour(int hour) {
        this.h = hour;
    }

    void setMinute(int minute) {
        this.n = minute;
    }

    void setSecond(int second) {
        this.se = second;
    }

    void setDate(long date) {
        this.t = date;
        this.seperateTime(this.t);
    }
}

