/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config.springsupport;

import com.weibo.api.motan.config.BasicRefererInterfaceConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RefererConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.config.springsupport.MotanNamespaceHandler;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;

public class RefererConfigBean<T>
extends RefererConfig<T>
implements FactoryBean<T>,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    private static final long serialVersionUID = 8381310907161365567L;
    private transient BeanFactory beanFactory;

    public T getObject() throws Exception {
        return (T)this.getRef();
    }

    public Class<?> getObjectType() {
        return this.getInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        super.destroy();
    }

    public void afterPropertiesSet() throws Exception {
        this.checkAndConfigBasicConfig();
        this.checkAndConfigProtocols();
        this.checkAndConfigRegistry();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private void checkAndConfigBasicConfig() {
        if (this.getBasicReferer() == null) {
            if (MotanNamespaceHandler.basicRefererConfigDefineNames.size() == 0 && this.beanFactory instanceof ListableBeanFactory) {
                ListableBeanFactory listableBeanFactory = (ListableBeanFactory)this.beanFactory;
                String[] basicRefererConfigNames = listableBeanFactory.getBeanNamesForType(BasicRefererInterfaceConfig.class);
                MotanNamespaceHandler.basicRefererConfigDefineNames.addAll(Arrays.asList(basicRefererConfigNames));
            }
            for (String name : MotanNamespaceHandler.basicRefererConfigDefineNames) {
                BasicRefererInterfaceConfig biConfig = (BasicRefererInterfaceConfig)this.beanFactory.getBean(name, BasicRefererInterfaceConfig.class);
                if (biConfig == null) continue;
                if (MotanNamespaceHandler.basicRefererConfigDefineNames.size() == 1) {
                    this.setBasicReferer(biConfig);
                    continue;
                }
                if (biConfig.isDefault() == null || !biConfig.isDefault().booleanValue()) continue;
                this.setBasicReferer(biConfig);
            }
        }
    }

    private void checkAndConfigProtocols() {
        if (CollectionUtil.isEmpty((Collection)this.getProtocols()) && this.getBasicReferer() != null && !CollectionUtil.isEmpty((Collection)this.getBasicReferer().getProtocols())) {
            this.setProtocols(this.getBasicReferer().getProtocols());
        }
        if (CollectionUtil.isEmpty((Collection)this.getProtocols())) {
            for (String name : MotanNamespaceHandler.protocolDefineNames) {
                ProtocolConfig pc = (ProtocolConfig)this.beanFactory.getBean(name, ProtocolConfig.class);
                if (pc == null) continue;
                if (MotanNamespaceHandler.protocolDefineNames.size() == 1) {
                    this.setProtocol(pc);
                    continue;
                }
                if (pc.isDefault() == null || !pc.isDefault().booleanValue()) continue;
                this.setProtocol(pc);
            }
        }
        if (CollectionUtil.isEmpty((Collection)this.getProtocols())) {
            this.setProtocol(MotanFrameworkUtil.getDefaultProtocolConfig());
        }
    }

    public void checkAndConfigRegistry() {
        if (CollectionUtil.isEmpty((Collection)this.getRegistries()) && this.getBasicReferer() != null && !CollectionUtil.isEmpty((Collection)this.getBasicReferer().getRegistries())) {
            this.setRegistries(this.getBasicReferer().getRegistries());
        }
        if (CollectionUtil.isEmpty((Collection)this.getRegistries())) {
            for (String name : MotanNamespaceHandler.registryDefineNames) {
                RegistryConfig rc = (RegistryConfig)this.beanFactory.getBean(name, RegistryConfig.class);
                if (rc == null) continue;
                if (MotanNamespaceHandler.registryDefineNames.size() == 1) {
                    this.setRegistry(rc);
                    continue;
                }
                if (rc.isDefault() == null || !rc.isDefault().booleanValue()) continue;
                this.setRegistry(rc);
            }
        }
        if (CollectionUtil.isEmpty((Collection)this.getRegistries())) {
            this.setRegistry(MotanFrameworkUtil.getDefaultRegistryConfig());
        }
    }

    public void checkAndConfigExtInfo() {
    }
}

