/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.endpoint;

import com.volcengine.endpoint.EndpointResolver;
import com.volcengine.endpoint.ResolveEndpointOption;
import com.volcengine.endpoint.ResolvedEndpoint;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultEndpointProvider
implements EndpointResolver {
    public static final String REGION_CODE_CN_BEIJING_AUTODRIVING = "cn-beijing-autodriving";
    public static final String REGION_CODE_CN_SHANGHAI_AUTODRIVING = "cn-shanghai-autodriving";
    public static final String REGION_CODE_AP_SOUTH_EAST_2 = "ap-southeast-2";
    public static final String REGION_CODE_AP_SOUTH_EAST_3 = "ap-southeast-3";
    public static final String REGION_CODE_CN_HONGKONG = "cn-hongkong";
    public static final String REGION_CODE_CN_BEIJING_SELFDRIVE = "cn-beijing-selfdrive";
    private static final String SEPARATOR = ".";
    private static final String OPEN_PREFIX = "open";
    private static final String ENDPOINT_SUFFIX = ".volcengineapi.com";
    private static final String ENDPOINT = "open.volcengineapi.com";
    private static final String DUALSTACK_ENDPOINT_SUFFIX = ".volcengine-api.com";
    private static final Map<String, ServiceEndpointInfo> DEFAULT_ENDPOINT_MAP = new HashMap<String, ServiceEndpointInfo>();
    private static final Set<String> BOOTSTRAP_REGION = new HashSet<String>();

    private static RegionEndpointMap createRegionEndpointMap(String ... keyValuePairs) {
        RegionEndpointMap map = new RegionEndpointMap();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            String regionCode = keyValuePairs[i];
            String servicePrefix = keyValuePairs[i + 1];
            map.put(regionCode, servicePrefix + SEPARATOR + regionCode + ENDPOINT_SUFFIX);
        }
        return map;
    }

    private static String standardizeDomainServiceCode(String serviceCode) {
        return serviceCode.toLowerCase().replaceAll("_", "-");
    }

    private static String getDefaultEndpointByServiceInfo(String service, String regionCode, Set<String> customBootstrapRegion, Boolean useDualStack) {
        String regionEndpoint;
        String endpointSuffix;
        String resultEndpoint = ENDPOINT;
        ServiceEndpointInfo endpointInfo = DEFAULT_ENDPOINT_MAP.get(service);
        if (endpointInfo == null || !DefaultEndpointProvider.inBootstrapRegionList(regionCode, customBootstrapRegion)) {
            return resultEndpoint;
        }
        String string = endpointSuffix = DefaultEndpointProvider.hasEnabledDualstack(useDualStack) ? DUALSTACK_ENDPOINT_SUFFIX : ENDPOINT_SUFFIX;
        if (endpointInfo.isGlobal) {
            if (!endpointInfo.globalEndpoint.isEmpty()) {
                resultEndpoint = endpointInfo.globalEndpoint;
                return resultEndpoint;
            }
            resultEndpoint = DefaultEndpointProvider.standardizeDomainServiceCode(service) + endpointSuffix;
            return resultEndpoint;
        }
        if (endpointInfo.regionEndpointMap != null && (regionEndpoint = (String)endpointInfo.regionEndpointMap.get(regionCode)) != null) {
            resultEndpoint = regionEndpoint;
            return resultEndpoint;
        }
        resultEndpoint = DefaultEndpointProvider.standardizeDomainServiceCode(service) + SEPARATOR + regionCode + endpointSuffix;
        return resultEndpoint;
    }

    private static boolean inBootstrapRegionList(String region, Set<String> customBootstrapRegion) {
        String regionCode = region.trim();
        String bsRegionListPath = System.getenv("VOLC_BOOTSTRAP_REGION_LIST_CONF");
        if (bsRegionListPath != null && !bsRegionListPath.isEmpty()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(bsRegionListPath));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || !line.equals(regionCode)) continue;
                    reader.close();
                    return true;
                }
                reader.close();
            }
            catch (Exception e) {
                System.err.println("Error when reading " + bsRegionListPath + ": " + e.getMessage());
            }
        }
        if (BOOTSTRAP_REGION.contains(region)) {
            return true;
        }
        if (customBootstrapRegion != null) {
            return customBootstrapRegion.contains(region);
        }
        return false;
    }

    private static boolean hasEnabledDualstack(Boolean useDualStack) {
        if (useDualStack == null) {
            String enableDualstack = System.getenv("VOLC_ENABLE_DUALSTACK");
            return enableDualstack != null && enableDualstack.equals("true");
        }
        return useDualStack;
    }

    @Override
    public ResolvedEndpoint endpointFor(ResolveEndpointOption option) {
        String endpoint = DefaultEndpointProvider.getDefaultEndpointByServiceInfo(option.getService(), option.getRegion(), option.getCustomBootstrapRegion(), option.getUseDualStack());
        ResolvedEndpoint result = new ResolvedEndpoint();
        result.setEndpoint(endpoint);
        return result;
    }

    static {
        BOOTSTRAP_REGION.add(REGION_CODE_CN_BEIJING_AUTODRIVING);
        BOOTSTRAP_REGION.add(REGION_CODE_AP_SOUTH_EAST_2);
        BOOTSTRAP_REGION.add(REGION_CODE_AP_SOUTH_EAST_3);
        BOOTSTRAP_REGION.add(REGION_CODE_CN_SHANGHAI_AUTODRIVING);
        BOOTSTRAP_REGION.add(REGION_CODE_CN_BEIJING_SELFDRIVE);
        DEFAULT_ENDPOINT_MAP.put("advdefence", new ServiceEndpointInfo("advdefence", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("ark", new ServiceEndpointInfo("ark", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("billing", new ServiceEndpointInfo("billing", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("bio", new ServiceEndpointInfo("bio", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("cdn", new ServiceEndpointInfo("cdn", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("iam", new ServiceEndpointInfo("iam", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("vke", new ServiceEndpointInfo("vke", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("vmp", new ServiceEndpointInfo("vmp", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("volc_content_platform", new ServiceEndpointInfo("volc_content_platform", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("volc_observe", new ServiceEndpointInfo("volc_observe", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("Redis", new ServiceEndpointInfo("Redis", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("privatelink", new ServiceEndpointInfo("privatelink", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("rabbitmq", new ServiceEndpointInfo("rabbitmq", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("vpc", new ServiceEndpointInfo("vpc", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("RocketMQ", new ServiceEndpointInfo("RocketMQ", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("kafka", new ServiceEndpointInfo("kafka", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("rds_mysql", new ServiceEndpointInfo("rds_mysql", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("rds_mssql", new ServiceEndpointInfo("rds_mssql", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("rds_postgresql", new ServiceEndpointInfo("rds_postgresql", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("redis", new ServiceEndpointInfo("redis", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("rocketmq", new ServiceEndpointInfo("rocketmq", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("seccenter", new ServiceEndpointInfo("seccenter", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("spark", new ServiceEndpointInfo("spark", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("storage_ebs", new ServiceEndpointInfo("storage_ebs", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("clb", new ServiceEndpointInfo("clb", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("cloud_detect", new ServiceEndpointInfo("cloud_detect", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("cloud_trail", new ServiceEndpointInfo("cloud_trail", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("ecs", new ServiceEndpointInfo("ecs", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("edx", new ServiceEndpointInfo("edx", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("emr", new ServiceEndpointInfo("emr", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("escloud", new ServiceEndpointInfo("escloud", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("alb", new ServiceEndpointInfo("alb", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("filenas", new ServiceEndpointInfo("filenas", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("flink", new ServiceEndpointInfo("flink", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("fw_center", new ServiceEndpointInfo("fw_center", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("httpdns", new ServiceEndpointInfo("httpdns", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("configcenter", new ServiceEndpointInfo("configcenter", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("cen", new ServiceEndpointInfo("cen", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("certificate_service", new ServiceEndpointInfo("certificate_service", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("cr", new ServiceEndpointInfo("cr", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("cv", new ServiceEndpointInfo("cv", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("dataleap", new ServiceEndpointInfo("dataleap", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("dcdn", new ServiceEndpointInfo("dcdn", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("sts", new ServiceEndpointInfo("sts", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("tis", new ServiceEndpointInfo("tis", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("mongodb", new ServiceEndpointInfo("mongodb", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("transitrouter", new ServiceEndpointInfo("transitrouter", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("translate", new ServiceEndpointInfo("translate", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("vedbm", new ServiceEndpointInfo("vedbm", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("vefaas", new ServiceEndpointInfo("vefaas", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("vei_api", new ServiceEndpointInfo("vei_api", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("vepfs", new ServiceEndpointInfo("vepfs", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("Volc_Observe", new ServiceEndpointInfo("Volc_Observe", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("dms", new ServiceEndpointInfo("dms", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("dns", new ServiceEndpointInfo("dns", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("auto_scaling", new ServiceEndpointInfo("auto_scaling", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("directconnect", new ServiceEndpointInfo("directconnect", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("kms", new ServiceEndpointInfo("kms", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("mcdn", new ServiceEndpointInfo("mcdn", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("mcs", new ServiceEndpointInfo("mcs", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("ml_platform", new ServiceEndpointInfo("ml_platform", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("dbw", new ServiceEndpointInfo("dbw", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("dts", new ServiceEndpointInfo("dts", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("natgateway", new ServiceEndpointInfo("natgateway", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("nta", new ServiceEndpointInfo("nta", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("organization", new ServiceEndpointInfo("organization", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("tos", new ServiceEndpointInfo("tos", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("TLS", new ServiceEndpointInfo("TLS", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("vpn", new ServiceEndpointInfo("vpn", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("waf", new ServiceEndpointInfo("waf", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("quota", new ServiceEndpointInfo("quota", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("bmq", new ServiceEndpointInfo("bmq", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("acep", new ServiceEndpointInfo("acep", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("private_zone", new ServiceEndpointInfo("private_zone", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("sqs", new ServiceEndpointInfo("sqs", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
        DEFAULT_ENDPOINT_MAP.put("resourcecenter", new ServiceEndpointInfo("resourcecenter", true, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(new String[0])));
    }

    private static class ServiceEndpointInfo {
        private String service;
        private boolean isGlobal;
        private String globalEndpoint;
        private String defaultEndpoint;
        private RegionEndpointMap regionEndpointMap;

        public ServiceEndpointInfo(String service, boolean isGlobal, String globalEndpoint, String defaultEndpoint, RegionEndpointMap regionEndpointMap) {
            this.service = service;
            this.isGlobal = isGlobal;
            this.globalEndpoint = globalEndpoint;
            this.defaultEndpoint = defaultEndpoint;
            this.regionEndpointMap = regionEndpointMap;
        }
    }

    private static class RegionEndpointMap
    extends HashMap<String, String> {
        private RegionEndpointMap() {
        }
    }
}

