/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.volcengine.ark.model.DataForCreateModelCustomizationJobInput;
import com.volcengine.ark.model.HyperparameterForCreateModelCustomizationJobInput;
import com.volcengine.ark.model.ModelReferenceForCreateModelCustomizationJobInput;
import com.volcengine.ark.model.TagForCreateModelCustomizationJobInput;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class CreateModelCustomizationJobRequest {
    @SerializedName(value="CustomizationType")
    private CustomizationTypeEnum customizationType = null;
    @SerializedName(value="Data")
    private DataForCreateModelCustomizationJobInput data = null;
    @SerializedName(value="Description")
    private String description = null;
    @SerializedName(value="Hyperparameters")
    private List<HyperparameterForCreateModelCustomizationJobInput> hyperparameters = null;
    @SerializedName(value="ModelReference")
    private ModelReferenceForCreateModelCustomizationJobInput modelReference = null;
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="ProjectName")
    private String projectName = null;
    @SerializedName(value="SaveModelLimit")
    private Integer saveModelLimit = null;
    @SerializedName(value="Tags")
    private List<TagForCreateModelCustomizationJobInput> tags = null;

    public CreateModelCustomizationJobRequest customizationType(CustomizationTypeEnum customizationType) {
        this.customizationType = customizationType;
        return this;
    }

    @NotNull
    @Schema(required=true, description="")
    public CustomizationTypeEnum getCustomizationType() {
        return this.customizationType;
    }

    public void setCustomizationType(CustomizationTypeEnum customizationType) {
        this.customizationType = customizationType;
    }

    public CreateModelCustomizationJobRequest data(DataForCreateModelCustomizationJobInput data) {
        this.data = data;
        return this;
    }

    @Valid
    @Schema(description="")
    public DataForCreateModelCustomizationJobInput getData() {
        return this.data;
    }

    public void setData(DataForCreateModelCustomizationJobInput data) {
        this.data = data;
    }

    public CreateModelCustomizationJobRequest description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateModelCustomizationJobRequest hyperparameters(List<HyperparameterForCreateModelCustomizationJobInput> hyperparameters) {
        this.hyperparameters = hyperparameters;
        return this;
    }

    public CreateModelCustomizationJobRequest addHyperparametersItem(HyperparameterForCreateModelCustomizationJobInput hyperparametersItem) {
        if (this.hyperparameters == null) {
            this.hyperparameters = new ArrayList<HyperparameterForCreateModelCustomizationJobInput>();
        }
        this.hyperparameters.add(hyperparametersItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<HyperparameterForCreateModelCustomizationJobInput> getHyperparameters() {
        return this.hyperparameters;
    }

    public void setHyperparameters(List<HyperparameterForCreateModelCustomizationJobInput> hyperparameters) {
        this.hyperparameters = hyperparameters;
    }

    public CreateModelCustomizationJobRequest modelReference(ModelReferenceForCreateModelCustomizationJobInput modelReference) {
        this.modelReference = modelReference;
        return this;
    }

    @Valid
    @Schema(description="")
    public ModelReferenceForCreateModelCustomizationJobInput getModelReference() {
        return this.modelReference;
    }

    public void setModelReference(ModelReferenceForCreateModelCustomizationJobInput modelReference) {
        this.modelReference = modelReference;
    }

    public CreateModelCustomizationJobRequest name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(required=true, description="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateModelCustomizationJobRequest projectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @Schema(description="")
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public CreateModelCustomizationJobRequest saveModelLimit(Integer saveModelLimit) {
        this.saveModelLimit = saveModelLimit;
        return this;
    }

    @Min(value=1L)
    @Max(value=10L)
    @Schema(description="")
    public Integer getSaveModelLimit() {
        return this.saveModelLimit;
    }

    public void setSaveModelLimit(Integer saveModelLimit) {
        this.saveModelLimit = saveModelLimit;
    }

    public CreateModelCustomizationJobRequest tags(List<TagForCreateModelCustomizationJobInput> tags) {
        this.tags = tags;
        return this;
    }

    public CreateModelCustomizationJobRequest addTagsItem(TagForCreateModelCustomizationJobInput tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagForCreateModelCustomizationJobInput>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<TagForCreateModelCustomizationJobInput> getTags() {
        return this.tags;
    }

    public void setTags(List<TagForCreateModelCustomizationJobInput> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateModelCustomizationJobRequest createModelCustomizationJobRequest = (CreateModelCustomizationJobRequest)o;
        return Objects.equals((Object)this.customizationType, (Object)createModelCustomizationJobRequest.customizationType) && Objects.equals(this.data, createModelCustomizationJobRequest.data) && Objects.equals(this.description, createModelCustomizationJobRequest.description) && Objects.equals(this.hyperparameters, createModelCustomizationJobRequest.hyperparameters) && Objects.equals(this.modelReference, createModelCustomizationJobRequest.modelReference) && Objects.equals(this.name, createModelCustomizationJobRequest.name) && Objects.equals(this.projectName, createModelCustomizationJobRequest.projectName) && Objects.equals(this.saveModelLimit, createModelCustomizationJobRequest.saveModelLimit) && Objects.equals(this.tags, createModelCustomizationJobRequest.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customizationType, this.data, this.description, this.hyperparameters, this.modelReference, this.name, this.projectName, this.saveModelLimit, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateModelCustomizationJobRequest {\n");
        sb.append("    customizationType: ").append(this.toIndentedString((Object)this.customizationType)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    hyperparameters: ").append(this.toIndentedString(this.hyperparameters)).append("\n");
        sb.append("    modelReference: ").append(this.toIndentedString(this.modelReference)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    projectName: ").append(this.toIndentedString(this.projectName)).append("\n");
        sb.append("    saveModelLimit: ").append(this.toIndentedString(this.saveModelLimit)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CustomizationTypeEnum {
        FINETUNESFT("FinetuneSft"),
        FINETUNELORA("FinetuneLoRA"),
        PRETRAIN("Pretrain"),
        DPOLORA("DPOLoRA"),
        DPO("DPO");

        private String value;

        private CustomizationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CustomizationTypeEnum fromValue(String input) {
            for (CustomizationTypeEnum b : CustomizationTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CustomizationTypeEnum> {
            public void write(JsonWriter jsonWriter, CustomizationTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public CustomizationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CustomizationTypeEnum.fromValue(value);
            }
        }
    }
}

