/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.interceptor;

import com.volcengine.ark.runtime.exception.ArkAPIError;
import com.volcengine.ark.runtime.exception.ArkHttpException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang.RandomStringUtils;

public class RequestIdInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder requestBuilder = chain.request().newBuilder();
        if (chain.request().header("X-Client-Request-Id") == null || chain.request().header("X-Client-Request-Id").length() == 0) {
            requestBuilder = requestBuilder.header("X-Client-Request-Id", this.genRequestId());
        }
        requestBuilder.header("User-Agent", RequestIdInterceptor.getUserAgent());
        Request request = requestBuilder.build();
        try {
            return chain.proceed(request);
        }
        catch (Exception e) {
            String requestId = request.header("X-Client-Request-Id");
            ArkAPIError arkAPIError = new ArkAPIError(new ArkAPIError.ArkErrorDetails(e.getMessage(), "", "", ""));
            throw new ArkHttpException(arkAPIError, e, ArkHttpException.INTERNAL_SERVICE_CODE, requestId);
        }
    }

    private String genRequestId() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        return dateFormat.format(date) + RandomStringUtils.randomAlphanumeric((int)20);
    }

    private static String getUserAgent() {
        String format = "%s/%s/(%s;%s;%s)";
        String osInfo = System.getProperty("os.name") + "-" + System.getProperty("os.version");
        String jdkInfo = "java-" + System.getProperty("java.version");
        String arch = System.getProperty("os.arch");
        return String.format(format, "volcengine-java-sdk", "0.2.9", jdkInfo, osInfo, arch);
    }
}

