/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.helper;

import com.github.rholder.retry.Retryer;
import com.volcengine.helper.Utils;
import com.volcengine.helper.VodUploadAbstractStrategy;
import com.volcengine.helper.VodUploadProgressEventType;
import com.volcengine.helper.VodUploadProgressListener;
import com.volcengine.helper.VodUploadProgressListenerHelper;
import com.volcengine.model.beans.PartInputStream;
import com.volcengine.service.vod.UploadException;
import com.volcengine.service.vod.impl.VodServiceImpl;
import com.volcengine.service.vod.model.business.VodHeaderPair;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class VodUploadByStream
extends VodUploadAbstractStrategy {
    private final long chunkSize;

    public VodUploadByStream(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    public VodUploadByStream() {
        this.chunkSize = 0x1400000L;
    }

    @Override
    public void directUpload(VodServiceImpl vodService, String host, String oid, String auth, List<VodHeaderPair> uploadHeaderList, File file, Retryer retryer, int storageClass, VodUploadProgressListener listener) throws Exception {
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("https://%s/%s", host, oidEncode);
        try (InputStream inputStream = Utils.newRepeatableInputStream(new FileInputStream(file));){
            inputStream.mark(0);
            long crc32 = Utils.crc32(inputStream);
            inputStream.reset();
            String checkSum = String.format("%08x", crc32);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.fillDirectUploadCommonHeaders(headers, uploadHeaderList, auth, checkSum, storageClass);
            boolean response = (Boolean)retryer.call(() -> vodService.putData(url, inputStream, (Map<String, String>)headers));
            VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, file.length() - 1L);
            if (!response) {
                throw new UploadException(-1, -1, "");
            }
        }
    }

    @Override
    public void chunkUpload(VodServiceImpl vodService, String host, String oid, String auth, List<VodHeaderPair> uploadHeaderList, File file, boolean isLargeFile, Retryer retryer, int storageClass, VodUploadProgressListener listener) throws Exception {
        long partNumber;
        String uploadID = vodService.initUploadPart(host, oid, auth, isLargeFile, uploadHeaderList, retryer, storageClass);
        ArrayList<String> parts = new ArrayList<String>();
        long num = file.length() / this.chunkSize;
        long lastNum = num - 1L;
        String objectContentType = "";
        for (long i = 0L; i < lastNum; ++i) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                ((InputStream)fileInputStream).skip(i * this.chunkSize);
                try (InputStream inputStream = Utils.newRepeatableInputStream(new PartInputStream(fileInputStream, this.chunkSize));){
                    partNumber = isLargeFile ? i + 1L : i;
                    VodServiceImpl.UploadPartResponse uploadPartResponse = this.uploadPart(vodService, host, oid, auth, uploadID, partNumber, inputStream, isLargeFile, retryer, storageClass);
                    parts.add(uploadPartResponse.getCheckSum());
                    if (partNumber == 1L) {
                        objectContentType = uploadPartResponse.getObjectContentType();
                    }
                    VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, this.chunkSize);
                    continue;
                }
            }
        }
        long readCount = this.chunkSize * lastNum;
        int len = (int)(file.length() - readCount);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ((InputStream)fileInputStream).skip(readCount);
            try (InputStream inputStream = Utils.newRepeatableInputStream(new PartInputStream(fileInputStream, len));){
                partNumber = isLargeFile ? lastNum + 1L : lastNum;
                VodServiceImpl.UploadPartResponse uploadPartResponse = this.uploadPart(vodService, host, oid, auth, uploadID, partNumber, inputStream, isLargeFile, retryer, storageClass);
                parts.add(uploadPartResponse.getCheckSum());
                if (partNumber == 1L) {
                    objectContentType = uploadPartResponse.getObjectContentType();
                }
                VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, len - 1);
            }
        }
        vodService.uploadMergePart(host, oid, auth, uploadID, (String[])parts.stream().toArray(String[]::new), isLargeFile, retryer, storageClass, objectContentType);
    }

    private VodServiceImpl.UploadPartResponse uploadPart(VodServiceImpl vodService, String host, String oid, String auth, String uploadID, long partNumber, InputStream inputStream, boolean isLargeFile, Retryer retryer, int storageClass) throws Exception {
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("https://%s/%s?partNumber=%d&uploadID=%s", host, oidEncode, partNumber, uploadID);
        HashMap<String, String> headers = new HashMap<String, String>();
        inputStream.mark(0);
        long crc32 = Utils.crc32(inputStream);
        inputStream.reset();
        String checkSum = String.format("%08x", crc32);
        this.fillPartUploadCommonHeaders(headers, auth, checkSum, isLargeFile, storageClass);
        HttpResponse httpResponse = (HttpResponse)retryer.call(() -> vodService.putDataWithResponse(url, inputStream, (Map<String, String>)headers));
        return this.getUploadPartResponse(isLargeFile, checkSum, httpResponse);
    }
}

