/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.contentSecurity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.model.request.SecuritySourceRequest;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.SecuritySourceResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.SignableRequest;
import com.volcengine.service.contentSecurity.SecuritySourceConfig;
import com.volcengine.service.contentSecurity.SecuritySourceException;
import com.volcengine.service.contentSecurity.SecuritySourceService;
import com.volcengine.service.contentSecurity.impl.SecuritySourceSseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class SecuritySourceServiceImpl
extends BaseServiceImpl
implements SecuritySourceService {
    private static final SecuritySourceServiceImpl securitySourceInstance = new SecuritySourceServiceImpl();

    private SecuritySourceServiceImpl() {
        super(SecuritySourceConfig.serviceInfo, SecuritySourceConfig.apiInfoList);
    }

    public static SecuritySourceService getInstance() {
        return securitySourceInstance;
    }

    @Override
    public SecuritySourceResponse getSecuritySource(SecuritySourceRequest securitySourceRequest) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getAccessKey()) || StringUtils.isBlank((CharSequence)this.getSecretKey())) {
            throw new Exception(" AccessKey or SecretKey Can not be empty");
        }
        RawResponse response = this.json("SecuritySource", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)securitySourceRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (SecuritySourceResponse)JSON.parseObject((byte[])response.getData(), SecuritySourceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public Stream<SecuritySourceResponse> getSecuritySourceStream(SecuritySourceRequest securitySourceRequest) throws SecuritySourceException {
        InputStream is;
        HttpResponse response;
        if (StringUtils.isBlank((CharSequence)this.getAccessKey()) || StringUtils.isBlank((CharSequence)this.getSecretKey())) {
            throw new SecuritySourceException(" AccessKey or SecretKey Can not be empty");
        }
        SignableRequest request = this.prepareRequest("SecuritySourceStream", new ArrayList<NameValuePair>());
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)securitySourceRequest), "utf-8"));
        try {
            this.ISigner.sign(request, this.credentials);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecuritySourceException("ISigner.sign has error :" + e.getMessage());
        }
        try {
            response = this.getHttpClient().execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new SecuritySourceException("Http Request execute has error : " + e.getMessage());
        }
        try {
            is = response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new SecuritySourceException(" open response stream has error : " + e.getMessage());
        }
        return SecuritySourceSseEvent.fromInputStream(is, StandardCharsets.UTF_8).map(event -> {
            SecuritySourceResponse resp;
            try {
                resp = (SecuritySourceResponse)JSON.parseObject((String)event.getData(), SecuritySourceResponse.class);
            }
            catch (Exception e) {
                this.closeInputStream(is);
                throw new RuntimeException(e);
            }
            return resp;
        });
    }

    private void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

