/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.guava30.com.google.common.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.shaded.guava30.com.google.common.annotations.Beta;
import org.apache.flink.shaded.guava30.com.google.common.annotations.GwtIncompatible;
import org.apache.flink.shaded.guava30.com.google.common.base.Preconditions;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.ExecutionError;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.TimeLimiter;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.flink.shaded.guava30.com.google.errorprone.annotations.CanIgnoreReturnValue;

@Beta
@CanIgnoreReturnValue
@GwtIncompatible
public final class FakeTimeLimiter
implements TimeLimiter {
    @Override
    public <T> T newProxy(T target, Class<T> interfaceType, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(timeoutUnit);
        return target;
    }

    @Override
    public <T> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            return callable.call();
        }
        catch (RuntimeException e2) {
            throw new UncheckedExecutionException(e2);
        }
        catch (Exception e3) {
            throw new ExecutionException(e3);
        }
        catch (Error e4) {
            throw new ExecutionError(e4);
        }
        catch (Throwable e5) {
            throw new ExecutionException(e5);
        }
    }

    @Override
    public <T> T callUninterruptiblyWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        return this.callWithTimeout(callable, timeoutDuration, timeoutUnit);
    }

    @Override
    public void runWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            runnable.run();
        }
        catch (RuntimeException e2) {
            throw new UncheckedExecutionException(e2);
        }
        catch (Error e3) {
            throw new ExecutionError(e3);
        }
        catch (Throwable e4) {
            throw new UncheckedExecutionException(e4);
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        this.runWithTimeout(runnable, timeoutDuration, timeoutUnit);
    }
}

