/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.guava30.com.google.common.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.flink.shaded.guava30.com.google.common.annotations.GwtIncompatible;
import org.apache.flink.shaded.guava30.com.google.common.math.ToDoubleRounder;

@GwtIncompatible
public class BigDecimalMath {
    private BigDecimalMath() {
    }

    public static double roundToDouble(BigDecimal x2, RoundingMode mode) {
        return BigDecimalToDoubleRounder.INSTANCE.roundToDouble(x2, mode);
    }

    private static class BigDecimalToDoubleRounder
    extends ToDoubleRounder<BigDecimal> {
        static final BigDecimalToDoubleRounder INSTANCE = new BigDecimalToDoubleRounder();

        private BigDecimalToDoubleRounder() {
        }

        @Override
        double roundToDoubleArbitrarily(BigDecimal bigDecimal) {
            return bigDecimal.doubleValue();
        }

        @Override
        int sign(BigDecimal bigDecimal) {
            return bigDecimal.signum();
        }

        @Override
        BigDecimal toX(double d2, RoundingMode mode) {
            return new BigDecimal(d2);
        }

        @Override
        BigDecimal minus(BigDecimal a2, BigDecimal b2) {
            return a2.subtract(b2);
        }
    }
}

