/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.guava30.com.google.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;
import org.apache.flink.shaded.guava30.com.google.common.annotations.Beta;
import org.apache.flink.shaded.guava30.com.google.common.annotations.GwtIncompatible;
import org.apache.flink.shaded.guava30.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.guava30.com.google.common.base.Preconditions;
import org.apache.flink.shaded.guava30.com.google.common.base.Throwables;
import org.apache.flink.shaded.guava30.com.google.common.io.Closeables;
import org.apache.flink.shaded.guava30.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
@GwtIncompatible
public final class Closer
implements Closeable {
    private static final Suppressor SUPPRESSOR = SuppressingSuppressor.isAvailable() ? SuppressingSuppressor.INSTANCE : LoggingSuppressor.INSTANCE;
    @VisibleForTesting
    final Suppressor suppressor;
    private final Deque<Closeable> stack = new ArrayDeque<Closeable>(4);
    private @Nullable Throwable thrown;

    public static Closer create() {
        return new Closer(SUPPRESSOR);
    }

    @VisibleForTesting
    Closer(Suppressor suppressor) {
        this.suppressor = Preconditions.checkNotNull(suppressor);
    }

    @CanIgnoreReturnValue
    public <C extends Closeable> C register(@Nullable C closeable) {
        if (closeable != null) {
            this.stack.addFirst(closeable);
        }
        return closeable;
    }

    public RuntimeException rethrow(Throwable e2) throws IOException {
        Preconditions.checkNotNull(e2);
        this.thrown = e2;
        Throwables.propagateIfPossible(e2, IOException.class);
        throw new RuntimeException(e2);
    }

    public <X extends Exception> RuntimeException rethrow(Throwable e2, Class<X> declaredType) throws IOException, X {
        Preconditions.checkNotNull(e2);
        this.thrown = e2;
        Throwables.propagateIfPossible(e2, IOException.class);
        Throwables.propagateIfPossible(e2, declaredType);
        throw new RuntimeException(e2);
    }

    public <X1 extends Exception, X2 extends Exception> RuntimeException rethrow(Throwable e2, Class<X1> declaredType1, Class<X2> declaredType2) throws IOException, X1, X2 {
        Preconditions.checkNotNull(e2);
        this.thrown = e2;
        Throwables.propagateIfPossible(e2, IOException.class);
        Throwables.propagateIfPossible(e2, declaredType1, declaredType2);
        throw new RuntimeException(e2);
    }

    @Override
    public void close() throws IOException {
        Throwable throwable = this.thrown;
        while (!this.stack.isEmpty()) {
            Closeable closeable = this.stack.removeFirst();
            try {
                closeable.close();
            }
            catch (Throwable e2) {
                if (throwable == null) {
                    throwable = e2;
                    continue;
                }
                this.suppressor.suppress(closeable, throwable, e2);
            }
        }
        if (this.thrown == null && throwable != null) {
            Throwables.propagateIfPossible(throwable, IOException.class);
            throw new AssertionError((Object)throwable);
        }
    }

    @VisibleForTesting
    static final class SuppressingSuppressor
    implements Suppressor {
        static final SuppressingSuppressor INSTANCE = new SuppressingSuppressor();
        static final Method addSuppressed = SuppressingSuppressor.addSuppressedMethodOrNull();

        SuppressingSuppressor() {
        }

        static boolean isAvailable() {
            return addSuppressed != null;
        }

        private static Method addSuppressedMethodOrNull() {
            try {
                return Throwable.class.getMethod("addSuppressed", Throwable.class);
            }
            catch (Throwable e2) {
                return null;
            }
        }

        @Override
        public void suppress(Closeable closeable, Throwable thrown, Throwable suppressed) {
            if (thrown == suppressed) {
                return;
            }
            try {
                addSuppressed.invoke((Object)thrown, suppressed);
            }
            catch (Throwable e2) {
                LoggingSuppressor.INSTANCE.suppress(closeable, thrown, suppressed);
            }
        }
    }

    @VisibleForTesting
    static final class LoggingSuppressor
    implements Suppressor {
        static final LoggingSuppressor INSTANCE = new LoggingSuppressor();

        LoggingSuppressor() {
        }

        @Override
        public void suppress(Closeable closeable, Throwable thrown, Throwable suppressed) {
            String string = String.valueOf(closeable);
            Closeables.logger.log(Level.WARNING, new StringBuilder(42 + String.valueOf(string).length()).append("Suppressing exception thrown when closing ").append(string).toString(), suppressed);
        }
    }

    @VisibleForTesting
    static interface Suppressor {
        public void suppress(Closeable var1, Throwable var2, Throwable var3);
    }
}

