/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.util.QxName;
import oracle.xml.xti.QNameKey;
import oracle.xml.xti.XTICompressor;
import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIContentManager;
import oracle.xml.xti.XTIDecoder;
import oracle.xml.xti.XTIDecompressor;
import oracle.xml.xti.XTIEncoder;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIUtil;

public class XTIStream
extends BinaryStream
implements XTIConstants {
    HashMap<QNameKey, byte[]> qnameHash = new HashMap(128);
    HashMap<Long, QxName> qnameCache = new HashMap(128);
    HashMap<Integer, byte[]> xtic = new HashMap();
    HashMap<Integer, byte[]> xtin = new HashMap();
    int[] xtinPages;
    int[] xticPages;
    int xtinPagesSize;
    int xticPagesSize;
    int maxPageId;
    boolean scratchMode;
    boolean twofilemode;
    static final int XTIN_STREAM = 0;
    static final int XTIC_STREAM = 1;
    XTIStream xtinstream;
    XTIStream xticstream;
    private int totalXTINPages = 0;
    private boolean isInterleaving = false;
    XTIEncoder encoder = null;
    XTIDecoder decoder = null;
    XTIContentManager xticm = null;
    XMLError err = new XMLError();
    private int xticmode = -1;
    private int zeroAvailByteStartPageNum = -1;
    private int zeroAvailByteEndPageNum = -1;
    int textsize = 0;
    private int freeBytesQname = 4091;
    private int freeBytesText = 4091;

    XTIStream() {
    }

    void initTwoFileMode4XTIN() {
        this.twofilemode = true;
        this.xtinPagesSize = 1024;
        this.xtinPages = new int[this.xtinPagesSize];
        this.resetBuffer();
        this.maxPageId = 0;
        this.readOnly = false;
    }

    void initTwoFileMode4XTIC() {
        this.twofilemode = true;
        this.xticPagesSize = 1024;
        this.xticPages = new int[this.xticPagesSize];
        this.resetBuffer();
        this.maxPageId = 0;
        this.readOnly = false;
    }

    void initScratchMode() {
        if (this.twofilemode) {
            this.err.error0(36003, 1);
            throw new XTIException(this.err.getMessage0(36003));
        }
        this.scratchMode = true;
        this.xtinPagesSize = 1024;
        this.xticPagesSize = 1024;
        this.xtinPages = new int[this.xtinPagesSize];
        this.xticPages = new int[this.xticPagesSize];
        this.resetBuffer();
        this.maxPageId = 0;
        this.readOnly = false;
    }

    @Override
    public void setFiles(File file, File file2) throws IOException {
        if (this.scratchMode && this.pagedio != null && this.pagedio instanceof BinaryStream.FilePagedIO || this.twofilemode && this.xtinstream != null && this.xticstream != null) {
            this.err.error0(36003, 1);
            throw new XTIException(this.err.getMessage0(36003));
        }
        this.scratchMode = false;
        this.twofilemode = true;
        this.setXTINFile(file);
        this.setXTICFile(file2);
    }

    private void setXTINFile(File file) throws IOException {
        this.xtinstream = new XTIStream();
        this.xtinstream.setFile(file);
        this.xtinstream.initTwoFileMode4XTIN();
    }

    private void setXTICFile(File file) throws IOException {
        this.xticstream = new XTIStream();
        this.xticstream.setFile(file);
        this.xticstream.initTwoFileMode4XTIC();
    }

    public XTIEncoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = new XTIEncoder(this);
        }
        this.readOnly = false;
        return this.encoder;
    }

    public XTIDecoder getDecoder() {
        if (this.decoder == null) {
            this.decoder = new XTIDecoder(this);
        }
        this.readOnly = true;
        return this.decoder;
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
    }

    @Override
    public XTIContentManager getContentManager() {
        if (this.xticm == null) {
            this.xticm = this.encoder != null ? this.encoder : new XTIContentManager(this);
        }
        return this.xticm;
    }

    void setZeroAvailByteStartPageNum(int n2) {
        this.zeroAvailByteStartPageNum = n2;
    }

    void setZeroAvailByteEndPageNum(int n2) {
        this.zeroAvailByteEndPageNum = n2;
    }

    void setFreeBytesQname(int n2) {
        this.freeBytesQname = n2;
    }

    void setFreeBytesText(int n2) {
        this.freeBytesText = n2;
    }

    private byte[] getXTINPageData(XTIStream xTIStream, int n2, boolean bl) {
        if (n2 >= xTIStream.xtinPagesSize) {
            int[] nArray = xTIStream.xtinPages;
            xTIStream.xtinPages = new int[xTIStream.xtinPagesSize + 1024];
            System.arraycopy(nArray, 0, xTIStream.xtinPages, 0, xTIStream.xtinPagesSize);
            xTIStream.xtinPagesSize += 1024;
        }
        int n3 = xTIStream.xtinPages[n2];
        if (n2 == 0) {
            if (xTIStream.maxPageId == 0) {
                xTIStream.maxPageId += 2;
            }
            return xTIStream.load(0, 8192, bl);
        }
        if (n3 == 0) {
            xTIStream.xtinPages[n2] = n3 = xTIStream.maxPageId;
            xTIStream.maxPageId += 2;
        }
        return xTIStream.load(n3, 8192, bl);
    }

    byte[] getXTINPageNumber(int n2, boolean bl) {
        if (this.scratchMode) {
            return this.getXTINPageData(this, n2, bl);
        }
        if (this.twofilemode) {
            return this.getXTINPageData(this.xtinstream, n2, bl);
        }
        byte[] byArray = this.xtin.get(n2);
        if (byArray == null) {
            byArray = new byte[8192];
            this.xtin.put(n2, byArray);
        }
        return byArray;
    }

    void setXTINPageNumber(int n2, byte[] byArray) {
        if (this.twofilemode) {
            int n3 = this.xtinstream.xtinPages[n2];
            this.xtinstream.unload(n3, true, byArray);
        }
    }

    void setXTICPageNumber(int n2, byte[] byArray) {
        if (this.twofilemode) {
            int n3 = this.xticstream.xticPages[n2];
            this.xticstream.unload(n3, true, byArray);
        }
    }

    private byte[] getXTICPageData(XTIStream xTIStream, int n2, boolean bl) {
        int n3;
        if (n2 >= xTIStream.xticPagesSize) {
            int[] nArray = xTIStream.xticPages;
            xTIStream.xticPages = new int[xTIStream.xticPagesSize + 1024];
            System.arraycopy(nArray, 0, xTIStream.xticPages, 0, xTIStream.xticPagesSize);
            xTIStream.xticPagesSize += 1024;
        }
        if ((n3 = xTIStream.xticPages[n2]) == 0) {
            xTIStream.xticPages[n2] = n3 = xTIStream.maxPageId++;
        }
        return xTIStream.load(n3, 4096, bl);
    }

    byte[] getXTICPageNumber(int n2, boolean bl) {
        if (this.scratchMode) {
            return this.getXTICPageData(this, n2, bl);
        }
        if (this.twofilemode) {
            return this.getXTICPageData(this.xticstream, n2, bl);
        }
        byte[] byArray = this.xtic.get(n2);
        if (byArray == null) {
            byArray = new byte[4096];
            this.xtic.put(n2, byArray);
        }
        return byArray;
    }

    void writeToXTINAddress(int n2, byte[] byArray, boolean bl) {
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        n4 = 32 * n4;
        byte[] byArray2 = this.getXTINPageNumber(n3, true);
        System.arraycopy(byArray, 0, byArray2, n4, byArray.length);
        byte by = byArray2[n4];
        if (bl) {
            byArray2[n4] = by = (byte)(by | 0x10);
        }
        this.setXTINPageNumber(n3, byArray2);
    }

    void writePIToAddress(int[] nArray, String string, String string2) throws Exception {
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = null;
        this.xticmode = 1;
        byte[] byArray2 = this.getUTF8Bytes(string);
        int n4 = byArray2.length;
        if (n4 <= XTIUtil.getXTICSizePerPage(this.xticmode)) {
            n2 = nArray[0] >> 12;
            n3 = nArray[0] & 0xFFF;
            byArray = this.getXTICPageNumber(n2, true);
            if (n3 == 5) {
                this.writeFirst5Bytes4XTICPages(byArray, this.freeBytesQname, n2, true);
            }
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            byArray[n4 + n3] = 0;
            this.setXTICPageNumber(n2, byArray);
        } else {
            this.writeMoreThanOnePage(nArray, byArray2, n4, n3, 0, 0);
        }
        byArray2 = this.getUTF8Bytes(string2);
        n4 = byArray2.length;
        if (n4 <= XTIUtil.getXTICSizePerPage(this.xticmode)) {
            n2 = nArray[1] >> 12;
            n3 = nArray[1] & 0xFFF;
            byArray = this.getXTICPageNumber(n2, true);
            if (n3 == 5) {
                this.writeFirst5Bytes4XTICPages(byArray, this.freeBytesQname, n2, true);
            }
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            byArray[n4 + n3] = 0;
            this.setXTICPageNumber(n2, byArray);
        } else {
            this.writeMoreThanOnePage(nArray, byArray2, n4, n3, 1, 0);
        }
    }

    private void writeMoreThanOnePage(int[] nArray, byte[] byArray, int n2, int n3, int n4, int n5) throws XTIException {
        int n6 = XTIUtil.getXTICSizePerPage(this.xticmode);
        int n7 = 4096;
        switch (this.xticmode) {
            case 1: {
                n7 = this.freeBytesQname;
                break;
            }
            case 0: 
            case 2: {
                n7 = this.freeBytesText;
            }
        }
        int n8 = nArray[n4] >> 12;
        n3 = nArray[n4] & 0xFFF;
        int n9 = (int)Math.round((double)(n2 / n6) + 0.5);
        byte[] byArray2 = this.getXTICPageNumber(n8, true);
        if (n3 == 5) {
            this.writeFirst5Bytes4XTICPages(byArray2, 0, n8, true);
        }
        boolean bl = false;
        if (n5 > 0) {
            byArray2[n3] = (byte)n5;
            System.arraycopy(byArray, 0, byArray2, n3 + 1, n6 - 1);
            bl = true;
        } else {
            System.arraycopy(byArray, 0, byArray2, n3, n6);
        }
        this.setXTICPageNumber(n8, byArray2);
        for (int i2 = 1; i2 < n9; ++i2) {
            byArray2 = this.getXTICPageNumber(++n8, true);
            if (i2 + 1 == n9) {
                int n10 = n2 - n6 * i2;
                if (bl) {
                    System.arraycopy(byArray, n6 * i2 - 1, byArray2, n3, n10 + 1);
                    this.writeFirst5Bytes4XTICPages(byArray2, n10 + 1, n8, false);
                } else {
                    System.arraycopy(byArray, n6 * i2, byArray2, n3, n10);
                    this.writeFirst5Bytes4XTICPages(byArray2, n10, n8, false);
                }
            } else {
                System.arraycopy(byArray, n6 * i2, byArray2, n3, n6);
                this.writeFirst5Bytes4XTICPages(byArray2, 0, n8, true);
            }
            this.setXTICPageNumber(n8, byArray2);
        }
    }

    void writeTextToAddress(int[] nArray, String string) throws XTIException {
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = null;
        this.xticmode = 2;
        byte[] byArray2 = this.getUTF8Bytes(string);
        int n4 = byArray2.length;
        if (n4 <= XTIUtil.getXTICSizePerPage(this.xticmode)) {
            n2 = nArray[0] >> 12;
            n3 = nArray[0] & 0xFFF;
            byArray = this.getXTICPageNumber(n2, true);
            if (n3 == 5) {
                this.writeFirst5Bytes4XTICPages(byArray, this.freeBytesText, n2, true);
            }
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            byArray[n4 + n3] = 0;
            this.setXTICPageNumber(n2, byArray);
        } else {
            this.writeMoreThanOnePage(nArray, byArray2, n4, n3, 0, 0);
        }
    }

    void writeQnameTOAddress(int[] nArray, String string, String string2, String string3) throws XTIException {
        byte[] byArray;
        int n2;
        int n3 = 0;
        this.xticmode = 1;
        byte[] byArray2 = this.getUTF8Bytes(string);
        int n4 = byArray2.length;
        if (n4 <= XTIUtil.getXTICSizePerPage(this.xticmode)) {
            n2 = nArray[0] >> 12;
            byArray = this.getXTICPageNumber(n2, true);
            n3 = nArray[0] & 0xFFF;
            System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
            if (n3 == 5) {
                this.writeFirst5Bytes4XTICPages(byArray, this.freeBytesQname, n2, true);
            }
            byArray[n3 + byArray2.length] = 0;
            this.setXTICPageNumber(n2, byArray);
        } else {
            this.writeMoreThanOnePage(nArray, byArray2, n4, n3, 0, 0);
        }
        int n5 = string2.length();
        if (n5 > 255) {
            String string4 = Integer.toString(n5);
            this.err.error1(36001, 1, string4);
            throw new XTIException(this.err.getMessage1(36001, string4));
        }
        String string5 = string2 + ":" + string3;
        byArray2 = this.getUTF8Bytes(string5);
        n4 = byArray2.length;
        if (n4 <= XTIUtil.getXTICSizePerPage(this.xticmode)) {
            n2 = nArray[1] >> 12;
            n3 = nArray[1] & 0xFFF;
            byArray = this.getXTICPageNumber(n2, true);
            byArray[n3] = (byte)(n5 + 1);
            System.arraycopy(byArray2, 0, byArray, n3 + 1, byArray2.length);
            byArray[byArray2.length + 1 + n3] = 0;
            this.setXTICPageNumber(n2, byArray);
        } else {
            this.writeMoreThanOnePage(nArray, byArray2, n4, n3, 1, n5 + 1);
        }
    }

    private byte[] writeFirst5Bytes4XTICPages(byte[] byArray, int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = 4091;
        switch (this.xticmode) {
            case 1: {
                n4 = 1;
                break;
            }
            case 2: {
                n4 = 2;
                break;
            }
            case 0: {
                n4 = 2;
                n5 = 4089;
            }
        }
        if (n3 >= this.zeroAvailByteStartPageNum && n3 <= this.zeroAvailByteEndPageNum) {
            n2 = 0;
            bl = true;
        }
        int n6 = bl ? n2 : n5 - n2;
        byte[] byArray2 = XTIUtil.intToByteArray(n5 - n6);
        for (int i2 = 0; i2 < 4; ++i2) {
            byArray[i2] = byArray2[i2];
        }
        byArray[4] = n4;
        return byArray;
    }

    private byte[] getUTF8Bytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
            this.xticmode = 0;
        }
        return byArray;
    }

    void flushInterleavingToStream() throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[BUFSIZE];
        int n2 = this.getMaxKey(0);
        int n3 = this.getMaxKey(1);
        int n4 = 0;
        do {
            byArray2 = (byArray2 = this.xtin.get(n4)) == null ? byArray3 : XTICompressor.compressXTINPage(byArray2, n4);
            this.flushBuffer(byArray2, BUFSIZE);
            byArray = this.xtic.get(n4);
            if (byArray == null) {
                byArray = byArray3;
            }
            this.flushBuffer(byArray, BUFSIZE);
        } while (++n4 <= n2 || n4 <= n3);
    }

    void flushToStream() throws IOException {
        if (this.isInterleaving) {
            this.flushInterleavingToStream();
            return;
        }
        if (this.twofilemode) {
            this.flushToStreamInTwoFileMode();
        } else {
            this.flushToStreamInOtherMode();
        }
    }

    private void flushToStreamInTwoFileMode() throws IOException {
        this.xtinstream.flushAllPagesInMemory();
        this.xticstream.flushAllPagesInMemory();
    }

    @Override
    public void close() {
        if (this.twofilemode) {
            if (this.xtinstream != null) {
                this.xtinstream.close();
            }
            if (this.xticstream != null) {
                this.xticstream.close();
            }
        }
        super.close();
    }

    private void flushToStreamInOtherMode() throws IOException {
        int n2;
        byte[] byArray = new byte[BUFSIZE];
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[8192];
        int n3 = this.getMaxKey(0);
        for (n2 = 0; n2 <= n3; ++n2) {
            byArray2 = this.xtin.get(n2);
            if (byArray2 == null) {
                byArray2 = byArray3;
            }
            this.flushBuffer(byArray2, BUFSIZE);
            System.arraycopy(byArray2, BUFSIZE, byArray, 0, BUFSIZE);
            this.flushBuffer(byArray, BUFSIZE);
        }
        n3 = this.getMaxKey(1);
        for (n2 = 0; n2 <= n3; ++n2) {
            byArray2 = this.xtic.get(n2);
            if (byArray2 == null) {
                byArray2 = byArray3;
            }
            this.flushBuffer(byArray2, BUFSIZE);
        }
    }

    private int getMaxKey(int n2) {
        Set<Integer> set = null;
        set = n2 == 0 ? this.xtin.keySet() : this.xtic.keySet();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(set);
        Collections.sort(arrayList);
        int n3 = arrayList.get(arrayList.size() - 1);
        return n3;
    }

    private byte[] readXTINPageData(XTIStream xTIStream, int n2, boolean bl) {
        if (n2 >= xTIStream.xtinPagesSize) {
            int[] nArray = xTIStream.xtinPages;
            xTIStream.xtinPages = new int[xTIStream.xtinPagesSize + 1024];
            System.arraycopy(nArray, 0, xTIStream.xtinPages, 0, xTIStream.xtinPagesSize);
            xTIStream.xtinPagesSize += 1024;
        }
        int n3 = xTIStream.xtinPages[n2];
        if (n2 == 0) {
            if (xTIStream.maxPageId == 0) {
                xTIStream.maxPageId += 2;
            }
            return xTIStream.load(0, 8192, bl);
        }
        if (n3 == 0) {
            xTIStream.xtinPages[n2] = n3 = xTIStream.maxPageId;
            xTIStream.maxPageId += 2;
        }
        return xTIStream.load(n3, 8192, bl);
    }

    byte[] readXTINPage(int n2, boolean bl) {
        if (this.scratchMode) {
            return this.readXTINPageData(this, n2, bl);
        }
        if (this.twofilemode) {
            return this.readXTINPageData(this.xtinstream, n2, bl);
        }
        if (!this.xtin.containsKey(n2)) {
            this.loadXTINPage(n2, true);
        }
        return this.xtin.get(n2);
    }

    byte[] readXTICPage(int n2, boolean bl) {
        byte[] byArray = this.getAllBytesFromStartPageNum(n2, bl);
        return byArray;
    }

    private byte[] getAllBytesFromStartPageNum(int n2, boolean bl) {
        boolean bl2 = false;
        byte[] byArray = this.getXTICBytes(n2, bl);
        bl2 = this.needReadNextXTICPage(byArray, n2);
        if (!bl2) {
            return byArray;
        }
        byte[][] byArray2 = this.addByteArray2Bytes(byArray, null);
        int n3 = 1;
        while (this.needReadNextXTICPage(byArray2[n3 - 1], n2)) {
            byArray = this.getXTICBytes(++n2, bl);
            byArray2 = this.addByteArray2Bytes(byArray, byArray2);
            ++n3;
        }
        int n4 = n3 * 4096;
        byte[] byArray3 = new byte[n4];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (i2 == 0) {
                System.arraycopy(byArray2[i2], 0, byArray3, 0, 4096);
                continue;
            }
            System.arraycopy(byArray2[i2], 5, byArray3, 4096 + (i2 - 1) * XTIUtil.getXTICSizePerPage(this.xticmode), XTIUtil.getXTICSizePerPage(this.xticmode));
        }
        return byArray3;
    }

    private byte[] getXTICBytes(int n2, boolean bl) {
        byte[] byArray;
        if (this.scratchMode || this.twofilemode) {
            return this.getXTICPageNumber(n2, bl);
        }
        if (!this.xtic.containsKey(n2)) {
            byArray = this.loadXTICPage(n2, bl);
        }
        byArray = this.xtic.get(n2);
        return byArray;
    }

    private boolean needReadNextXTICPage(byte[] byArray, int n2) {
        if (n2 >= this.zeroAvailByteStartPageNum && n2 <= this.zeroAvailByteEndPageNum) {
            return true;
        }
        int n3 = XTIUtil.byteArrayToInt(byArray, 0);
        int n4 = XTIUtil.getXTICSizePerPage(this.xticmode);
        int n5 = n4 - n3;
        return n5 == 0;
    }

    private byte[][] addByteArray2Bytes(byte[] byArray, byte[][] byArray2) {
        int n2 = 0;
        if (byArray2 == null) {
            byte[][] byArray3 = new byte[1][4096];
            System.arraycopy(byArray, 0, byArray3[0], 0, 4096);
            return byArray3;
        }
        n2 = byArray2.length;
        byte[][] byArray4 = new byte[++n2][4096];
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            System.arraycopy(byArray2[i2], 0, byArray4[i2], 0, 4096);
        }
        System.arraycopy(byArray, 0, byArray4[n2 - 1], 0, 4096);
        return byArray4;
    }

    private byte[] loadXTINPage(int n2, boolean bl) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (this.isInterleaving) {
            byArray = this.load(n2 * 2, bl);
            byArray3 = XTIDecompressor.uncompressXTINPage(byArray, n2);
        } else {
            byArray = this.load(n2 * 2, bl);
            byArray2 = this.load(n2 * 2 + 1, bl);
            byArray3 = new byte[8192];
            System.arraycopy(byArray, 0, byArray3, 0, BUFSIZE);
            System.arraycopy(byArray2, 0, byArray3, BUFSIZE, BUFSIZE);
        }
        this.xtin.put(n2, byArray3);
        return byArray3;
    }

    void setTotalXTINPages(int n2) {
        this.totalXTINPages = n2;
    }

    boolean isInterleaving() {
        return this.isInterleaving;
    }

    void setInterleaving(boolean bl) {
        this.isInterleaving = bl;
    }

    private byte[] loadXTICPage(int n2, boolean bl) {
        byte[] byArray = null;
        byArray = this.isInterleaving ? this.load(n2 * 2 + 1, bl) : this.load(this.totalXTINPages * 2 + n2, bl);
        this.xtic.put(n2, byArray);
        return byArray;
    }
}

