/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.IOException;
import java.util.Stack;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLLocator;
import oracle.xml.util.XMLUtil;
import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIContentManager;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIStream;
import oracle.xml.xti.XTIUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

public class XTIEncoder
extends XTIContentManager
implements ContentHandler,
ErrorHandler,
DTDHandler,
DeclHandler,
LexicalHandler,
XTIConstants {
    private Stack<ParentFChild> parentFChild = new Stack();
    private int previousXTINAddress = 0;
    private String xmlversion = null;
    private String standalone = null;
    private Locator locator = null;

    XTIEncoder(XTIStream xTIStream) {
        this.xtiStream = xTIStream;
        this.err = new XMLError();
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        System.arraycopy(cArray, n2, this.charBuffer, this.charLength, n3);
        this.charLength += n3;
    }

    @Override
    void unsetIsLastChildFlag(int n2) {
        int n3 = (n2 & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n3, true);
        int n4 = n2 & 0xFF;
        n4 = 32 * n4;
        byte by = byArray[n4];
        byArray[n4] = by = (byte)(by & 0xEF);
        this.xtiStream.setXTINPageNumber(n3, byArray);
    }

    private int getFirstChildInParentStack() {
        int n2 = this.parentFChild.size();
        if (n2 == 0) {
            return 0;
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            ParentFChild parentFChild = (ParentFChild)this.parentFChild.get(i2);
            if (parentFChild.getParent() != this.curParentAddress) continue;
            return parentFChild.getFirstChild();
        }
        return -1;
    }

    private void updateParentFirstChild(int n2) {
        if (n2 == 0) {
            return;
        }
        for (int i2 = this.parentFChild.size() - 1; i2 >= 0; --i2) {
            int n3;
            ParentFChild parentFChild = (ParentFChild)this.parentFChild.get(i2);
            if (parentFChild.getParent() != this.curParentAddress || (n3 = parentFChild.getFirstChild()) != -1) continue;
            parentFChild.setFirstChild(n2);
            break;
        }
    }

    private byte[] packXTINBytes12To27(byte[] byArray) throws SAXException {
        int n2;
        this.currentXTINAddress = this.getXTINAddress();
        this.updateParentFirstChild(this.currentXTINAddress);
        this.updateLastFirst4XTINLink(this.getFirstChildInParentStack(), this.currentXTINAddress);
        if (this.previousXTINAddress == 0 && this.parentFChild.size() != 0) {
            this.updateChildForXTIN(this.currentXTINAddress);
        }
        byte[] byArray2 = this.previousXTINAddress != 0 ? XTIUtil.intToByteArray(this.previousXTINAddress) : XTIUtil.intToByteArray(this.currentXTINAddress);
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            byArray[16 + n2] = byArray2[n2];
        }
        if (this.parentFChild.size() != 0) {
            n2 = this.parentFChild.peek().getParent();
            byArray2 = XTIUtil.intToByteArray(n2);
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                byArray[20 + i2] = byArray2[i2];
            }
        }
        if (this.previousXTINAddress != 0) {
            this.updateNextForXTIN(this.previousXTINAddress, this.currentXTINAddress);
        } else {
            this.updateNextForXTIN(this.currentXTINAddress, this.currentXTINAddress);
        }
        return byArray;
    }

    private void flushCharacters() throws SAXException {
        try {
            int n2;
            byte[] byArray = new byte[32];
            byArray[0] = this.cdata ? 4 : 3;
            this.xticmode = 2;
            String string = new String(this.charBuffer, 0, this.charLength);
            int[] nArray = this.getXTICTextAddress(this.getUTF8BytesSize(string));
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[8 + n2] = byArray2[n2];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[4 + n2] = byArray2[n2];
            }
            byArray = this.packXTINBytes12To27(byArray);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, true);
            this.previousXTINAddress = this.currentXTINAddress;
            this.charLength = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        int n2;
        if (this.xtiStream.isInterleaving()) {
            this.compression = (byte)(this.compression | 9);
        }
        this.xtinRootPageHeader[0] = (byte)(0x10 | this.compression);
        this.xtinRootPageHeader[1] = this.currentXTINArraySlot >= 256 ? (byte)0 : (byte)this.currentXTINArraySlot;
        byte[] byArray = XTIUtil.intToByteArray(++this.currentXTINpageNumber);
        for (n2 = 0; n2 < byArray.length; ++n2) {
            this.xtinRootPageHeader[4 + n2] = byArray[n2];
        }
        if (this.xtinSchemaHeaderFlag != 0) {
            this.xtinRootPageHeader[17] = this.xtinSchemaHeaderFlag;
            if (this.xmlencoding != null) {
                n2 = this.xmlencoding.length();
                int[] nArray = this.getXTICTextAddress(++n2);
                byArray = XTIUtil.intToByteArray(nArray[0]);
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.xtinRootPageHeader[13 + i2] = byArray[i2];
                }
                this.xtiStream.writeTextToAddress(nArray, this.xmlencoding);
            }
        }
        this.xtiStream.setXTINPageNumber(0, this.xtinRootPageHeader);
        this.xticRootPageHeader = this.xtiStream.getXTICPageNumber(0, true);
        this.xticRootPageHeader[0] = 1;
        byArray = XTIUtil.shortToByteArray(this.freeBytesQname);
        this.xticRootPageHeader[2] = byArray[0];
        this.xticRootPageHeader[3] = byArray[1];
        byArray = XTIUtil.intToByteArray(this.totalXTICPages);
        for (n2 = 0; n2 < byArray.length; ++n2) {
            this.xticRootPageHeader[4 + n2] = byArray[n2];
        }
        byArray = XTIUtil.intToByteArray(this.freeBytesText);
        for (n2 = 0; n2 < byArray.length; ++n2) {
            this.xticRootPageHeader[8 + n2] = byArray[n2];
        }
        byArray = XTIUtil.intToByteArray(this.lastTextPage);
        for (n2 = 0; n2 < byArray.length; ++n2) {
            this.xticRootPageHeader[12 + n2] = byArray[n2];
        }
        byArray = XTIUtil.intToByteArray(this.lastQnamePage);
        for (n2 = 0; n2 < byArray.length; ++n2) {
            this.xticRootPageHeader[16 + n2] = byArray[n2];
        }
        this.xtiStream.setXTICPageNumber(0, this.xticRootPageHeader);
        try {
            this.xtiStream.flushToStream();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.previousXTINAddress = this.parentFChild.pop().getParent();
        this.curParentAddress = this.parentFChild.peek().getParent();
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            int n2;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 7;
            this.xticmode = 2;
            int[] nArray = new int[]{this.getXTICTextAddress(this.getUTF8BytesSize(string2))[0], this.getXTICTextAddress(this.getUTF8BytesSize(string))[0]};
            this.xtiStream.writePIToAddress(nArray, string2, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[4 + n2] = byArray2[n2];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[8 + n2] = byArray2[n2];
            }
            byArray = this.packXTINBytes12To27(byArray);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            if (this.locator != null && this.locator instanceof Locator2) {
                this.xmlversion = ((Locator2)this.locator).getXMLVersion();
                if (this.xmlversion != null && this.xmlversion.length() > 0) {
                    this.compression = (byte)(this.compression | 4);
                    this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 1);
                }
                if (this.locator instanceof XMLLocator) {
                    if (this.xmlencoding == null) {
                        this.xmlencoding = ((XMLLocator)this.locator).getDeclEncoding();
                        if (this.xmlencoding != null && this.xmlencoding.length() > 0) {
                            this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 2);
                        }
                    }
                    if (this.standalone == null) {
                        this.standalone = ((XMLLocator)this.locator).getStandalone();
                        if (this.standalone != null && this.standalone.length() > 0) {
                            if (this.standalone.equals("yes")) {
                                this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 8);
                            } else if (this.standalone.equals("no")) {
                                this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 4);
                            }
                        }
                    }
                }
            }
            this.xtinRootPageHeader = this.xtiStream.getXTINPageNumber(0, true);
            byte[] byArray = new byte[32];
            byArray[0] = 9;
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.getFirstChildInParentStack(), this.currentXTINAddress);
            this.parentFChild.push(new ParentFChild(this.currentXTINAddress, -1));
            this.curParentAddress = this.parentFChild.peek().getParent();
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            int n2;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 1;
            byte[] byArray2 = this.getQNameAddress(string, XMLUtil.getPrefix(string3), string2, string3);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[4 + n2] = byArray2[n2];
            }
            byArray = this.packXTINBytes12To27(byArray);
            n2 = this.updateAttributeNode(attributes);
            byArray2 = XTIUtil.intToByteArray(n2);
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                byArray[28 + i2] = byArray2[i2];
            }
            this.parentFChild.push(new ParentFChild(this.currentXTINAddress, -1));
            this.curParentAddress = this.parentFChild.peek().getParent();
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, true);
            this.previousXTINAddress = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private int updateAttributeNode(Attributes attributes) throws XTIException {
        try {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            byte[] byArray = null;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                int n5;
                n4 = n3;
                n3 = this.getXTINAddress();
                if (i2 == 0) {
                    n2 = n3;
                }
                byArray = new byte[32];
                byArray[0] = 2;
                byte[] byArray2 = this.getQNameAddress(attributes.getURI(i2), XMLUtil.getPrefix(attributes.getQName(i2)), attributes.getLocalName(i2), attributes.getQName(i2));
                for (int i3 = 0; i3 < byArray2.length; ++i3) {
                    byArray[4 + i3] = byArray2[i3];
                }
                this.xticmode = 2;
                int[] nArray = this.getXTICTextAddress(this.getUTF8BytesSize(attributes.getValue(i2)));
                this.xtiStream.writeTextToAddress(nArray, attributes.getValue(i2));
                byArray2 = XTIUtil.intToByteArray(nArray[0]);
                for (n5 = 0; n5 < byArray2.length; ++n5) {
                    byArray[16 + n5] = byArray2[n5];
                }
                byArray2 = XTIUtil.intToByteArray(nArray[1]);
                for (n5 = 0; n5 < byArray2.length; ++n5) {
                    byArray[12 + n5] = byArray2[n5];
                }
                byArray2 = XTIUtil.intToByteArray(this.currentXTINAddress);
                for (n5 = 0; n5 < byArray2.length; ++n5) {
                    byArray[20 + n5] = byArray2[n5];
                }
                if (i2 != 0) {
                    this.updateNextAttributeForXTIN(n4, n3);
                }
                if (XMLUtil.getPrefix(attributes.getQName(i2)).equals("xmlns")) {
                    byArray[29] = 2;
                } else if (XMLUtil.getPrefix(attributes.getQName(i2)).length() == 0 && attributes.getLocalName(i2).equals("xmlns")) {
                    byArray[29] = 4;
                }
                this.xtiStream.writeToXTINAddress(n3, byArray, false);
            }
            return n2;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    private void updateNextAttributeForXTIN(int n2, int n3) {
        int n4 = n2 & 0xFF;
        int n5 = (n2 & 0x7FFFFF00) >>> 8;
        int n6 = n4 * 32 + 24;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n5, true);
        byArray[n6] = (byte)(n3 >>> 24 & 0xFF);
        byArray[n6 + 1] = (byte)(n3 >>> 16 & 0xFF);
        byArray[n6 + 2] = (byte)(n3 >>> 8 & 0xFF);
        byArray[n6 + 3] = (byte)(n3 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n5, byArray);
    }

    private void updateLastFirst4XTINLink(int n2, int n3) {
        if (n2 == 0) {
            n2 = n3;
        }
        int n4 = n3 & 0xFF;
        int n5 = (n3 & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n5, true);
        int n6 = n4 * 32 + 24;
        byArray[n6] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n6 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n6 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n6 + 3] = (byte)(n2 >>> 0 & 0xFF);
        int n7 = n2 & 0xFF;
        int n8 = (n2 & 0x7FFFFF00) >>> 8;
        int n9 = n7 * 32 + 16;
        if (n5 == n8) {
            byArray[n9] = (byte)(n3 >>> 24 & 0xFF);
            byArray[n9 + 1] = (byte)(n3 >>> 16 & 0xFF);
            byArray[n9 + 2] = (byte)(n3 >>> 8 & 0xFF);
            byArray[n9 + 3] = (byte)(n3 >>> 0 & 0xFF);
            this.xtiStream.setXTINPageNumber(n5, byArray);
        } else {
            this.xtiStream.setXTINPageNumber(n5, byArray);
            byte[] byArray2 = this.xtiStream.getXTINPageNumber(n8, true);
            byArray2[n9] = (byte)(n3 >>> 24 & 0xFF);
            byArray2[n9 + 1] = (byte)(n3 >>> 16 & 0xFF);
            byArray2[n9 + 2] = (byte)(n3 >>> 8 & 0xFF);
            byArray2[n9 + 3] = (byte)(n3 >>> 0 & 0xFF);
            this.xtiStream.setXTINPageNumber(n8, byArray2);
        }
    }

    private void updatePreviousForXTIN(int n2, int n3) {
        int n4 = n2 & 0xFF;
        int n5 = (n2 & 0x7FFFFF00) >>> 8;
        int n6 = n4 * 32 + 16;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n5, true);
        byArray[n6] = (byte)(n3 >>> 24 & 0xFF);
        byArray[n6 + 1] = (byte)(n3 >>> 16 & 0xFF);
        byArray[n6 + 2] = (byte)(n3 >>> 8 & 0xFF);
        byArray[n6 + 3] = (byte)(n3 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n5, byArray);
    }

    private void updateNextForXTIN(int n2, int n3) {
        int n4 = n2 & 0xFF;
        int n5 = (n2 & 0x7FFFFF00) >>> 8;
        int n6 = n4 * 32 + 24;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n5, true);
        byArray[n6] = (byte)(n3 >>> 24 & 0xFF);
        byArray[n6 + 1] = (byte)(n3 >>> 16 & 0xFF);
        byArray[n6 + 2] = (byte)(n3 >>> 8 & 0xFF);
        byArray[n6 + 3] = (byte)(n3 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n5, byArray);
        if (n2 != n3 && n2 != 0) {
            this.unsetIsLastChildFlag(n2);
        }
    }

    private void updateChildForXTIN(int n2) {
        int n3 = this.parentFChild.peek().getParent() & 0xFF;
        int n4 = (this.parentFChild.peek().getParent() & 0x7FFFFF00) >>> 8;
        int n5 = n3 * 32 + 12;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4, true);
        byArray[n5] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n2 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n4, byArray);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        try {
            int n4;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 8;
            this.xticmode = 2;
            String string = new String(cArray, n2, n3);
            int[] nArray = this.getXTICTextAddress(this.getUTF8BytesSize(string));
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n4 = 0; n4 < byArray2.length; ++n4) {
                byArray[8 + n4] = byArray2[n4];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n4 = 0; n4 < byArray2.length; ++n4) {
                byArray[4 + n4] = byArray2[n4];
            }
            byArray = this.packXTINBytes12To27(byArray);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.cdata = false;
    }

    @Override
    public void endDTD() throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void endEntity(String string) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.cdata = true;
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void startEntity(String string) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    private void loadPage(int n2, int n3) {
        if (n2 == 0) {
            this.xtiStream.readXTINPage(n3, true);
        } else if (n2 == 1) {
            this.xtiStream.readXTICPage(n3, true);
        }
    }

    class ParentFChild {
        int iparent;
        int ifchild;

        ParentFChild(int n2, int n3) {
            this.iparent = n2;
            this.ifchild = n3;
        }

        void setParent(int n2) {
            this.iparent = n2;
        }

        void setFirstChild(int n2) {
            this.ifchild = n2;
        }

        int getParent() {
            return this.iparent;
        }

        int getFirstChild() {
            return this.ifchild;
        }
    }
}

