/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import oracle.xml.jaxp.JXUtil;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.util.NSNameImpl;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;

public class XSLOutput
extends XSLNode
implements XSLConstants {
    private String method;
    private String version;
    private String encoding;
    private boolean bom;
    private boolean setbommanually = false;
    private String standalone;
    private String mediaType;
    private int indent;
    private int omitXMLDecl;
    private boolean ignoreOmitXMLDecl;
    private String doctypePublic;
    private String doctypeSystem;
    private Set<String> cdataSectionElements;
    private boolean isChMapped = false;
    private HashMap mappings;
    private Vector calledCharacterMaps;
    private NSName name2;
    private boolean ict = true;
    private boolean eua = true;
    private String normunicode10gr1 = "no";
    private String normunicode = "NONE";
    public static final String NFC = "NFC";
    public static final String NFD = "NFD";
    public static final String NFKC = "NFKC";
    public static final String NFKD = "NFKD";
    public static final String FULLY_NORMALIZED = "FULLY-NORMALIZED";
    public static final String NONE = "NONE";
    public static final int INONE = 65536;
    public static final int IFULLY_NORMALIZED = 65537;
    static final String INCLUDE_CONTENT_TYPE = "include-content-type";
    static final String ESCAPE_URI_ATTRIBUTES = "escape-uri-attributes";
    static final String NORMALIZATION_FORM = "normalization-form";
    static final String NORMALIZE_UNICODE = "normalize-unicode";
    static final String BYTE_ORDER_MARK = "byte-order-mark";
    private String oraHref;
    private String oraName;
    private boolean oraOmitXMLEncoding;
    private HashMap outProps;
    static final String HTML = "html";
    static final String XML = "xml";
    static final String TEXT = "text";
    static final String XHTML = "xhtml";
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String OMIT = "omit";
    private static final String ORAHREF = "href";
    private static final String OMIT_XML_ENCODING = "omit-xml-encoding";
    private static final String XSLOUTPUT = "xsl:output";
    private Properties m_props;
    private Properties m_defaultProps;

    public XSLOutput(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
        this.initialize();
    }

    void initialize() {
        this.method = "";
        this.version = "";
        this.encoding = "";
        this.bom = false;
        this.setbommanually = false;
        this.standalone = "";
        this.mediaType = "";
        this.doctypePublic = "";
        this.doctypeSystem = "";
        this.outProps = new HashMap(20);
        this.omitXMLDecl = -1;
        this.ignoreOmitXMLDecl = false;
        this.indent = -1;
        this.name2 = null;
        this.ict = true;
        this.eua = true;
        this.normunicode = NONE;
        this.normunicode10gr1 = NO;
        this.oraName = "";
        this.oraOmitXMLEncoding = false;
        this.m_defaultProps = new Properties();
        this.m_props = new Properties(this.m_defaultProps);
        JXUtil.setDefaultProps(this.m_defaultProps, XML);
    }

    boolean isCDATASectionElement() {
        return this.cdataSectionElements != null;
    }

    boolean checkCDATASectionElement(String string) {
        if (this.cdataSectionElements == null) {
            return false;
        }
        return this.cdataSectionElements.contains(string);
    }

    String getOraHref() {
        return this.oraHref;
    }

    void setOraHref(String string) {
        this.oraHref = string;
    }

    boolean getOraOmitXMLEncoding() {
        return this.oraOmitXMLEncoding;
    }

    void setOraOmitXMLEncoding(boolean bl) {
        this.oraOmitXMLEncoding = bl;
    }

    NSName getName2() {
        return this.name2;
    }

    String getName() {
        return this.oraName;
    }

    void setName(String string) {
        this.oraName = string;
    }

    String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    Set<String> getCdataSectionElements() {
        return this.cdataSectionElements;
    }

    void setCdataSectionElements(Set<String> set) {
        this.cdataSectionElements = set;
    }

    String getVersion() {
        if (this.version == "") {
            if (this.method == HTML) {
                this.version = "4.0";
            } else if (this.method != "") {
                this.version = "1.0";
            } else {
                return "1.0";
            }
        }
        return this.version;
    }

    void setVersion(String string) {
        this.version = string != null ? string.intern() : "";
    }

    boolean isEncodingSpecified() {
        return this.encoding != "";
    }

    String getEncoding() {
        if (this.encoding == "") {
            return "UTF-8";
        }
        return this.encoding;
    }

    void setEncoding(String string) {
        this.encoding = string != null ? string.intern() : "";
        this.setDefaultBOM();
    }

    void setBOM(boolean bl) {
        this.bom = bl;
        this.setbommanually = true;
    }

    boolean getBOM() {
        return this.bom;
    }

    private void setDefaultBOM() {
        if (this.encoding.equalsIgnoreCase("UTF-16") && this.xss.getXSLTVersion() >= 20 && !this.setbommanually) {
            this.bom = true;
        }
    }

    String getStandalone() {
        if (this.standalone.equals(OMIT)) {
            this.standalone = "";
        }
        return this.standalone;
    }

    void setStandalone(String string) {
        this.standalone = string != null ? string.intern() : "";
    }

    boolean getOmitXMLDecl() {
        if (this.omitXMLDecl == -1) {
            this.omitXMLDecl = this.method == XML || this.method == "" ? 0 : 1;
        }
        return this.omitXMLDecl == 1;
    }

    void setOmitXMLDecl(boolean bl) {
        this.omitXMLDecl = bl ? 1 : 0;
    }

    String getDoctypePublic() {
        return this.doctypePublic;
    }

    void setDoctypePublic(String string) {
        this.doctypePublic = string != null ? string.intern() : "";
    }

    String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    void setDoctypeSystem(String string) {
        this.doctypeSystem = string != null ? string.intern() : "";
    }

    boolean getIndent() {
        if (this.indent == -1) {
            if (this.method == XML || this.method == "") {
                this.indent = 0;
            } else if (this.method == HTML) {
                this.indent = 1;
            }
        }
        return this.indent == 1;
    }

    void setIndent(boolean bl) {
        this.indent = bl ? 1 : 0;
    }

    String getMediaType() {
        if (this.mediaType == "") {
            if (this.method == HTML) {
                this.mediaType = "text/html";
            } else if (this.method == TEXT) {
                this.mediaType = "text/plain";
            } else if (this.method == XHTML) {
                this.mediaType = "text/html";
            } else if (this.method != "") {
                this.mediaType = "text/xml";
            } else {
                return "text/xml";
            }
        }
        return this.mediaType;
    }

    void setMediaType(String string) {
        this.mediaType = string != null ? string.intern() : "";
    }

    boolean getIncludeContentType() {
        return this.ict;
    }

    void setIncludeContentType(boolean bl) {
        this.ict = bl;
    }

    boolean getEscapeURIAttributes() {
        return this.eua;
    }

    void setEscapeURIAttributes(boolean bl) {
        this.eua = bl;
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "" && string3.equals("use-character-maps")) {
            this.calledCharacterMaps = this.processUseCharacterMaps(string4);
        }
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "") {
            this.outProps.put(string3, string4);
        } else {
            super.setAttribute(string, string2, string3, string4);
        }
    }

    @Override
    public String getAttribute(String string, String string2) throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "") {
            return (String)this.outProps.get(string2);
        }
        return super.getAttribute(string, string2);
    }

    @Override
    public void startContent() throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java") {
            if (this.getAttribute("", "name") == null) {
                this.xss.err.error2(22220, 1, "name", this.getQualifiedName());
            }
            if (this.getAttribute("", ORAHREF) == null) {
                this.xss.err.error2(22220, 2, ORAHREF, this.getQualifiedName());
            }
        }
    }

    void merge(XSLOutput xSLOutput) throws XSLException {
        String string = xSLOutput.getAttribute("", "name");
        if (string != null) {
            this.name2 = this.resolveQname(string);
            if (this.name2 == null) {
                this.xss.err.error3(22257, 1, string, this.getQualifiedName(), "name");
            }
        }
        if ((string = xSLOutput.getAttribute("", "method")) != null) {
            this.method = string.intern();
            if (this.method != XML && this.method != HTML && this.method != XHTML && this.method != TEXT && !this.method.contains(":")) {
                this.xss.err.error3(22222, 1, XSLOUTPUT, "method", this.method);
            }
            this.m_props.put("method", this.method);
            JXUtil.setDefaultProps(this.m_defaultProps, this.method);
        }
        if ((string = xSLOutput.getAttribute("", "version")) != null) {
            this.version = string;
            this.m_props.put("version", this.version);
        }
        if ((string = xSLOutput.getAttribute("", "encoding")) != null) {
            this.encoding = string;
            if (!(this.xss.getXSLTVersion() < 20 || this.encoding.equalsIgnoreCase("UTF-8") || this.encoding.equalsIgnoreCase("UTF-16") || this.ignoreOmitXMLDecl)) {
                this.omitXMLDecl = 0;
                this.ignoreOmitXMLDecl = true;
            }
            this.setDefaultBOM();
            this.m_props.put("encoding", this.encoding);
        }
        if ((string = xSLOutput.getAttribute("", BYTE_ORDER_MARK)) != null) {
            if ((string = string.intern()) == YES) {
                this.bom = true;
            } else if (string == NO) {
                this.bom = false;
            } else {
                this.xss.err.error3(22222, 1, XSLOUTPUT, BYTE_ORDER_MARK, string);
            }
            this.setbommanually = true;
        }
        if ((string = xSLOutput.getAttribute("", "standalone")) != null) {
            if ((string = string.intern()) != YES && string != NO && string != OMIT) {
                this.xss.err.error3(22222, 1, XSLOUTPUT, "standalone", string);
            }
            this.standalone = string;
            if (this.xss.getXSLTVersion() >= 20 && !this.ignoreOmitXMLDecl) {
                this.omitXMLDecl = 0;
                this.ignoreOmitXMLDecl = true;
            }
            this.m_props.put("standalone", this.standalone);
        }
        if ((string = xSLOutput.getAttribute("", "media-type")) != null) {
            this.mediaType = string;
            this.m_props.put("media-type", this.mediaType);
        }
        if ((string = xSLOutput.getAttribute("", "doctype-public")) != null) {
            this.doctypePublic = string;
            this.m_props.put("doctype-public", this.doctypePublic);
        }
        if ((string = xSLOutput.getAttribute("", "doctype-system")) != null) {
            this.doctypeSystem = string;
            this.m_props.put("doctype-system", this.doctypeSystem);
        }
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java") {
            this.oraHref = xSLOutput.getAttribute("", ORAHREF);
            this.oraName = xSLOutput.getAttribute("", "name");
            if (this.oraName == null) {
                this.oraName = "";
            }
        }
        if ((string = xSLOutput.getAttribute("", "indent")) != null) {
            this.m_props.put("indent", string);
            string = string.intern();
            if (string == YES) {
                this.indent = 1;
            } else if (string == NO) {
                this.indent = 0;
            } else if (string != TRUE && string != FALSE) {
                this.xss.err.error3(22222, 1, XSLOUTPUT, "indent", string);
            }
        }
        if ((string = xSLOutput.getAttribute("", "omit-xml-declaration")) != null) {
            this.m_props.put("omit-xml-declaration", string);
            if (!this.ignoreOmitXMLDecl) {
                if ((string = string.intern()) == YES) {
                    this.omitXMLDecl = 1;
                } else if (string == NO) {
                    this.omitXMLDecl = 0;
                } else {
                    this.xss.err.error3(22222, 1, XSLOUTPUT, "omit-xml-declaration", string);
                }
            }
        }
        if ((string = xSLOutput.getAttribute("", OMIT_XML_ENCODING)) != null) {
            this.m_props.put(OMIT_XML_ENCODING, string);
            string = string.intern();
            if (string == YES) {
                this.oraOmitXMLEncoding = true;
            } else if (string == NO) {
                this.oraOmitXMLEncoding = false;
            }
        }
        if (this.xss.getXSLTVersion() == 10) {
            this.ict = true;
            this.normunicode = NONE;
            this.normunicode10gr1 = NO;
            this.eua = false;
        } else if (this.xss.getXSLTVersion() >= 20) {
            string = xSLOutput.getAttribute("", INCLUDE_CONTENT_TYPE);
            if (string != null && (string = string.intern()) != YES) {
                if (string == NO) {
                    this.ict = false;
                } else {
                    this.xss.err.error3(22222, 1, XSLOUTPUT, INCLUDE_CONTENT_TYPE, string);
                }
            }
            if ((string = xSLOutput.getAttribute("", NORMALIZATION_FORM)) != null) {
                if ((string = string.intern()) != NFC && string != NFD && string != NFKC && string != NFKD && !string.equalsIgnoreCase(FULLY_NORMALIZED) && !string.equalsIgnoreCase(NONE)) {
                    this.xss.err.error3(22222, 1, XSLOUTPUT, NORMALIZATION_FORM, string);
                }
                this.normunicode = string;
            }
            if (XMLParser.getIs1010Compatible() && (string = xSLOutput.getAttribute("", NORMALIZE_UNICODE)) != null) {
                this.normunicode10gr1 = string;
            }
            if ((string = xSLOutput.getAttribute("", ESCAPE_URI_ATTRIBUTES)) != null && (string = string.intern()) == NO) {
                this.eua = false;
            }
            if ((string = xSLOutput.getAttribute("", "use-character-maps")) != null) {
                this.calledCharacterMaps = this.processUseCharacterMaps(string);
                this.makeCharacterMaps(this.calledCharacterMaps);
            }
        }
        String string2 = xSLOutput.getAttribute("", "cdata-section-elements");
        if (string2 != null) {
            if (this.prefixHash == null) {
                if (xSLOutput.prefixHash != null) {
                    this.prefixHash = (HashMap)xSLOutput.prefixHash.clone();
                }
            } else if (xSLOutput.prefixHash != null) {
                for (String string3 : xSLOutput.prefixHash.keySet()) {
                    String string4 = (String)xSLOutput.prefixHash.get(string3);
                    this.prefixHash.put(string3, string4);
                }
            }
            this.cdataSectionElements = this.processCdataSectionElement(this.cdataSectionElements, xSLOutput, string2);
            string2 = this.convertCDataSecElements2QNameList(this.cdataSectionElements);
            this.m_props.put("cdata-section-elements", string2);
        }
    }

    private String convertCDataSecElements2QNameList(Set<String> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        String string = "";
        for (String string2 : set) {
            string = string + string2 + " ";
        }
        string = string.trim();
        return string;
    }

    private boolean isJAXPQualifiedName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char c2 = string.charAt(0);
        return c2 == '{';
    }

    Set<String> processCdataSectionElement(Set<String> set, XSLOutput xSLOutput, String string) throws XSLException {
        int n2;
        if (set == null) {
            set = new HashSet<String>(20);
        }
        int n3 = 0;
        do {
            String string2;
            String string3 = (n2 = string.indexOf(32, n3)) == -1 ? string.substring(n3, string.length()) : string.substring(n3, n2);
            n3 = n2 + 1;
            if (this.isJAXPQualifiedName(string3)) {
                string2 = string3;
            } else if (string3.indexOf(58) >= 0) {
                NSNameImpl nSNameImpl = (NSNameImpl)xSLOutput.resolveQname(string3);
                if (nSNameImpl == null) {
                    this.xss.err.error3(22257, 1, string3, this.getQualifiedName(), "cdata-section-elements");
                    string2 = null;
                } else {
                    string2 = nSNameImpl.getJAXPQualifiedName();
                }
            } else {
                string2 = string3;
            }
            set.add(string2);
        } while (n2 != -1);
        return set;
    }

    Vector getCalledUCM() {
        return this.calledCharacterMaps;
    }

    void setCalledUCM(Vector vector) {
        this.calledCharacterMaps = vector;
    }

    void makeCharacterMaps(Vector vector) throws XSLException {
        int n2;
        this.xss.expandedCharacterMaps = null;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            this.xss.getCharacterMap((NSName)vector.get(n2));
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            this.xss.expandedCharacterMaps.add(this.calledCharacterMaps.get(n2));
        }
        Properties properties = this.xss.mergeCharacterMap();
        this.isChMapped = true;
        this.makeCharacterMap(properties);
    }

    Vector mergeCharacterMaps(Vector vector, Vector vector2) {
        if (vector2 == null || vector2.size() == 0) {
            return vector;
        }
        if (vector == null || vector.size() == 0) {
            return vector2;
        }
        int n2 = vector.size();
        vector.setSize(n2 + vector2.size());
        int n3 = 0;
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            int n4;
            NSName nSName = (NSName)vector2.get(i2);
            for (n4 = 0; n4 < n2; ++n4) {
                NSName nSName2 = (NSName)vector.get(n4);
                if (nSName2 != nSName) continue;
                ++n3;
                break;
            }
            if (n4 != n2) continue;
            vector.set(n2 + i2 - n3, nSName);
        }
        vector.setSize(n2 + vector2.size() - n3);
        return vector;
    }

    private void makeCharacterMap(Properties properties) {
        int n2 = properties.size();
        char[] cArray = new char[n2];
        String[] stringArray = new String[n2];
        Enumeration<?> enumeration = properties.propertyNames();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            cArray[n3] = string.toCharArray()[0];
            stringArray[n3++] = (String)properties.get(string);
        }
        this.mappings = new HashMap(n2);
        for (n3 = 0; n3 < n2; ++n3) {
            this.mappings.put(new Character(cArray[n3]), stringArray[n3]);
        }
    }

    boolean isCharacterMapped() {
        return this.isChMapped;
    }

    HashMap getMappings() {
        return this.mappings;
    }

    int normalizationForm() {
        if (XMLParser.getIs1010Compatible() && this.normunicode10gr1.intern() == YES) {
            return 1;
        }
        return FNUtil.getUNFMode(this.normunicode);
    }

    void setNormalizationForm(String string) {
        this.normunicode = string != null ? string.intern() : NONE;
    }

    @Override
    void printAttributes(PrintWriter printWriter) {
        super.printAttributes(printWriter);
        HashMap hashMap = this.attrHash;
        this.attrHash = this.outProps;
        super.printAttributes(printWriter);
        this.attrHash = hashMap;
    }

    @Override
    public void finalizeXSLNode() throws XSLException, XQException {
        super.finalizeXSLNode();
        if (this.calledCharacterMaps != null) {
            int n2 = this.calledCharacterMaps.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.xss.checkCharacterMap((NSName)this.calledCharacterMaps.get(i2));
            }
        }
    }

    public Properties getDefaultProps() {
        return this.m_defaultProps;
    }

    public Properties getProps() {
        return this.m_props;
    }

    public void setProps(Properties properties) {
        this.m_props = properties;
        Enumeration<?> enumeration = this.m_props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = enumeration.nextElement().toString();
            if (string2.equals("method")) {
                this.method = this.m_props.getProperty("method");
                if (this.method != null) {
                    this.method = this.method.intern();
                    if (this.method != XML && this.method != HTML && this.method != XHTML && this.method != TEXT && !this.method.contains(":")) {
                        this.xss.err.error3(22222, 1, XSLOUTPUT, "method", this.method);
                    }
                    JXUtil.setDefaultProps(this.m_defaultProps, this.method);
                    continue;
                }
                this.method = "";
                continue;
            }
            if (string2.equals("version")) {
                this.version = this.m_props.getProperty("version");
                if (this.version != null) {
                    this.version = this.version.intern();
                    continue;
                }
                this.version = "";
                continue;
            }
            if (string2.equals("encoding")) {
                this.encoding = (String)this.m_props.get("encoding");
                this.encoding = this.encoding != null ? this.encoding.intern() : "";
                if (!(this.xss.getXSLTVersion() < 20 || this.encoding.equalsIgnoreCase("UTF-8") || this.encoding.equalsIgnoreCase("UTF-16") || this.ignoreOmitXMLDecl)) {
                    this.omitXMLDecl = 0;
                    this.ignoreOmitXMLDecl = true;
                }
                this.setDefaultBOM();
                continue;
            }
            if (string2.equals(BYTE_ORDER_MARK)) {
                String string3 = this.m_props.getProperty(BYTE_ORDER_MARK);
                if ((string3 = string3.intern()) == YES) {
                    this.bom = true;
                } else if (string3 == NO) {
                    this.bom = false;
                } else {
                    this.xss.err.error3(22222, 1, XSLOUTPUT, BYTE_ORDER_MARK, string3);
                }
                this.setbommanually = true;
                continue;
            }
            if (string2.equals("standalone")) {
                this.standalone = this.m_props.getProperty("standalone");
                if (this.standalone != null) {
                    this.standalone = this.standalone.intern();
                    if (this.standalone != YES && this.standalone != NO && this.standalone != OMIT) {
                        this.xss.err.error3(22222, 1, XSLOUTPUT, "standalone", this.standalone);
                    }
                    if (this.xss.getXSLTVersion() < 20 || this.ignoreOmitXMLDecl) continue;
                    this.omitXMLDecl = 0;
                    this.ignoreOmitXMLDecl = true;
                    continue;
                }
                this.standalone = "";
                continue;
            }
            if (string2.equals("media-type")) {
                this.mediaType = this.m_props.getProperty("media-type");
                if (this.mediaType != null) {
                    this.mediaType = this.mediaType.intern();
                    continue;
                }
                this.mediaType = "";
                continue;
            }
            if (string2.equals("doctype-public")) {
                this.doctypePublic = this.m_props.getProperty("doctype-public");
                if (this.doctypePublic != null) {
                    this.doctypePublic = this.doctypePublic.intern();
                    continue;
                }
                this.doctypePublic = "";
                continue;
            }
            if (string2.equals("doctype-system")) {
                this.doctypeSystem = this.m_props.getProperty("doctype-system");
                if (this.doctypeSystem != null) {
                    this.doctypeSystem = this.doctypeSystem.intern();
                    continue;
                }
                this.doctypeSystem = "";
                continue;
            }
            if (string2.equals("indent")) {
                string = this.m_props.getProperty("indent");
                if (string == null) continue;
                if ((string = string.intern()) == YES) {
                    this.indent = 1;
                    continue;
                }
                if (string == NO) {
                    this.indent = 0;
                    continue;
                }
                if (string == TRUE || string == FALSE) continue;
                this.xss.err.error3(22222, 1, XSLOUTPUT, "indent", string);
                continue;
            }
            if (string2.equals("omit-xml-declaration")) {
                string = this.m_props.getProperty("omit-xml-declaration");
                if (string == null) continue;
                string = string.intern();
                if (this.ignoreOmitXMLDecl) continue;
                if (string == YES) {
                    this.omitXMLDecl = 1;
                    continue;
                }
                if (string == NO) {
                    this.omitXMLDecl = 0;
                    continue;
                }
                this.xss.err.error3(22222, 1, XSLOUTPUT, "omit-xml-declaration", string);
                continue;
            }
            if (string2.equals(NORMALIZATION_FORM)) {
                string = this.m_props.getProperty(NORMALIZATION_FORM);
                this.normunicode = NONE;
                if (string == null) continue;
                if ((string = string.intern()) != NFC && string != NFD && string != NFKC && string != NFKD && !string.equalsIgnoreCase(FULLY_NORMALIZED) && !string.equalsIgnoreCase(NONE)) {
                    this.xss.err.error3(22222, 1, XSLOUTPUT, NORMALIZATION_FORM, string);
                }
                this.normunicode = string;
                continue;
            }
            if (XMLParser.getIs1010Compatible() && string2.equals(NORMALIZE_UNICODE)) {
                string = this.m_props.getProperty(NORMALIZE_UNICODE);
                if (string != null) {
                    this.normunicode10gr1 = string.intern();
                    continue;
                }
                this.normunicode10gr1 = NO;
                continue;
            }
            if (!string2.equals("cdata-section-elements")) continue;
            string = this.m_props.getProperty("cdata-section-elements");
            try {
                if (string == null) continue;
                this.cdataSectionElements = this.processCdataSectionElement(this.cdataSectionElements, this, string);
            }
            catch (XSLException xSLException) {}
        }
    }
}

