/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.util.GregorianCalendar;
import oracle.xml.common.format.DateTimeFormatter;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class FNDateFormat
extends OXMLFunction {
    int flag;
    DateFormatter formatter;

    FNDateFormat(int n2) {
        if (n2 <= 0 || n2 >= 4) {
            throw new IllegalArgumentException();
        }
        this.flag = n2;
        this.formatter = new DateFormatter();
    }

    @Override
    public String getFunctionName() {
        if (this.flag == 1) {
            return "format-time";
        }
        if (this.flag == 2) {
            return "format-date";
        }
        return "format-dateTime";
    }

    @Override
    public int getNumberArgs() {
        return 2;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.getConstantType(2, 1);
    }

    @Override
    public OXMLSequenceType getArgType(int n2) {
        if (n2 == 0) {
            if (this.flag == 1) {
                return OXMLSequenceType.getConstantType(2, 8);
            }
            if (this.flag == 2) {
                return OXMLSequenceType.getConstantType(2, 9);
            }
            return OXMLSequenceType.getConstantType(2, 7);
        }
        return OXMLSequenceType.getConstantType(2, 1);
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            return oXMLSequence3;
        }
        OXMLItem oXMLItem2 = FNUtil.getSingleItem(oXMLSequence2);
        String string = oXMLItem2.getString();
        String string2 = this.format(oXMLItem, string, null, null, null);
        OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
        oXMLItem3.setString(OXMLSequenceType.TSTRING, string2);
        oXMLSequence3.appendItem(oXMLItem3);
        return oXMLSequence3;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length == 2) {
            return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
        }
        if (oXMLSequenceArray.length != 5) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[0]);
        if (oXMLItem == null) {
            return oXMLSequence;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        OXMLItem oXMLItem2 = FNUtil.getSingleItem(oXMLSequenceArray[1]);
        String string4 = oXMLItem2.getString();
        oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[2]);
        if (oXMLItem2 != null) {
            string = oXMLItem2.getString();
        }
        if ((oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[3])) != null) {
            string2 = oXMLItem2.getString();
        }
        if ((oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[4])) != null) {
            string3 = oXMLItem2.getString();
        }
        String string5 = this.format(oXMLItem, string4, string, string2, string3);
        OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
        oXMLItem3.setString(OXMLSequenceType.TSTRING, string5);
        oXMLSequence.appendItem(oXMLItem3);
        return oXMLSequence;
    }

    private String format(OXMLItem oXMLItem, String string, String string2, String string3, String string4) throws XQException {
        GregorianCalendar gregorianCalendar = oXMLItem.getCalendar();
        boolean bl = oXMLItem.hasTimeZone();
        return this.formatter.format(gregorianCalendar, string, string2, string3, string4, this.flag, bl);
    }

    static class DateFormatter
    extends DateTimeFormatter<XQException> {
        @Override
        public XQException createInvalidPictureStringException(String string) {
            return new XQException(string);
        }

        @Override
        public XQException createComponentNotAvailableException(String string) {
            return new XQException(string);
        }

        @Override
        public XQException notSupported(String string) {
            return new XQException(string);
        }
    }
}

